/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.facade;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.IEntityOperateService;
import kd.bos.entity.operate.OperateLog;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.facade.FacadeResult;
import kd.bos.facade.entity.IEntityLifecycleFacade;
import kd.bos.govern.timeout.TimeoutHandleFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.operation.UnSubmit;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.facade.entity.SendWorkFlowMsgFacade;
import kd.bos.workflow.facade.entity.WfAssignPersonsFacade;
import kd.bos.workflow.facade.entity.WfCanWithdrawValidatorFacade;
import kd.bos.workflow.facade.entity.WfSensitiveChangeFacade;
import kd.bos.workflow.service.WfJobThreadTruck;
import org.apache.commons.beanutils.MethodUtils;

public class EntityFacadeForWorkflowImpl
implements IEntityLifecycleFacade {
    private static Log logger = LogFactory.getLog(EntityFacadeForWorkflowImpl.class);
    private OperateLog operateLog;
    private OperateOption option;
    private String operationKey;
    private OperationResult operationResult;
    private DynamicObject[] dataEntities;
    private MainEntityType mainEntityType;
    private boolean invokeByIds;
    private List<AbstractValidator> validators;
    private Map<String, Object> operateMetaMap;
    private IEntityOperateService entityOperateService;
    private boolean isInitDataSucess;

    private boolean initDataSucess(Map<String, Object> params) {
        if (null == params || params.isEmpty()) {
            return false;
        }
        this.operateLog = (OperateLog)params.get("operateLog");
        this.option = (OperateOption)params.get("option");
        this.operationKey = (String)params.get("operationKey");
        this.operationResult = (OperationResult)params.get("operationResult");
        this.dataEntities = (DynamicObject[])params.get("dataEntities");
        this.mainEntityType = (MainEntityType)params.get("mainEntityType");
        if (this.mainEntityType == null) {
            this.mainEntityType = (MainEntityType)params.get("billEntityType");
        }
        this.invokeByIds = false;
        Object invokeByIdsObj = params.get("invokeByIds");
        if (null != invokeByIdsObj) {
            this.invokeByIds = (Boolean)invokeByIdsObj;
        }
        this.validators = (List)params.get("validators");
        this.operateMetaMap = (Map)params.get("operateMetaMap");
        this.entityOperateService = (IEntityOperateService)params.get("owner");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FacadeResult doExecute(Map<String, Object> params) {
        boolean flag = TimeoutHandleFactory.get().getTimeoutMarker();
        if (!flag) {
            TimeoutHandleFactory.get().doTimeoutMarker(true);
        }
        try {
            HashMap opResultMap;
            boolean canRunWf = WfConfigurationUtil.canRunWorkflow();
            if (!canRunWf) {
                FacadeResult facadeResult = null;
                return facadeResult;
            }
            this.isInitDataSucess = this.initDataSucess(params);
            if (!this.isInitDataSucess) {
                FacadeResult facadeResult = null;
                return facadeResult;
            }
            FacadeResult result = null;
            WfSensitiveChangeFacade wfSensitiveChangeFacade = new WfSensitiveChangeFacade(this.operateLog, this.option, this.operationKey, this.operationResult, this.dataEntities, this.mainEntityType, this.invokeByIds);
            result = wfSensitiveChangeFacade.wfSensitiveChange();
            if (null != this.operationResult) {
                opResultMap = this.operationResult.getCustomData();
                if (null == opResultMap) {
                    opResultMap = new HashMap(3);
                }
                opResultMap.putAll(this.option.getVariables());
                this.operationResult.setCustomData(opResultMap);
            }
            if (result.getCode() == 6) {
                result.setSuccess(true);
                opResultMap = result;
                return opResultMap;
            }
            WfAssignPersonsFacade wfAssignPersonsFacade = new WfAssignPersonsFacade(this.operateLog, this.option, this.operationKey, this.operationResult, this.dataEntities, this.mainEntityType, this.invokeByIds);
            result = wfAssignPersonsFacade.wfAssignPersons();
            logger.info("EntityFacadeForWorkflowImpl.wfAssignPersons option.getVariables():" + this.option.getVariables());
            if (null != this.operationResult) {
                logger.info("EntityFacadeForWorkflowImpl.wfAssignPersons operationResult:" + this.operationResult.isSuccess() + ";isNeedWfAssignPersons:" + this.operationResult.isNeedWfAssignPersons());
                HashMap opResultMap2 = this.operationResult.getCustomData();
                if (null == opResultMap2) {
                    opResultMap2 = new HashMap(3);
                }
                opResultMap2.putAll(this.option.getVariables());
                this.operationResult.setCustomData(opResultMap2);
                logger.info("EntityFacadeForWorkflowImpl.wfAssignPersons operationResult.getCustomData:" + this.operationResult.getCustomData());
            }
            result.setSuccess(true);
            if (result.getCode() != 6) {
                result.setCode(3);
            }
            FacadeResult facadeResult = result;
            return facadeResult;
        }
        finally {
            if (!flag) {
                TimeoutHandleFactory.get().doTimeoutMarker(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FacadeResult callOperation(Map<String, Object> params) {
        boolean flag = TimeoutHandleFactory.get().getTimeoutMarker();
        if (!flag) {
            TimeoutHandleFactory.get().doTimeoutMarker(true);
        }
        try {
            this.isInitDataSucess = this.initDataSucess(params);
            if (!this.isInitDataSucess) {
                FacadeResult facadeResult = null;
                return facadeResult;
            }
            DynamicObject[] objs = (DynamicObject[])params.get("objs");
            SendWorkFlowMsgFacade facade = new SendWorkFlowMsgFacade(this.operateLog, objs, this.operationKey, this.option);
            FacadeResult facadeResult = facade.callOperation();
            return facadeResult;
        }
        finally {
            if (!flag) {
                TimeoutHandleFactory.get().doTimeoutMarker(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FacadeResult addDefaultValidator(Map<String, Object> params) {
        boolean flag = TimeoutHandleFactory.get().getTimeoutMarker();
        if (!flag) {
            TimeoutHandleFactory.get().doTimeoutMarker(true);
        }
        try {
            boolean canRunWf = WfConfigurationUtil.canRunWorkflow();
            if (!canRunWf) {
                FacadeResult facadeResult = null;
                return facadeResult;
            }
            this.isInitDataSucess = this.initDataSucess(params);
            if (!this.isInitDataSucess) {
                FacadeResult facadeResult = null;
                return facadeResult;
            }
            if (this.entityOperateService instanceof UnSubmit) {
                WfCanWithdrawValidatorFacade facade = new WfCanWithdrawValidatorFacade(this.operateLog, this.operationKey, this.mainEntityType, this.validators, this.operateMetaMap);
                FacadeResult facadeResult = facade.addWfCanWithdrawValidator();
                return facadeResult;
            }
            FacadeResult facadeResult = null;
            return facadeResult;
        }
        finally {
            if (!flag) {
                TimeoutHandleFactory.get().doTimeoutMarker(false);
            }
        }
    }

    public FacadeResult afterRelease() {
        boolean flag = TimeoutHandleFactory.get().getTimeoutMarker();
        if (!flag) {
            TimeoutHandleFactory.get().doTimeoutMarker(true);
        }
        try {
            this.sendJobs("evtJobMsg", "sendEventMq");
            this.sendJobs("wfJobMsg", "sendWfJob");
            FacadeResult facadeResult = null;
            return facadeResult;
        }
        finally {
            if (!flag) {
                TimeoutHandleFactory.get().doTimeoutMarker(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendJobs(String cacheName, String methodName) {
        Map jobMsgs = (Map)WfJobThreadTruck.get((Object)cacheName);
        try {
            if (jobMsgs == null || jobMsgs.isEmpty()) {
                String key = String.format("release-%1$s-%2$s-%3$s", cacheName, null != this.mainEntityType ? this.mainEntityType.getName() : "", this.operationKey);
                if (WfJobThreadTruck.exists((Object)key)) {
                    logger.debug(key);
                    WfJobThreadTruck.put((Object)key, (Object)"true");
                }
                return;
            }
            Object obj = TypesContainer.getOrRegisterSingletonInstance((String)"kd.bos.workflow.service.TryTriggerProcessTask");
            if (obj != null) {
                MethodUtils.invokeMethod((Object)obj, (String)methodName, (Object[])new Object[]{jobMsgs});
            } else {
                logger.debug(String.format("cannot get obj instance %s %s", cacheName, methodName));
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        finally {
            if (jobMsgs != null) {
                WfJobThreadTruck.remove((Object)cacheName);
            }
        }
    }
}

