/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.facade;

import java.util.Map;
import kd.bos.facade.FacadeResult;
import kd.bos.facade.metadata.IMetadataWriterFacade;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.service.ServiceFactory;
import kd.bos.workflow.api.IWorkflowService;
import kd.bos.workflow.facade.metadata.BuildWorkflowTreeFacade;
import kd.bos.workflow.facade.metadata.CheckMetadataNumberUniquenessFacade;

public class MetadataWriterFacadeForWorkflowImpl
implements IMetadataWriterFacade {
    private Log logger = LogFactory.getLog(this.getClass());

    public FacadeResult beforeSave(Map<String, Object> params) {
        if (null == params || params.isEmpty()) {
            this.logger.debug("kd.bos.workflow.facade.MetadataWriterFacadeForWorkflowImpl.beforeSave(Map<String, Object>) params is null.");
            return null;
        }
        AbstractMetadata[] metadatas = (AbstractMetadata[])params.get("metadatas");
        if (null == metadatas || 0 == metadatas.length) {
            this.logger.debug("kd.bos.workflow.facade.MetadataWriterFacadeForWorkflowImpl.beforeSave(Map<String, Object>) params(metadatas) is null.");
            return null;
        }
        for (AbstractMetadata metadata : metadatas) {
            if (!(metadata instanceof FormMetadata)) continue;
            CheckMetadataNumberUniquenessFacade facade = new CheckMetadataNumberUniquenessFacade(metadata);
            FacadeResult result = facade.checkMetadataNumberUniqueness();
            if (null == result) break;
            return result;
        }
        return null;
    }

    public FacadeResult beforeSaveRuntimeMeta(Map<String, Object> params) {
        if (null == params || params.isEmpty()) {
            this.logger.debug("kd.bos.workflow.facade.MetadataWriterFacadeForWorkflowImpl.beforeSaveRuntimeMeta(Map<String, Object>) params is null.");
            return null;
        }
        FormMetadata formMeta = (FormMetadata)params.get("formMeta");
        if (null == formMeta) {
            this.logger.debug("kd.bos.workflow.facade.MetadataWriterFacadeForWorkflowImpl.beforeSaveRuntimeMeta(Map<String, Object>) formMeta is null.");
            return null;
        }
        String inheritPath = formMeta.getInheritPath();
        if (inheritPath.contains("/Y1MTDFYI0H0") && !inheritPath.contains("/Y1PEU0BGY8S")) {
            this.logger.debug("kd.bos.workflow.facade.MetadataWriterFacadeForWorkflowImpl.beforeSaveRuntimeMeta(Map<String, Object>) rebuildAllMetadataOfBillSummaryCfg begin.");
            IWorkflowService wfService = (IWorkflowService)ServiceFactory.getService(IWorkflowService.class);
            wfService.rebuildAllMetadataOfBillSummaryCfg(formMeta.getId(), null);
            this.logger.debug("kd.bos.workflow.facade.MetadataWriterFacadeForWorkflowImpl.beforeSaveRuntimeMeta(Map<String, Object>) rebuildAllMetadataOfBillSummaryCfg end.");
        }
        FacadeResult facadeResult = new FacadeResult();
        facadeResult.setSuccess(true);
        facadeResult.setCode(3);
        return facadeResult;
    }

    public FacadeResult beforeBuildDesignMeta(Map<String, Object> params) {
        if (null == params || params.isEmpty()) {
            this.logger.debug("kd.bos.workflow.facade.MetadataWriterFacadeForWorkflowImpl.beforeBuildDesignMeta(Map<String, Object>) params is null.");
            return null;
        }
        EntityMetadata entityMetadata = (EntityMetadata)params.get("entityMetadata");
        if (null == entityMetadata) {
            this.logger.debug("kd.bos.workflow.facade.MetadataWriterFacadeForWorkflowImpl.beforeBuildDesignMeta(Map<String, Object>) entityMetadata is null.");
            return null;
        }
        if (!"BaseFormModel".equals(entityMetadata.getModelType()) && !"BillFormModel".equals(entityMetadata.getModelType())) {
            return null;
        }
        Map clientMeta = (Map)params.get("clientMeta");
        if (null == clientMeta) {
            this.logger.debug("kd.bos.workflow.facade.MetadataWriterFacadeForWorkflowImpl.beforeBuildDesignMeta(Map<String, Object>) clientMeta is null.");
            return null;
        }
        this.logger.debug("kd.bos.workflow.facade.MetadataWriterFacadeForWorkflowImpl.beforeBuildDesignMeta(Map<String, Object>) buildWorkflowTree begin.");
        BuildWorkflowTreeFacade facade = new BuildWorkflowTreeFacade(entityMetadata.getKey());
        Map<String, Object> workflowTree = facade.buildWorkflowTree();
        if (null == workflowTree || workflowTree.isEmpty()) {
            return null;
        }
        clientMeta.put("workflowtree", workflowTree);
        FacadeResult facadeResult = new FacadeResult();
        facadeResult.setSuccess(true);
        facadeResult.setCode(3);
        facadeResult.setReturnData(workflowTree);
        return facadeResult;
    }
}

