/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.facade.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.OperateLog;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.facade.FacadeResult;
import kd.bos.service.ServiceFactory;
import kd.bos.workflow.api.IWorkflowService;

public class WfSensitiveChangeFacade {
    private OperateLog operateLog;
    private OperateOption option;
    private String operationKey;
    private OperationResult operationResult;
    private DynamicObject[] dataEntities;
    private MainEntityType mainEntityType;
    private boolean invokeByIds;

    public WfSensitiveChangeFacade(OperateLog operateLog, OperateOption option, String operationKey, OperationResult operationResult, DynamicObject[] dataEntities, MainEntityType mainEntityType, boolean invokeByIds) {
        this.operateLog = operateLog;
        this.option = option;
        this.operationKey = operationKey;
        this.operationResult = operationResult;
        this.dataEntities = dataEntities;
        this.mainEntityType = mainEntityType;
        this.invokeByIds = invokeByIds;
    }

    public FacadeResult wfSensitiveChange() {
        FacadeResult facadeResult = new FacadeResult();
        if (null != this.operateLog) {
            this.operateLog.beginMothed("wfSensitiveChange()", "WfSensitiveChangeFacade.wfSensitiveChangeResult() begin.");
        }
        boolean sensitiveChange = this.wfSensitiveChangeResult();
        if (null != this.operateLog) {
            this.operateLog.endMothed("wfSensitiveChange()", "WfSensitiveChangeFacade.wfSensitiveChangeResult() end.");
        }
        if (sensitiveChange) {
            if (null != this.operateLog) {
                this.operateLog.endMothed("wfSensitiveChange()", "WfSensitiveChangeFacade.wfSensitiveChange(): wfSensitiveChange = true, return");
            }
            facadeResult.setCode(6);
        }
        return facadeResult;
    }

    private boolean wfSensitiveChangeResult() {
        block11: {
            if (null == this.option) {
                return false;
            }
            Object callBackFlag = this.option.getVariables().get("WfSensitiveCallBackFlag");
            Boolean isCallBack = Boolean.valueOf(callBackFlag == null ? "false" : callBackFlag.toString());
            if (!isCallBack.booleanValue()) {
                IWorkflowService workFlowService = (IWorkflowService)ServiceFactory.getService(IWorkflowService.class);
                if (this.dataEntities != null && this.dataEntities.length > 0) {
                    try {
                        HashMap<String, Boolean> wfVar = new HashMap<String, Boolean>(1);
                        wfVar.put("byIds", this.invokeByIds);
                        String entityId = null != this.mainEntityType ? this.mainEntityType.getName() : "";
                        Map map = workFlowService.getSensitiveFieldInfo(entityId, this.dataEntities, this.operationKey, wfVar, "UserTask", false);
                        if (!map.isEmpty()) {
                            String openSensitiveFieldPage = (String)map.get("openSensitiveFieldPage");
                            String sensitiveFieldInfosStr = (String)map.get("sensitiveFieldInfos");
                            if (StringUtils.isNotBlank((CharSequence)sensitiveFieldInfosStr)) {
                                List sensitiveFieldInfos = (List)SerializationUtils.fromJsonString((String)sensitiveFieldInfosStr, List.class);
                                if ("true".equals(openSensitiveFieldPage) && "false".equals(this.option.getVariables().get("ignoreassignperson"))) {
                                    this.option.setVariableValue("sensitiveFieldInfos", SerializationUtils.toJsonString(sensitiveFieldInfos.get(0)));
                                    this.option.setVariableValue("openSensitiveFieldPage", "true");
                                    return true;
                                }
                                for (Map sensitiveFieldInfo : sensitiveFieldInfos) {
                                    String changkey;
                                    Map params;
                                    if (!((Boolean)sensitiveFieldInfo.get("isSensitiveChange")).booleanValue() || (params = (Map)sensitiveFieldInfo.get("params")) == null || params.isEmpty() || !StringUtils.isNotBlank((CharSequence)(changkey = (String)params.get("changkey")))) continue;
                                    this.option.setVariableValue(changkey, SerializationUtils.toJsonString((Object)sensitiveFieldInfo));
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        String errorMsg = e.getMessage();
                        if (null == errorMsg || errorMsg.trim().length() <= 0 || null == this.operationResult) break block11;
                        ArrayList<OperateErrorInfo> errorInfos = new ArrayList<OperateErrorInfo>();
                        OperateErrorInfo errorInfo = new OperateErrorInfo();
                        errorInfo.setLevel(ErrorLevel.Error);
                        errorInfo.setMessage(errorMsg);
                        errorInfos.add(errorInfo);
                        this.operationResult.setAllErrorInfo(errorInfos);
                        if (null != this.operateLog) {
                            this.operateLog.error((Throwable)e);
                        }
                        return false;
                    }
                }
            }
        }
        if (null != this.operationResult) {
            this.operationResult.setSuccess(true);
        }
        return false;
    }
}

