/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.facade.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.service.ServiceFactory;
import kd.bos.workflow.api.IWorkflowService;

public class BuildWorkflowTreeFacade {
    private String entityNumber;
    private static final String DS_TYPE = "DsType";
    private static final String ITEMS = "Items";
    private static final String TEXT_FIELD = "TextField";
    private static final String BOS_WF_FACADE = "bos-wf-facade";
    private static final String DS_NAME_APPROVELINE = "workflow.approveline";
    private static final String DS_NAME_ACTIVITY = "workflow.activity";
    public static final String DS_TYPE_APPROVEACTIVITY = "8";
    public static final String DS_TYPE_APPROVELINE = "4";

    public BuildWorkflowTreeFacade(String entityNumber) {
        this.entityNumber = entityNumber;
    }

    public Map<String, Object> buildWorkflowTree() {
        List<Object> workflowNodes = this.buildWorkflowNodes(this.entityNumber);
        HashMap<String, Object> formulaRoot = new HashMap<String, Object>(4);
        formulaRoot.put("Id", "workflow");
        formulaRoot.put("Type", "workflow");
        formulaRoot.put("Name", ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41", (String)"BuildWorkflowTreeFacade_0", (String)BOS_WF_FACADE, (Object[])new Object[0]));
        formulaRoot.put("IsDS", false);
        formulaRoot.put(ITEMS, workflowNodes);
        return formulaRoot;
    }

    private List<Object> buildWorkflowNodes(String entityNumber) {
        List<Object> activityNodes;
        ArrayList<Object> workflowNodes = new ArrayList<Object>();
        List<Object> eleNodes = this.buildApproveLineNodes();
        if (!eleNodes.isEmpty()) {
            HashMap<String, Object> aplNode = new HashMap<String, Object>();
            aplNode.put("Id", DS_NAME_APPROVELINE);
            aplNode.put("Type", TEXT_FIELD);
            aplNode.put("IsDS", true);
            aplNode.put(DS_TYPE, DS_TYPE_APPROVELINE);
            aplNode.put("Name", ResManager.loadKDString((String)"\u5ba1\u6279\u7ebf\u8def", (String)"BuildWorkflowTreeFacade_1", (String)BOS_WF_FACADE, (Object[])new Object[0]));
            aplNode.put(ITEMS, eleNodes);
            workflowNodes.add(aplNode);
        }
        if (!(activityNodes = this.buildActivityNodes(entityNumber)).isEmpty()) {
            HashMap<String, Object> activityNode = new HashMap<String, Object>();
            activityNode.put("Id", DS_NAME_ACTIVITY);
            activityNode.put("Type", TEXT_FIELD);
            activityNode.put("IsDS", true);
            activityNode.put(DS_TYPE, DS_TYPE_APPROVEACTIVITY);
            activityNode.put("Name", ResManager.loadKDString((String)"\u5ba1\u6279\u8282\u70b9", (String)"BuildWorkflowTreeFacade_2", (String)BOS_WF_FACADE, (Object[])new Object[0]));
            activityNode.put(ITEMS, activityNodes);
            workflowNodes.add(activityNode);
        }
        return workflowNodes;
    }

    private List<Object> buildApproveLineNodes() {
        ArrayList<Object> eleNodes = new ArrayList<Object>(10);
        IWorkflowService workflowService = this.getWFService();
        Map approvalRecord = workflowService.getApprovalRecordMeta();
        for (Map.Entry entry : approvalRecord.entrySet()) {
            HashMap<String, Object> eleNode = new HashMap<String, Object>();
            eleNode.put("Id", entry.getKey());
            eleNode.put("Type", TEXT_FIELD);
            eleNode.put("Name", entry.getValue());
            eleNodes.add(eleNode);
        }
        return eleNodes;
    }

    private List<Object> buildActivityNodes(String entityNumber) {
        IWorkflowService workflowService = this.getWFService();
        Collection activities = workflowService.getPrintMetaEntityNumber(entityNumber);
        ArrayList<Object> activityNodes = new ArrayList<Object>(10);
        for (Map active : activities) {
            HashMap eleNode = new HashMap();
            Object bizIdentifyKey = active.get("bizIdentifyKey");
            Object activityName = active.get("activityName");
            Map printMeta = (Map)active.get("printMeta");
            ArrayList detailNodes = new ArrayList(10);
            for (Map.Entry entry : printMeta.entrySet()) {
                HashMap<String, String> eleNode1 = new HashMap<String, String>();
                eleNode1.put("Id", bizIdentifyKey + "_" + (String)entry.getKey());
                eleNode1.put("Type", TEXT_FIELD);
                eleNode1.put("Name", activityName + "." + entry.getValue());
                detailNodes.add(eleNode1);
            }
            eleNode.put("Id", bizIdentifyKey);
            eleNode.put("Type", TEXT_FIELD);
            eleNode.put("Name", activityName);
            eleNode.put(ITEMS, detailNodes);
            activityNodes.add(eleNode);
        }
        return activityNodes;
    }

    private IWorkflowService getWFService() {
        return (IWorkflowService)ServiceFactory.getService(IWorkflowService.class);
    }
}

