/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.facade.metadata;

import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.facade.FacadeResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.service.ServiceFactory;
import kd.bos.workflow.api.IWorkflowService;

public class CheckMetadataNumberUniquenessFacade {
    private Log logger = LogFactory.getLog(this.getClass());
    private AbstractMetadata metadata;

    public CheckMetadataNumberUniquenessFacade(AbstractMetadata metadata) {
        this.metadata = metadata;
    }

    public FacadeResult checkMetadataNumberUniqueness() {
        if (null == this.metadata) {
            return null;
        }
        FormAp rootAp = ((FormMetadata)this.metadata).getRootAp();
        if (null == rootAp) {
            this.logger.debug("kd.bos.workflow.facade.metadata.CheckMetadataNumberUniquenessFacade.checkMetadataNumberUniqueness() rootAp is null.");
            return null;
        }
        String entryKey = rootAp.getKey();
        if (null == entryKey || entryKey.trim().isEmpty()) {
            return null;
        }
        IWorkflowService wfService = (IWorkflowService)ServiceFactory.getService(IWorkflowService.class);
        Map resultMap = wfService.checkMetadataNumberUniqueness(entryKey);
        this.logger.debug("kd.bos.workflow.facade.metadata.CheckMetadataNumberUniquenessFacade.checkMetadataNumberUniqueness() end check and resultMap is : " + resultMap);
        if (null == resultMap || null == resultMap.get("numberHasExit") || !((Boolean)resultMap.get("numberHasExit")).booleanValue()) {
            this.logger.debug("kd.bos.workflow.facade.metadata.CheckMetadataNumberUniquenessFacade.checkMetadataNumberUniqueness() end check and verify success.");
            return null;
        }
        resultMap.put("success", false);
        ErrorInfo error = new ErrorInfo();
        error.setItemId(this.metadata.getId());
        error.setPropertyName("Key");
        error.setType("formmeta");
        error.setLevel(2);
        error.setError(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"CheckMetadataNumberUniquenessFacade_0", (String)"bos-wf-facade", (Object[])new Object[0]));
        this.metadata.addError(error);
        resultMap.put("errors", this.metadata.getBuildErrors());
        FacadeResult result = new FacadeResult();
        result.setSuccess(true);
        result.setCode(6);
        result.setReturnData(resultMap);
        return result;
    }
}

