/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.facade.validate;

import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;

public class InProcessValidator
extends AbstractValidator {
    private static Log log = LogFactory.getLog(InProcessValidator.class);

    public void validate() {
        log.info("\u6267\u884c\u201c\u5355\u636e\u5728\u6d41\u7a0b\u4e2d\u6821\u9a8c\u5668\u201d\u6821\u9a8c----");
        if (this.dataEntities == null || this.dataEntities.length == 0) {
            log.debug("InProcessValidator return cause of dataEntities is null");
            return;
        }
        Map variables = this.getOption().getVariables();
        if (variables != null && variables.get("WF") != null) {
            log.debug("InProcessValidator return cause of variables contains 'WF'");
            return;
        }
        ExtendedDataEntity[] inProcessDataEntity = WorkflowServiceHelper.getInProcessDataEntity((ExtendedDataEntity[])this.dataEntities);
        if (inProcessDataEntity == null) {
            log.debug("inProcessDataEntity is null,from here exist");
            return;
        }
        for (ExtendedDataEntity dataEntity : inProcessDataEntity) {
            LocaleString content = LocaleString.fromMap((Map)((Map)this.getValidationValueByKey("description")));
            String tip = String.format(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u5728\u6d41\u7a0b\u4e2d\u6d41\u8f6c\uff0c\u4e0d\u80fd%s\u3002", (String)"InProcessValidator_0", (String)"bos-wf-facade", (Object[])new Object[0]), this.getOperationName());
            this.addMessage(dataEntity, content.getLocaleValue(), tip, ErrorLevel.Error);
        }
    }
}

