/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.facade.validate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;

public class WfCanWithdrawValidator
extends AbstractValidator {
    private static Log log = LogFactory.getLog(WfCanWithdrawValidator.class);
    public static final String WORKFLOWDISTRICT = "workflow";

    public void validate() {
        List bizJobIds;
        List inProcessPks;
        Map variablesMap = this.getOption().getVariables();
        String isFromWf = (String)variablesMap.get("WF");
        if (isFromWf != null && !isFromWf.isEmpty()) {
            return;
        }
        log.debug("\u6267\u884c\u201c\u5de5\u4f5c\u6d41\u64a4\u56de\u201d\u6821\u9a8c");
        if (this.dataEntities == null || this.dataEntities.length == 0) {
            return;
        }
        DynamicObject[] objs = new DynamicObject[this.dataEntities.length];
        for (int i = 0; i < this.dataEntities.length; ++i) {
            objs[i] = this.dataEntities[i].getDataEntity();
        }
        Map notInProcessAndWfCanUnSubmit = WorkflowServiceHelper.canWithdraw((DynamicObject[])objs);
        if (notInProcessAndWfCanUnSubmit == null || notInProcessAndWfCanUnSubmit.isEmpty()) {
            return;
        }
        ArrayList pkValues = new ArrayList();
        if (notInProcessAndWfCanUnSubmit.get("notInProcess") != null) {
            List notInProcessPks = (List)notInProcessAndWfCanUnSubmit.get("notInProcess");
            pkValues.addAll(notInProcessPks);
        }
        StringBuilder sb = new StringBuilder();
        if (notInProcessAndWfCanUnSubmit.get("wfCanWithdrawByAbandonProc") != null) {
            inProcessPks = (List)notInProcessAndWfCanUnSubmit.get("wfCanWithdrawByAbandonProc");
            StringBuilder abandonSb = new StringBuilder();
            if (!inProcessPks.isEmpty()) {
                for (String inProcess : inProcessPks) {
                    abandonSb.append(inProcess).append(',');
                }
                pkValues.addAll(inProcessPks);
                this.getOption().setVariableValue("abandonPks", abandonSb.substring(0, abandonSb.length() - 1));
            }
            sb.append((CharSequence)abandonSb);
        }
        if (notInProcessAndWfCanUnSubmit.get("wfCanWithdraw") != null && !(inProcessPks = (List)notInProcessAndWfCanUnSubmit.get("wfCanWithdraw")).isEmpty()) {
            for (Object inProcess : inProcessPks) {
                sb.append((String)inProcess).append(',');
            }
            pkValues.addAll(inProcessPks);
        }
        if (sb.length() > 2) {
            this.getOption().setVariableValue("inProcess", sb.substring(0, sb.length() - 1));
        }
        if ((bizJobIds = (List)notInProcessAndWfCanUnSubmit.get("withdrawDeleteBizJobIds")) != null && !bizJobIds.isEmpty()) {
            StringBuilder sbs = new StringBuilder();
            for (Object jobId : bizJobIds) {
                sbs.append((String)jobId).append(',');
            }
            this.getOption().setVariableValue("joIdsInBizDB", sbs.substring(0, sbs.length() - 1));
        }
        List causes = (List)notInProcessAndWfCanUnSubmit.get("notWithdrawCause");
        HashMap<String, String> notWithdrawCause = new HashMap<String, String>();
        if (causes != null) {
            for (String cause : causes) {
                String[] arr = cause.split("_");
                if (arr.length != 2) continue;
                notWithdrawCause.put(arr[0], arr[1]);
            }
        }
        String tip = String.format(ResManager.loadKDString((String)"\u5355\u636e\u5728\u6d41\u8f6c\u4e2d\u6216\u91cd\u8bd5\u65f6\u4e0d\u80fd\u64a4\u9500\uff1b\u6d41\u7a0b\u5df2\u6302\u8d77\u6216\u5df2\u7ed3\u675f\u4e0d\u80fd%s\u3002", (String)"WfCanWithdrawValidator_0", (String)"bos-wf-facade", (Object[])new Object[0]), this.getOperationName());
        for (int i = 0; i < this.dataEntities.length; ++i) {
            String pkValue = this.dataEntities[i].getDataEntity().getPkValue().toString();
            if (pkValues.contains(pkValue)) continue;
            String t = (String)notWithdrawCause.get(pkValue);
            if (t == null || t.trim().length() == 0) {
                this.addMessage(this.dataEntities[i], "", tip, ErrorLevel.Error);
                continue;
            }
            this.addMessage(this.dataEntities[i], "", t, ErrorLevel.Error);
        }
    }
}

