/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.api;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.taskmodel.ResultInfo;
import kd.bos.workflow.engine.msg.info.TaskEntityInfo;
import kd.bos.workflow.engine.msg.info.TaskParams;
import kd.bos.workflow.engine.task.BatchOperateResult;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.engine.task.operation.CompleteOperationParam;
import kd.bos.workflow.engine.task.operation.DeleteOperationParam;
import kd.bos.workflow.task.enumeration.BizTaskApiErrorCode;
import kd.bos.workflow.task.service.TaskRuntimeService;
import kd.bos.workflow.task.utils.BizTaskApiUtils;

@ApiController(value="wftask", desc="\u4efb\u52a1\u6a21\u578b")
@ApiMapping(value="/")
public class BizTaskController
implements Serializable {
    private static final long serialVersionUID = -4118963192488957854L;
    private static Log logger = LogFactory.getLog(BizTaskController.class);
    private static TaskRuntimeService taskRuntimeService;

    private static TaskRuntimeService getTaskRuntimeService() {
        if (taskRuntimeService == null) {
            taskRuntimeService = TaskRuntimeService.create();
        }
        return taskRuntimeService;
    }

    @ApiPostMapping(value="createBizTask", desc="\u521b\u5efa\u4efb\u52a1")
    public CustomApiResult<Map<String, Object>> createBizTask(@ApiParam(value="taskParams", required=true) @Valid @ApiParam(value="taskParams", required=true) @Valid TaskParams taskParams) {
        try {
            if (taskParams == null) {
                return CustomApiResult.fail((String)BizTaskApiErrorCode.CODE_PARAMISEMPTY.getErrorCode(), (String)BizTaskApiErrorCode.CODE_PARAMISEMPTY.getErrorName());
            }
            TaskEntityInfo taskEntityInfo = taskParams.convert2TaskEntityInfo();
            ResultInfo resultInfo = BizTaskApiUtils.verifyCreateBizTaskParam(taskEntityInfo, false);
            if (!resultInfo.isSuccess()) {
                return CustomApiResult.fail((String)BizTaskApiErrorCode.CODE_PARAMVERIFYERROR.getErrorCode(), (String)String.format(BizTaskApiErrorCode.CODE_PARAMVERIFYERROR.getErrorName(), resultInfo.getDescription()));
            }
            TaskInfo taskInfo = BizTaskController.getTaskRuntimeService().createBizTask(taskEntityInfo);
            HashMap<String, Comparable<Boolean>> result = new HashMap<String, Comparable<Boolean>>();
            result.put("success", Boolean.valueOf(true));
            result.put("taskId", taskInfo.getId());
            return CustomApiResult.success(result);
        }
        catch (Exception e) {
            logger.warn(String.format("invoke bizTask api occurred exception: %s", WfUtils.getExceptionStacktrace((Throwable)e)));
            return CustomApiResult.fail((String)BizTaskApiErrorCode.CODE_INVOKEAPIERROR.getErrorCode(), (String)BizTaskApiErrorCode.CODE_INVOKEAPIERROR.getErrorName());
        }
    }

    @ApiPostMapping(value="completeBizTask", desc="\u5904\u7406\u4efb\u52a1")
    public CustomApiResult<BatchOperateResult> completeBizTask(@ApiParam(value="completeOperationParam", required=true) @Valid @ApiParam(value="completeOperationParam", required=true) @Valid CompleteOperationParam completeOperationParam) {
        try {
            if (completeOperationParam == null) {
                return CustomApiResult.fail((String)BizTaskApiErrorCode.CODE_PARAMISEMPTY.getErrorCode(), (String)BizTaskApiErrorCode.CODE_PARAMISEMPTY.getErrorName());
            }
            ResultInfo resultInfo = BizTaskApiUtils.verifyCompleteBizTaskParam(completeOperationParam);
            if (!resultInfo.isSuccess()) {
                return CustomApiResult.fail((String)BizTaskApiErrorCode.CODE_PARAMVERIFYERROR.getErrorCode(), (String)String.format(BizTaskApiErrorCode.CODE_PARAMVERIFYERROR.getErrorName(), resultInfo.getDescription()));
            }
            BatchOperateResult batchOperateResult = BizTaskController.getTaskRuntimeService().completeBizTask(completeOperationParam);
            return CustomApiResult.success((Object)batchOperateResult);
        }
        catch (Exception e) {
            logger.warn(String.format("invoke bizTask api occurred exception: %s", WfUtils.getExceptionStacktrace((Throwable)e)));
            return CustomApiResult.fail((String)BizTaskApiErrorCode.CODE_INVOKEAPIERROR.getErrorCode(), (String)BizTaskApiErrorCode.CODE_INVOKEAPIERROR.getErrorName());
        }
    }

    @ApiPostMapping(value="deleteBizTask", desc="\u5220\u9664\u4efb\u52a1")
    public CustomApiResult<BatchOperateResult> deleteBizTask(@ApiParam(value="deleteOperationParam", required=true) @Valid @ApiParam(value="deleteOperationParam", required=true) @Valid DeleteOperationParam deleteOperationParam) {
        try {
            if (deleteOperationParam == null) {
                return CustomApiResult.fail((String)BizTaskApiErrorCode.CODE_PARAMISEMPTY.getErrorCode(), (String)BizTaskApiErrorCode.CODE_PARAMISEMPTY.getErrorName());
            }
            ResultInfo resultInfo = BizTaskApiUtils.verifyDeleteBizTaskParam(deleteOperationParam);
            if (!resultInfo.isSuccess()) {
                return CustomApiResult.fail((String)BizTaskApiErrorCode.CODE_PARAMVERIFYERROR.getErrorCode(), (String)String.format(BizTaskApiErrorCode.CODE_PARAMVERIFYERROR.getErrorName(), resultInfo.getDescription()));
            }
            BatchOperateResult batchOperateResult = BizTaskController.getTaskRuntimeService().deleteBizTask(deleteOperationParam);
            return CustomApiResult.success((Object)batchOperateResult);
        }
        catch (Exception e) {
            logger.warn(String.format("invoke bizTask api occurred exception: %s", WfUtils.getExceptionStacktrace((Throwable)e)));
            return CustomApiResult.fail((String)BizTaskApiErrorCode.CODE_INVOKEAPIERROR.getErrorCode(), (String)BizTaskApiErrorCode.CODE_INVOKEAPIERROR.getErrorName());
        }
    }
}

