/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;

class TaskModelCache<T> {
    protected static Log logger = LogFactory.getLog(TaskModelCache.class);
    private static final String TASKMODEL = "taskmodel";
    private static final String TRACERTYPE = "TaskModelDefCache";
    private Map<String, T> cache;
    private Map<String, String> lastUpdateTimeCache;
    private DistributeSessionlessCache disCache;

    TaskModelCache() {
        this.cache = Collections.synchronizedMap(new HashMap());
        this.lastUpdateTimeCache = Collections.synchronizedMap(new HashMap());
        this.disCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(TASKMODEL, new DistributeCacheHAPolicy());
    }

    TaskModelCache(final int limit) {
        this.cache = Collections.synchronizedMap(new LinkedHashMap<String, T>(limit + 1, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, T> eldest) {
                boolean removeEldest;
                boolean bl = removeEldest = this.size() > limit;
                if (removeEldest) {
                    logger.info(String.format("Cache limit is reached, %s will be evicted", eldest.getKey()));
                }
                return removeEldest;
            }
        });
        this.lastUpdateTimeCache = Collections.synchronizedMap(new HashMap());
        this.disCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(TASKMODEL, new DistributeCacheHAPolicy());
    }

    T get(String key) {
        TraceSpan ts = Tracer.create((String)TRACERTYPE, (String)"getCache");
        ts.addTag("id", key);
        String cacheKey = this.getMultiLangCacheKey(key);
        this.checkDisCache(cacheKey);
        return this.cache.get(cacheKey);
    }

    boolean contains(String key) {
        return this.cache.containsKey(key);
    }

    void add(String key, T object, String lastUpdateTime) {
        TraceSpan ts = Tracer.create((String)TRACERTYPE, (String)"updateCache");
        ts.addTag("id", key);
        String cacheKey = this.getMultiLangCacheKey(key);
        this.cache.put(cacheKey, object);
        this.lastUpdateTimeCache.put(cacheKey, lastUpdateTime);
        this.disCache.put(cacheKey, (Object)lastUpdateTime);
        logger.info(String.format("updateCache[%s-%s]", cacheKey, lastUpdateTime));
    }

    void remove(String key) {
        Lang[] values;
        TraceSpan ts = Tracer.create((String)TRACERTYPE, (String)"removeCache");
        ts.addTag("id", key);
        for (Lang lang : values = WfUtils.getSupportLangs()) {
            String cacheKey = this.getMultiLangCacheKey(key, lang.toString());
            this.cache.remove(cacheKey);
            this.disCache.remove(cacheKey);
            this.lastUpdateTimeCache.remove(cacheKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        this.cache.clear();
        if (this.lastUpdateTimeCache != null) {
            if (this.lastUpdateTimeCache.size() > 0) {
                TaskModelCache taskModelCache = this;
                synchronized (taskModelCache) {
                    String[] keys = this.lastUpdateTimeCache.keySet().toArray(new String[this.lastUpdateTimeCache.size()]);
                    this.disCache.remove(keys);
                }
            }
            this.lastUpdateTimeCache.clear();
        }
    }

    int size() {
        return this.cache.size();
    }

    private String getMultiLangCacheKey(String key) {
        String lang = RequestContext.get().getLang().toString();
        return this.getMultiLangCacheKey(key, lang);
    }

    private String getMultiLangCacheKey(String id, String lang) {
        return String.format("%s_taskmodeldef_%s_%s", WfCacheHelper.getAccountId(), id, lang);
    }

    private void checkDisCache(String cacheKey) {
        String lastUpdateTime = (String)this.disCache.get(cacheKey);
        String cacheLastUpdateTime = this.lastUpdateTimeCache.get(cacheKey);
        if (lastUpdateTime == null || !lastUpdateTime.equals(cacheLastUpdateTime)) {
            this.cache.remove(cacheKey);
            this.lastUpdateTimeCache.put(cacheKey, lastUpdateTime);
        }
    }
}

