/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.cache;

import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.task.cache.TaskModelCache;
import kd.bos.workflow.task.cache.TaskModelCacheEntry;
import kd.bos.workflow.task.enumeration.TaskOperation;

public class TaskModelCacheHelper {
    private static Log logger = LogFactory.getLog(TaskModelCacheHelper.class);
    private static TaskModelCache<TaskModelCacheEntry> taskModelDefinitionCache = null;
    private static int taskModelDefinitionCacheLimit = 20;
    private static final String TASKMODELDISTRICT = "taskModelDistrict";
    private static final int TPLTIMEOUT = 3600;
    private static DistributeSessionlessCache taskModelDistrictCache = null;
    private static final String TASKOPERATIONLOGICPLUGIN = "taskOpLogicPlugin";

    private static TaskModelCache<TaskModelCacheEntry> getTaskModelDefinitionCache() {
        if (taskModelDefinitionCache == null) {
            taskModelDefinitionCache = taskModelDefinitionCacheLimit <= 0 ? new TaskModelCache() : new TaskModelCache(taskModelDefinitionCacheLimit);
        }
        return taskModelDefinitionCache;
    }

    public static TaskModelCacheEntry getTaskModelDefinitionCacheEntry(String taskModelNumber) {
        return TaskModelCacheHelper.getTaskModelDefinitionCache().get(taskModelNumber);
    }

    public static void addTaskModelDefinitonCacheEntry(String taskModelNumber, TaskModelCacheEntry entry) {
        String lastUpdateTime = String.valueOf(entry.getUpdateTime());
        TaskModelCacheHelper.getTaskModelDefinitionCache().add(taskModelNumber, entry, lastUpdateTime);
    }

    public static void removeTaskModelDefinitionCacheEntry(String taskModelNumber) {
        TaskModelCacheHelper.getTaskModelDefinitionCache().remove(taskModelNumber);
    }

    public static boolean containsTaskModelDefinitionCacheEntry(String taskModelNumber) {
        return TaskModelCacheHelper.getTaskModelDefinitionCache().contains(taskModelNumber);
    }

    public static void clearTaskModelDefinitionCache() {
        TaskModelCacheHelper.getTaskModelDefinitionCache().clear();
    }

    private static DistributeSessionlessCache getTaskModelCache() {
        if (taskModelDistrictCache == null) {
            taskModelDistrictCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(TASKMODELDISTRICT, new DistributeCacheHAPolicy());
        }
        return taskModelDistrictCache;
    }

    private static String getAccountId() {
        return CacheKeyUtil.getAcctId();
    }

    private static String getWholeKey(String ... args) {
        StringBuilder key = new StringBuilder();
        key.append(TaskModelCacheHelper.getAccountId()).append(".wf.tm.");
        return WfUtils.strAppend((String)key.toString(), (String)".", (String[])args);
    }

    public static void putOperationMainLogicPlugin(String taskModelNumber, TaskOperation taskOperation, String plugin) {
        String key = TaskModelCacheHelper.getWholeKey(TASKOPERATIONLOGICPLUGIN, taskModelNumber, taskOperation.getValue());
        TaskModelCacheHelper.getTaskModelCache().put(key, (Object)plugin, 3600);
    }

    public static void removeOperationMainLogicPlugin(String taskModelNumber, TaskOperation taskOperation) {
        String key = TaskModelCacheHelper.getWholeKey(TASKOPERATIONLOGICPLUGIN, taskModelNumber, taskOperation.getValue());
        TaskModelCacheHelper.getTaskModelCache().remove(key);
    }

    public static String getOperationMainLogicPlugin(String taskModelNumber, TaskOperation taskOperation) {
        String key = TaskModelCacheHelper.getWholeKey(TASKOPERATIONLOGICPLUGIN, taskModelNumber, taskOperation.getValue());
        return (String)TaskModelCacheHelper.getTaskModelCache().get(key);
    }

    public static void putCurrentExecuteJobState(Long id, String businessKey) {
        String key = TaskModelCacheHelper.getWholeKey("CURRENTTASKEXECUTEJOB", businessKey);
        TaskModelCacheHelper.getTaskModelCache().addToSet(key, new String[]{String.valueOf(id)}, 3600);
    }

    public static void removeCurrentExecuteJobState(Long id, String businessKey) {
        String key = TaskModelCacheHelper.getWholeKey("CURRENTTASKEXECUTEJOB", businessKey);
        TaskModelCacheHelper.getTaskModelCache().removeSetValues(key, new String[]{String.valueOf(id)});
    }

    public static int putCurrentExecuteBySceneAndKey(String markId) {
        String key = TaskModelCacheHelper.getWholeKey(markId);
        return TaskModelCacheHelper.getTaskModelCache().addToSet(key, new String[]{markId}, 3600);
    }

    public static void removeCurrentExecuteBySceneAndKey(String markId) {
        String key = TaskModelCacheHelper.getWholeKey(markId);
        TaskModelCacheHelper.getTaskModelCache().remove(key);
    }

    public static boolean isCurrentExecuting(Long id, String businessKey) {
        String key = TaskModelCacheHelper.getWholeKey("CURRENTTASKEXECUTEJOB", businessKey);
        String[] ids = TaskModelCacheHelper.getTaskModelCache().getSetValues(key);
        return WfUtils.inArray((String[])ids, (String)String.valueOf(id));
    }
}

