/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.cmd.job;

import java.util.ArrayList;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.exception.WFException;
import kd.bos.workflow.task.entity.TaskJobEntity;
import kd.bos.workflow.task.entity.TaskJobEntityManager;
import kd.bos.workflow.task.job.TaskModelJobManager;
import org.apache.commons.collections.CollectionUtils;

public class RetryTaskJobByIdsCmd<T extends Entity>
implements Command<List<T>> {
    private static final long serialVersionUID = -8205191735752830826L;
    public static final String MARKID = "moveChannelLogJobToExecutableJob";
    protected static Log log = LogFactory.getLog(RetryTaskJobByIdsCmd.class);
    private List<Long> taskJobIds;

    public RetryTaskJobByIdsCmd(List<Long> taskJobIds) {
        this.taskJobIds = taskJobIds;
    }

    public List<T> execute(CommandContext commandContext) {
        ArrayList<JobEntity> jobEntities = new ArrayList<JobEntity>(this.taskJobIds.size());
        TaskJobEntityManager taskJobEntityManager = (TaskJobEntityManager)commandContext.getEntityManager(TaskJobEntityManager.class);
        List<TaskJobEntity> taskJobEntityList = taskJobEntityManager.getTaskJobsByIds(this.taskJobIds, taskJobEntityManager.getSelectFields());
        ArrayList<TaskJobEntity> taskJobRecordEntities = new ArrayList<TaskJobEntity>();
        ArrayList<TaskJobEntity> taskJobEntities = new ArrayList<TaskJobEntity>();
        if (CollectionUtil.isNotEmpty(taskJobEntityList)) {
            for (TaskJobEntity taskJobEntity : taskJobEntityList) {
                if (taskJobEntity.getJobType().equals("taskMessage") || taskJobEntity.getJobType().equals("taskTimer")) {
                    taskJobRecordEntities.add(taskJobEntity);
                    continue;
                }
                taskJobEntities.add(taskJobEntity);
            }
        }
        boolean flag = false;
        try {
            if (WfCacheHelper.putCurrentExecuteBySceneAndKey((String)MARKID) > 0) {
                List<JobEntity> taskJobs;
                List<JobEntity> jobs;
                flag = true;
                if (taskJobEntities.size() > 0 && CollectionUtils.isNotEmpty(jobs = TaskModelJobManager.create().moveChannelLogToExecutableJob(taskJobEntities))) {
                    jobEntities.addAll(jobs);
                }
                if (taskJobRecordEntities.size() > 0 && CollectionUtils.isNotEmpty(taskJobs = TaskModelJobManager.create().moveChannelLogToTaskExecutableJob(taskJobRecordEntities))) {
                    jobEntities.addAll(taskJobs);
                }
            }
        }
        catch (Exception e) {
            throw new WFException(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        finally {
            if (flag) {
                WfCacheHelper.removeCurrentExecuteBySceneAndKey((String)MARKID);
            }
        }
        return jobEntities;
    }
}

