/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.cmd.operatelogic;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.api.AgentTask;
import kd.bos.workflow.bpmn.model.ParticipatantModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.calculator.ParticipantCalculator;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.task.taskmodel.HandleTask;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.msg.info.TaskEntityInfo;
import kd.bos.workflow.engine.task.BatchOperateResult;
import kd.bos.workflow.engine.task.TaskOperateResult;
import kd.bos.workflow.engine.task.operation.TaskOperationInfo;
import kd.bos.workflow.task.cache.TaskModelCacheEntry;
import kd.bos.workflow.task.cache.TaskModelCacheHelper;
import kd.bos.workflow.task.cmd.ITaskOperationPlugin;
import kd.bos.workflow.task.enumeration.TaskOperation;
import kd.bos.workflow.task.exception.TaskErrorCode;
import kd.bos.workflow.task.listeners.BizTaskListenerExecuteHelper;
import kd.bos.workflow.task.model.BizTask;
import kd.bos.workflow.task.model.BizTaskOperate;
import kd.bos.workflow.task.service.TaskModelService;
import kd.bos.workflow.task.service.TaskRuntimeService;

public class AssignBizTaskCmd
extends HandleTask
implements Command<BatchOperateResult>,
ITaskOperationPlugin {
    private static Log logger = LogFactory.getLog(AssignBizTaskCmd.class);
    private BizTask bizTask;
    private BizTaskOperate bizTaskOperate;
    private TaskEntity taskEntity;
    private TaskEntityInfo taskEntityInfo;

    public AssignBizTaskCmd() {
    }

    public AssignBizTaskCmd(TaskEntity taskEntity, TaskEntityInfo taskEntityInfo) {
        this.taskEntity = taskEntity;
        this.taskEntityInfo = taskEntityInfo;
    }

    public BatchOperateResult execute(CommandContext commandContext) {
        this.assignBizTask(commandContext);
        return null;
    }

    @Override
    public TaskOperateResult executeTaskOperation(TaskOperationInfo taskOperationInfo, AgentTask agentTask) {
        if (!(taskOperationInfo instanceof TaskEntityInfo) || !(agentTask instanceof TaskEntity)) {
            throw new KDException(TaskErrorCode.parseTaskModelError(), new Object[0]);
        }
        this.taskEntityInfo = (TaskEntityInfo)taskOperationInfo;
        this.taskEntity = (TaskEntity)agentTask;
        this.assignBizTask(Context.getCommandContext());
        return null;
    }

    private void assignBizTask(CommandContext commandContext) {
        this.executeBeforeHandleTaskListeners(this.taskEntity, null);
        List participantInfos = this.taskEntityInfo.getParticipantInfos();
        List<Long> userIds = participantInfos != null && !participantInfos.isEmpty() ? participantInfos.stream().map(participantInfo -> participantInfo.getUserId()).distinct().collect(Collectors.toList()) : this.getTaskParticipant(this.taskEntity);
        if (userIds == null) {
            logger.info("assignTask: no participants");
            return;
        }
        this.taskEntity.addUserIdentityLinks(userIds, "participant");
        TaskBehaviorUtil.dispatchTaskAssignListener((TaskEntity)this.taskEntity, null);
        this.executeHandleTaskListeners(this.taskEntity, null);
        this.executeAfterHandleTaskListeners(this.taskEntity, null);
    }

    private List<Long> getTaskParticipant(TaskEntity taskEntity) {
        TaskModelCacheEntry taskModelDefinitionCacheEntry = TaskModelCacheHelper.getTaskModelDefinitionCacheEntry(taskEntity.getTaskDefinitionKey());
        this.bizTask = taskModelDefinitionCacheEntry.getBizTask();
        ParticipatantModel activeTaskParticipant = this.bizTask.getParticipant();
        List participant = activeTaskParticipant.getParticipant();
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getCommandContext().getProcessEngineConfiguration();
        ParticipantCalculator participantCalculator = processEngineConfiguration.getParticipantCalculator();
        List userIds = participantCalculator.getUserIds(this.taskEntityInfo.getBusinessKey(), (VariableScope)taskEntity, participant);
        return userIds;
    }

    private void delegateBizTask(List<Long> userIds) {
        if (this.taskEntity == null || WfUtils.isEmptyForCollection((Collection)this.taskEntity.getIdentityLinks())) {
            logger.info("task is null or IdentityLinks is empty");
            return;
        }
        String taskModelNumber = this.taskEntity.getTaskDefinitionKey();
        if (WfUtils.isNotEmpty((String)taskModelNumber)) {
            this.bizTask = TaskModelService.create().getTaskModelDefinition(taskModelNumber);
        }
        if (this.bizTask == null || !this.bizTask.isAllowDelegate()) {
            logger.info(String.format("task[%s] for TM[%s] delegate is disable.", this.taskEntity.getId(), this.taskEntityInfo.getNumber()));
            return;
        }
        TaskRuntimeService taskRuntimeService = TaskRuntimeService.create();
        taskRuntimeService.delegateBizTask(this.taskEntity, userIds);
    }

    protected void executeBeforeHandleTaskListeners(TaskEntity taskEntity, Map<String, Object> variables) {
        BizTaskListenerExecuteHelper.create().executeBeforeHandleBizTaskListener(taskEntity, TaskOperation.ASSIGN.getValue(), variables);
    }

    protected void executeHandleTaskListeners(TaskEntity taskEntity, Map<String, Object> variables) {
        BizTaskListenerExecuteHelper.create().executeHandleBizTaskListener(taskEntity, TaskOperation.ASSIGN.getValue(), variables);
    }

    protected void executeAfterHandleTaskListeners(TaskEntity taskEntity, Map<String, Object> variables) {
        BizTaskListenerExecuteHelper.create().executeAfterHandleBizTaskListener(taskEntity, TaskOperation.ASSIGN.getValue(), variables);
    }
}

