/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.cmd.operatelogic;

import java.util.Collection;
import java.util.Map;
import kd.bos.exception.KDException;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.taskmodel.DeleteTaskCmd;
import kd.bos.workflow.engine.impl.cmd.task.taskmodel.ResultInfo;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.TaskHelper;
import kd.bos.workflow.engine.task.BatchOperateResult;
import kd.bos.workflow.engine.task.TaskOperateResult;
import kd.bos.workflow.engine.task.operation.DeleteOperationParam;
import kd.bos.workflow.engine.task.operation.TaskOperationInfo;
import kd.bos.workflow.task.cmd.ITaskOperationPlugin;
import kd.bos.workflow.task.enumeration.TaskOperation;
import kd.bos.workflow.task.exception.TaskErrorCode;
import kd.bos.workflow.task.listeners.BizTaskListenerExecuteHelper;

public class CloseBizTaskCmd
extends DeleteTaskCmd
implements Command<BatchOperateResult>,
ITaskOperationPlugin {
    public CloseBizTaskCmd() {
    }

    public CloseBizTaskCmd(DeleteOperationParam deleteOperationParam) {
        this.deleteOperationParam = deleteOperationParam;
        this.taskIds = deleteOperationParam.getTaskIds();
        this.userId = deleteOperationParam.getOperaterId();
        this.taskOperation = TaskOperation.CLOSE.getValue();
    }

    public BatchOperateResult execute(CommandContext commandContext) {
        this.closeBizTask(commandContext);
        return this.batchOperateResult;
    }

    @Override
    public TaskOperateResult executeTaskOperation(TaskOperationInfo taskOperationInfo) {
        if (!(taskOperationInfo instanceof DeleteOperationParam)) {
            throw new KDException(TaskErrorCode.parseTaskModelError(), new Object[0]);
        }
        this.deleteOperationParam = (DeleteOperationParam)taskOperationInfo;
        this.taskIds = this.deleteOperationParam.getTaskIds();
        this.userId = this.deleteOperationParam.getOperaterId();
        this.taskOperation = TaskOperation.CLOSE.getValue();
        this.closeBizTask(Context.getCommandContext());
        return this.batchOperateResult;
    }

    private void closeBizTask(CommandContext commandContext) {
        ResultInfo resultInfo = this.verifyTaskEntity(commandContext);
        if (!resultInfo.isSuccess()) {
            throw new KDException(TaskErrorCode.verifyNotPassError(), new Object[]{this.taskOperation, WfUtils.listToString((Collection)this.taskIds, (String)","), this.batchOperateResult.toString()});
        }
        this.handleTaskEntities(commandContext);
        this.triggerEvent(commandContext);
    }

    protected void handleTaskInfo(CommandContext commandContext, TaskEntity taskEntity) {
        TaskHelper taskHelper = commandContext.getProcessEngineConfiguration().getTaskHelper();
        taskHelper.skipTask(taskEntity, this.userId, null);
    }

    protected void executeBeforeHandleTaskListeners(TaskEntity taskEntity, Map<String, Object> variables) {
        BizTaskListenerExecuteHelper.create().executeBeforeHandleBizTaskListener(taskEntity, TaskOperation.CLOSE.getValue(), variables);
    }

    protected void executeHandleTaskListeners(TaskEntity taskEntity, Map<String, Object> variables) {
        BizTaskListenerExecuteHelper.create().executeHandleBizTaskListener(taskEntity, TaskOperation.CLOSE.getValue(), variables);
    }

    protected void executeAfterHandleTaskListeners(TaskEntity taskEntity, Map<String, Object> variables) {
        BizTaskListenerExecuteHelper.create().executeAfterHandleBizTaskListener(taskEntity, TaskOperation.CLOSE.getValue(), variables);
    }
}

