/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.cmd.operatelogic;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.taskmodel.CompleteTaskCmd;
import kd.bos.workflow.engine.impl.cmd.task.taskmodel.ResultInfo;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.TaskHelper;
import kd.bos.workflow.engine.task.BatchOperateResult;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.engine.task.TaskOperateResult;
import kd.bos.workflow.engine.task.operation.CompleteOperationParam;
import kd.bos.workflow.engine.task.operation.TaskOperationInfo;
import kd.bos.workflow.task.cmd.ITaskOperationPlugin;
import kd.bos.workflow.task.enumeration.TaskOperation;
import kd.bos.workflow.task.exception.TaskErrorCode;
import kd.bos.workflow.task.job.TaskModelJobHelper;
import kd.bos.workflow.task.listeners.BizTaskListenerExecuteHelper;
import kd.bos.workflow.task.model.BizTask;
import kd.bos.workflow.task.service.TaskModelService;

public class CompleteBizTaskCmd
extends CompleteTaskCmd
implements Command<BatchOperateResult>,
ITaskOperationPlugin {
    private BizTask bizTask;

    public CompleteBizTaskCmd(CompleteOperationParam completeOperationParam) {
        this.completeOperationParam = completeOperationParam;
        this.variables = completeOperationParam.getVariables() == null ? new HashMap() : completeOperationParam.getVariables();
        this.decOptionNumber = completeOperationParam.getDecOptionNumber();
        this.auditMessage = completeOperationParam.getAuditMessage();
        this.userId = completeOperationParam.getOperaterId();
        this.taskIds = completeOperationParam.getTaskIds();
    }

    public CompleteBizTaskCmd() {
    }

    public CompleteBizTaskCmd(List<Long> taskIds, Long userId, boolean compensation, Map<String, Object> variables) {
        this.taskIds = taskIds;
        this.userId = userId;
        this.compensation = compensation;
        this.variables = variables;
    }

    public BatchOperateResult execute(CommandContext commandContext) {
        if (this.compensation) {
            this.handleCompensationTasks(commandContext);
            this.triggerTaskComplateEvent(commandContext);
            return null;
        }
        this.completeBizTask(commandContext);
        return this.batchOperateResult;
    }

    @Override
    public TaskOperateResult executeTaskOperation(TaskOperationInfo taskOperationInfo) {
        if (!(taskOperationInfo instanceof CompleteOperationParam)) {
            throw new KDException(TaskErrorCode.parseTaskModelError(), new Object[0]);
        }
        this.completeOperationParam = (CompleteOperationParam)taskOperationInfo;
        this.variables = this.completeOperationParam.getVariables() == null ? new HashMap() : this.completeOperationParam.getVariables();
        this.decOptionNumber = this.completeOperationParam.getDecOptionNumber();
        this.auditMessage = this.completeOperationParam.getAuditMessage();
        this.userId = this.completeOperationParam.getOperaterId();
        this.taskIds = this.completeOperationParam.getTaskIds();
        this.completeBizTask(Context.getCommandContext());
        return this.batchOperateResult;
    }

    private void completeBizTask(CommandContext commandContext) {
        ResultInfo resultInfo = this.verifyTask();
        if (!resultInfo.isSuccess()) {
            throw new KDException(TaskErrorCode.verifyNotPassError(), new Object[]{TaskOperation.COMPLETE.getValue(), WfUtils.listToString((Collection)this.taskIds, (String)","), resultInfo.getDescription()});
        }
        this.setVariables();
        this.handleTask(commandContext);
    }

    protected void executeBeforeHandleTaskListeners(TaskEntity taskEntity, Map<String, Object> variables) {
        BizTaskListenerExecuteHelper.create().executeBeforeHandleBizTaskListener(taskEntity, TaskOperation.COMPLETE.getValue(), variables);
    }

    protected void executeHandleTaskListeners(TaskEntity taskEntity, Map<String, Object> variables) {
        BizTaskListenerExecuteHelper.create().executeHandleBizTaskListener(taskEntity, TaskOperation.COMPLETE.getValue(), variables);
    }

    protected void executeAfterHandleTaskListeners(TaskEntity taskEntity, Map<String, Object> variables) {
        BizTaskListenerExecuteHelper.create().executeAfterHandleBizTaskListener(taskEntity, TaskOperation.COMPLETE.getValue(), variables);
    }

    protected void revoteCompositeTask(CommandContext commandContext) {
    }

    protected boolean isNeedDealWithCompositeTask() {
        return false;
    }

    public ResultInfo verifyTaskDecision() {
        boolean verifyDecision = true;
        Object verifyObj = this.variables.get("verify");
        if (verifyObj instanceof Boolean) {
            verifyDecision = (Boolean)verifyObj;
        }
        if (verifyDecision) {
            String decOptionNumber = (String)this.variables.get("auditNumber");
            boolean find = false;
            String taskModelNumber = ((TaskEntity)this.taskEntitys.get(0)).getTaskDefinitionKey();
            this.bizTask = TaskModelService.create().getTaskModelDefinition(taskModelNumber);
            if (this.bizTask != null) {
                List decisionOptions = this.bizTask.getDecisionOptions();
                for (DecisionOption decision : decisionOptions) {
                    if (!decOptionNumber.equalsIgnoreCase(decision.getNumber())) continue;
                    this.variables.put("auditNumber", decision.getNumber());
                    this.variables.put("decisionscene", decision.getDecisionScene());
                    this.variables.put("auditName", decision.getName());
                    this.variables.put("auditType", decision.getAuditType());
                    find = true;
                    break;
                }
            }
            if (!find || WfUtils.isEmpty((String)decOptionNumber)) {
                return new ResultInfo(false, ResManager.loadKDString((String)"\u4f20\u5165\u7684\u51b3\u7b56\u9879\u7f16\u7801\u975e\u6cd5\uff0c\u5fc5\u987b\u548c\u8282\u70b9\u51b3\u7b56\u9879\u4e2d\u914d\u7f6e\u7684\u7f16\u7801\u4e00\u81f4\u3002", (String)"CompleteBizTaskCmd_0", (String)"bos-wf-task", (Object[])new Object[0]));
            }
        }
        return new ResultInfo(true);
    }

    protected void planBatchCompensationTaskJob(List<TaskEntity> taskEntities) {
        TaskModelJobHelper.create().planBatchCompensationBizTaskJob(taskEntities, this.variables);
    }

    protected void dealUndealCoordindateTask(CommandContext commandContext, TaskHelper taskHelper, List<TaskEntity> ts) {
    }

    protected Map<String, Object> getHandleTaskParameters(TaskInfo info) {
        this.variables.put("taskCompensation", true);
        this.variables.put("terminal", this.variables.get("terminal"));
        this.variables.put("auditName", this.variables.get("auditMessage"));
        this.variables.put("auditNumber", this.variables.get("auditNumber"));
        return this.variables;
    }
}

