/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.cmd.operatelogic;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.exception.KDException;
import kd.bos.workflow.bpmn.model.BillSubjectModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.calculator.BillSubjectCalculator;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.task.taskmodel.CreateTaskCmd;
import kd.bos.workflow.engine.impl.cmd.task.taskmodel.ResultInfo;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.el.ExpressionManager;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.msg.info.TaskEntityInfo;
import kd.bos.workflow.engine.task.BizType;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.engine.task.TaskOperateResult;
import kd.bos.workflow.engine.task.operation.TaskOperationInfo;
import kd.bos.workflow.task.cmd.ITaskOperationPlugin;
import kd.bos.workflow.task.enumeration.TaskOperation;
import kd.bos.workflow.task.exception.TaskErrorCode;
import kd.bos.workflow.task.listeners.BizTaskListenerExecuteHelper;
import kd.bos.workflow.task.model.BizTask;
import kd.bos.workflow.task.model.BizTaskOperate;
import kd.bos.workflow.task.service.TaskModelService;
import kd.bos.workflow.task.service.TaskRuntimeService;
import org.apache.commons.lang.StringUtils;

public class CreateBizTaskCmd
extends CreateTaskCmd
implements Command<TaskInfo>,
ITaskOperationPlugin {
    private BizTask bizTask;
    private BizTaskOperate bizTaskOperate;

    public CreateBizTaskCmd() {
    }

    public CreateBizTaskCmd(TaskEntityInfo taskEntityInfo) {
        this.taskEntityInfo = taskEntityInfo;
    }

    public TaskInfo execute(CommandContext commandContext) {
        return this.createBizTask(commandContext);
    }

    @Override
    public TaskOperateResult executeTaskOperation(TaskOperationInfo taskOperationInfo) {
        if (!(taskOperationInfo instanceof TaskEntityInfo)) {
            throw new KDException(TaskErrorCode.parseTaskModelError(), new Object[0]);
        }
        this.taskEntityInfo = (TaskEntityInfo)taskOperationInfo;
        CommandContext commandContext = Context.getCommandContext();
        return this.createBizTask(commandContext);
    }

    private TaskInfo createBizTask(CommandContext commandContext) {
        this.setTaskEntityInfo(commandContext);
        ResultInfo resultInfo = this.checkValidity();
        if (!resultInfo.isSuccess()) {
            throw new KDException(TaskErrorCode.verifyNotPassError(), new Object[]{TaskOperation.CREATE.getValue(), "", resultInfo.getDescription()});
        }
        return this.createTask(commandContext);
    }

    protected ResultInfo checkValidity() {
        if (WfUtils.isEmpty((String)this.taskEntityInfo.getNumber())) {
            return new ResultInfo(false, "check taskEntityInfo is fail and taskModel number is empty");
        }
        if (WfUtils.isEmpty((String)this.taskEntityInfo.getSource())) {
            return new ResultInfo(false, "check taskEntityInfo is fail and source is empty");
        }
        String stencilType = this.bizTask.getStencilType();
        if ("outernoentitytask".equals(stencilType)) {
            if (WfUtils.isEmpty((ILocaleString)this.taskEntityInfo.getSourceName())) {
                return new ResultInfo(false, "check taskEntityInfo is fail and sourceName is empty");
            }
            if (this.taskEntityInfo.getBizType() == null) {
                return new ResultInfo(false, "check taskEntityInfo is fail and bizType is empty");
            }
            if (WfUtils.isEmpty((String)this.taskEntityInfo.getUrl())) {
                return new ResultInfo(false, "check taskEntityInfo is fail and url is empty");
            }
        } else if ("innerentitytask".equals(stencilType)) {
            String entityNumber = this.taskEntityInfo.getEntityNumber();
            String businessKey = this.taskEntityInfo.getBusinessKey();
            if (WfUtils.isEmpty((String)entityNumber) || WfUtils.isEmpty((String)businessKey)) {
                return new ResultInfo(false, "create task is fail and taskEntityInfo");
            }
        }
        return new ResultInfo(true, "create task successfully");
    }

    protected void afterBuildTaskEntity(TaskEntity taskEntity) {
        if (taskEntity.getDueDate() == null) {
            taskEntity.setDueDate(this.getTaskDueDate(taskEntity));
        }
        if (WfUtils.isEmpty((ILocaleString)taskEntity.getSubject())) {
            taskEntity.setSubject(this.getTaskSubject(taskEntity));
        }
        if (WfUtils.isEmpty((String)taskEntity.getSource())) {
            taskEntity.setSource(this.bizTask.getHeterosystem());
        }
        taskEntity.setHandleState("willHandled");
        taskEntity.setCategory(this.bizTask.getStencilType());
        taskEntity.setYzjGroupId(this.taskEntityInfo.getBizType().getNumber());
        taskEntity.setTaskDefinitionKey(this.taskEntityInfo.getNumber());
        this.setTaskEntityBillType(taskEntity);
    }

    private void setTaskEntityBillType(TaskEntity taskEntity) {
        String stencilType;
        String billtype = null;
        switch (stencilType = this.bizTask.getStencilType()) {
            case "commontask": {
                billtype = taskEntity.getBillType();
                if (!WfUtils.isEmpty((String)billtype)) break;
                billtype = "1&" + taskEntity.getYzjGroupId();
                break;
            }
            case "innerentitytask": {
                billtype = taskEntity.getBillType();
                break;
            }
            case "outernoentitytask": {
                billtype = "3&" + taskEntity.getSource() + "&" + taskEntity.getYzjGroupId();
                break;
            }
            case "outerentitytask": {
                billtype = "4&" + taskEntity.getSource() + "&" + taskEntity.getBillType();
                break;
            }
            default: {
                billtype = taskEntity.getBillType();
            }
        }
        taskEntity.setBillType(billtype);
    }

    protected void assignTaskParticipants(TaskEntity taskEntity) {
        if (taskEntity.getIdentityLinks() != null && !taskEntity.getIdentityLinks().isEmpty()) {
            return;
        }
        List participants = this.bizTask.getParticipant().getParticipant();
        List participantInfos = this.taskEntityInfo.getParticipantInfos();
        if (WfUtils.isEmptyForCollection((Collection)participants) && WfUtils.isEmptyForCollection((Collection)participantInfos)) {
            return;
        }
        TaskRuntimeService taskRuntimeService = TaskRuntimeService.create();
        taskRuntimeService.assignBizTask(taskEntity, this.taskEntityInfo);
    }

    protected void executeBeforeHandleTaskListeners(TaskEntity taskEntity, Map<String, Object> variables) {
        BizTaskListenerExecuteHelper.create().executeBeforeHandleBizTaskListener(taskEntity, TaskOperation.CREATE.getValue(), variables);
    }

    protected void executeHandleTaskListeners(TaskEntity taskEntity, Map<String, Object> params) {
        BizTaskListenerExecuteHelper.create().executeHandleBizTaskListener(taskEntity, TaskOperation.CREATE.getValue(), params);
    }

    protected void executeAfterHandleTaskListeners(TaskEntity taskEntity, Map<String, Object> params) {
        BizTaskListenerExecuteHelper.create().executeAfterHandleBizTaskListener(taskEntity, TaskOperation.CREATE.getValue(), params);
    }

    protected void planToDoJob(CommandContext commandContext, Long taskId) {
        if (!this.bizTask.isAllowSendTodo() && !this.taskEntityInfo.isAllowSendTodo()) {
            logger.info(String.format("[%s] is not allow send to do", this.bizTask.getNumber()));
            return;
        }
        logger.info(String.format("cannot send todo msg for task[%s]", taskId));
        commandContext.getMessageService().createToDo(taskId);
    }

    private Date getTaskDueDate(TaskEntity taskEntity) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        ExpressionManager expressionManager = processEngineConfiguration.getExpressionManager();
        return null;
    }

    private ILocaleString getTaskSubject(TaskEntity taskEntity) {
        String entityNumber = taskEntity.getEntityNumber();
        String businessKey = taskEntity.getBusinessKey();
        if (StringUtils.isEmpty((String)businessKey.trim()) || WfUtils.isEmpty((String)entityNumber.trim())) {
            return null;
        }
        BillSubjectCalculator billSubjectCalculator = Context.getCommandContext().getProcessEngineConfiguration().getBillSubjectCalculator();
        List<BillSubjectModel> billSubjectModels = this.bizTask.getSubject();
        return billSubjectCalculator.getSubjectByBillSubjectModel(billSubjectModels, businessKey, entityNumber, (VariableScope)taskEntity);
    }

    private void setTaskEntityInfo(CommandContext commandContext) {
        TaskModelService taskModelService = TaskModelService.create();
        String taskModelNumber = this.taskEntityInfo.getNumber();
        if (WfUtils.isNotEmpty((String)taskModelNumber)) {
            this.bizTask = taskModelService.getTaskModelDefinition(taskModelNumber);
        }
        if (this.bizTask == null) {
            throw new KDException(TaskErrorCode.notFindModelDefinitionError(), new Object[]{taskModelNumber});
        }
        if (WfUtils.isEmpty((String)this.taskEntityInfo.getEndType())) {
            this.taskEntityInfo.setEndType(this.bizTask.getEndType());
        }
        if (WfUtils.isEmpty((String)this.taskEntityInfo.getFormKey())) {
            String formKey = this.bizTask.getBillSetting().getFormKey();
            if (WfUtils.isEmpty((String)formKey)) {
                if (WfUtils.isNotEmpty((String)this.taskEntityInfo.getEntityNumber())) {
                    this.taskEntityInfo.setFormKey(this.taskEntityInfo.getEntityNumber());
                }
            } else {
                this.taskEntityInfo.setFormKey(formKey);
            }
        }
        if (WfUtils.isEmpty((String)this.taskEntityInfo.getMobileFormKey())) {
            String mobilFormKey = this.bizTask.getBillSetting().getMobilFormKey();
            if (WfUtils.isEmpty((String)mobilFormKey)) {
                if (WfUtils.isNotEmpty((String)this.taskEntityInfo.getEntityNumber())) {
                    this.taskEntityInfo.setMobileFormKey(this.taskEntityInfo.getEntityNumber() + "_mob");
                }
            } else {
                this.taskEntityInfo.setMobileFormKey(mobilFormKey);
            }
        }
        if (WfUtils.isEmpty((String)this.taskEntityInfo.getProcessingPage())) {
            this.taskEntityInfo.setProcessingPage(this.bizTask.getProcessingPage());
        }
        if (WfUtils.isEmpty((String)this.taskEntityInfo.getProcessingMobilePage())) {
            this.taskEntityInfo.setProcessingMobilePage(this.bizTask.getProcessingMobilePage());
        }
        if (WfUtils.isEmpty((String)this.taskEntityInfo.getEntityNumber())) {
            this.taskEntityInfo.setEntityNumber(this.bizTask.getEntityNumber());
        }
        if (WfUtils.isEmpty((String)this.taskEntityInfo.getSource())) {
            this.taskEntityInfo.setSource(this.bizTask.getHeterosystem());
        }
        if (this.taskEntityInfo.getBizType() == null && WfUtils.isNotEmpty((String)this.bizTask.getBizType())) {
            BizType bizTypeObject = new BizType();
            bizTypeObject.setNumber(this.bizTask.getBizType());
            this.taskEntityInfo.setBizType(bizTypeObject);
        }
        if (WfUtils.isEmpty((String)this.taskEntityInfo.getMobileUrl())) {
            this.taskEntityInfo.setMobileUrl(this.taskEntityInfo.getUrl());
        }
        JSONObject control = new JSONObject();
        control.put("circulate", (Object)"true");
        control.put("transfer", (Object)true);
        this.taskEntityInfo.addParams("control", (Object)control.toJSONString());
    }
}

