/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.cmd.operatelogic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.ExtItfCallerType;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.cmd.task.taskmodel.ResultInfo;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.msg.info.TaskEntityInfo;
import kd.bos.workflow.engine.task.BatchOperateResult;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.engine.task.TaskOperateResult;
import kd.bos.workflow.engine.task.TaskUtils;
import kd.bos.workflow.engine.task.operation.TaskOperationInfo;
import kd.bos.workflow.engine.task.operation.TaskOperationParam;
import kd.bos.workflow.task.cache.TaskModelCacheHelper;
import kd.bos.workflow.task.cmd.operatelogic.AssignBizTaskCmd;
import kd.bos.workflow.task.cmd.operatelogic.CirculateBizTaskCmd;
import kd.bos.workflow.task.cmd.operatelogic.CloseBizTaskCmd;
import kd.bos.workflow.task.cmd.operatelogic.CompleteBizTaskCmd;
import kd.bos.workflow.task.cmd.operatelogic.CreateBizTaskCmd;
import kd.bos.workflow.task.cmd.operatelogic.DeleteBizTaskCmd;
import kd.bos.workflow.task.cmd.operatelogic.SuspendActiveBizTaskCmd;
import kd.bos.workflow.task.cmd.operatelogic.TransferBizTaskCmd;
import kd.bos.workflow.task.enumeration.TaskOperation;
import kd.bos.workflow.task.exception.TaskErrorCode;
import kd.bos.workflow.task.model.BizTaskOperate;
import kd.bos.workflow.task.service.TaskModelService;

public class TaskOperationCmd
implements Command<TaskOperateResult> {
    private static Log logger = LogFactory.getLog(TaskOperationCmd.class);
    private TaskOperation taskOperation;
    private TaskOperationInfo taskOperationInfo;
    private TaskEntity taskEntity;
    private String requestMarkId = "";
    private static final String USEDEFAULT = "useDefault";

    public TaskOperationCmd(TaskOperation taskOperation, TaskOperationInfo taskOperationInfo) {
        this.taskOperation = taskOperation;
        this.taskOperationInfo = taskOperationInfo;
    }

    public TaskOperationCmd(TaskOperation taskOperation, TaskOperationInfo taskOperationInfo, TaskEntity taskEntity) {
        this.taskOperation = taskOperation;
        this.taskOperationInfo = taskOperationInfo;
        this.taskEntity = taskEntity;
    }

    public TaskOperateResult execute(CommandContext commandContext) {
        String taskModelNumber = "";
        try {
            this.requestMarkId = this.getRequestMarkId();
            if (WfUtils.isNotEmpty((String)this.requestMarkId) && WfCacheHelper.putCurrentExecuteBySceneAndKey((String)this.requestMarkId) <= 0) {
                String validateMsg = ResManager.loadKDString((String)"\u8bf7\u6c42\u5df2\u5728\u6267\u884c\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"CompleteTaskCmd_0", (String)"bos-wf-engine", (Object[])new Object[0]);
                throw new KDException(TaskErrorCode.taskOperateDuplicationError(), new Object[]{this.taskOperation.getValue(), validateMsg});
            }
            ResultInfo resultInfo = this.validateTaskInfo();
            if (!resultInfo.isSuccess()) {
                TaskOperateResult taskOperateResult = (TaskOperateResult)resultInfo.getData().get("batchOperateResult");
                return taskOperateResult;
            }
            Map data = resultInfo.getData();
            DynamicObjectCollection taskInfos = (DynamicObjectCollection)data.get("taskInfos");
            taskModelNumber = this.getTaskModelNumber(taskInfos);
            String traceId = RequestContext.get().getTraceId();
            String taskOperationPlugin = this.getTaskOperationLogicPlugin(taskModelNumber);
            logger.info("\u4f7f\u7528\u6a21\u578b\u5b9a\u4e49[%s]\u64cd\u4f5c[%s]\u7684\u4e3b\u903b\u8f91\u63d2\u4ef6[%s],[%s]", new Object[]{taskModelNumber, this.taskOperation.getValue(), taskOperationPlugin, traceId});
            if (WfUtils.isEmpty((String)taskOperationPlugin)) {
                throw new KDException(TaskErrorCode.taskOperationPluginNotExsitError(), new Object[]{this.taskOperation.getValue()});
            }
            TaskOperateResult taskOperateResult = this.invokePlugin(taskOperationPlugin);
            return taskOperateResult;
        }
        catch (Exception e) {
            logger.info(String.format("\u4f7f\u7528\u6a21\u578b\u5b9a\u4e49[%s]\u64cd\u4f5c[%s]\u7684\u4e3b\u903b\u8f91\u63d2\u4ef6\u5f02\u5e38[%s]", taskModelNumber, this.taskOperation.getValue(), WfUtils.getExceptionStacktrace((Throwable)e)));
            throw new KDException(TaskErrorCode.commonError(), new Object[]{e.getMessage()});
        }
        finally {
            if (WfUtils.isNotEmpty((String)this.requestMarkId)) {
                WfCacheHelper.removeCurrentExecuteBySceneAndKey((String)this.requestMarkId);
            }
        }
    }

    private ResultInfo validateTaskInfo() {
        if (TaskOperation.CREATE == this.taskOperation || TaskOperation.ASSIGN == this.taskOperation) {
            return new ResultInfo(true);
        }
        TaskOperationParam taskOperationParam = (TaskOperationParam)this.taskOperationInfo;
        List taskIds = taskOperationParam.getTaskIds();
        int size = taskIds.size();
        DynamicObjectCollection taskInfos = QueryServiceHelper.query((String)"wf_task", (String)"id, taskdefinitionkey, billno, source", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)taskIds)});
        if (taskInfos == null || taskInfos.isEmpty()) {
            throw new KDException(TaskErrorCode.verifyNotPassError(), new Object[]{this.taskOperation.getValue(), WfUtils.listToString((Collection)taskIds, (String)","), "tasks is not exist"});
        }
        StringBuilder logMsg = new StringBuilder();
        Iterator iterator = taskInfos.iterator();
        while (iterator.hasNext()) {
            DynamicObject next = (DynamicObject)iterator.next();
            if (TaskUtils.isBizTask((String)next.getString("source"))) continue;
            long taskId = next.getLong("id");
            String billno = next.getString("billno");
            logMsg.append("[").append(taskId).append("-").append(billno).append("]").append(",");
            taskIds.remove(taskId);
            iterator.remove();
        }
        if (WfUtils.isNotEmpty((String)logMsg.toString())) {
            logMsg.append(" is not bizTasks");
            logger.warn(logMsg.toString());
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (taskInfos.isEmpty()) {
            BatchOperateResult batchOperateResult = new BatchOperateResult();
            batchOperateResult.setValidateMsg("All tasks do not belong to bizTasks");
            batchOperateResult.setSucessCount(0);
            batchOperateResult.setFailedCount(size);
            data.put("batchOperateResult", batchOperateResult);
            return new ResultInfo(false, "All tasks do not belong to bizTasks", data);
        }
        data.put("taskInfos", taskInfos);
        return new ResultInfo(true, "", data);
    }

    private TaskOperateResult invokePlugin(String taskOperationPlugin) {
        HashMap<String, String> classInfo = new HashMap<String, String>();
        classInfo.put("type", "class");
        classInfo.put("value", taskOperationPlugin);
        String impl = SerializationUtils.toJsonString(classInfo);
        Object[] args = null;
        if (this.taskOperationInfo != null && this.taskEntity != null) {
            args = new Object[]{this.taskOperationInfo, this.taskEntity};
        } else {
            if (this.taskOperationInfo != null) {
                args = new Object[]{this.taskOperationInfo};
            }
            if (this.taskEntity != null) {
                args = new Object[]{this.taskEntity};
            }
        }
        Object result = ExternalInterfaceUtil.executeExtItf((ExtItfCallerType)ExtItfCallerType.TASKOPERATIONPLUGIN, (String)impl, args);
        if (result instanceof BatchOperateResult) {
            return (BatchOperateResult)result;
        }
        if (result instanceof TaskInfo) {
            return (TaskInfo)result;
        }
        return null;
    }

    private String getTaskOperationLogicPlugin(String taskModelNumber) {
        String taskOperationPlugin = TaskModelCacheHelper.getOperationMainLogicPlugin(taskModelNumber, this.taskOperation);
        if (WfUtils.isEmpty((String)taskOperationPlugin)) {
            BizTaskOperate bizTaskOperate = TaskModelService.create().getTaskModelOperateDefinition(taskModelNumber, this.taskOperation);
            taskOperationPlugin = USEDEFAULT;
            if (bizTaskOperate != null && WfUtils.isNotEmpty((String)bizTaskOperate.getOperateMainLogicPlugin())) {
                taskOperationPlugin = bizTaskOperate.getOperateMainLogicPlugin();
            }
            logger.info(String.format("\u64cd\u4f5c[%s]\u7684\u903b\u8f91\u63d2\u4ef6[%s].and from model", this.taskOperation.getValue(), taskOperationPlugin));
            TaskModelCacheHelper.putOperationMainLogicPlugin(taskModelNumber, this.taskOperation, taskOperationPlugin);
        } else {
            logger.info(String.format("\u64cd\u4f5c[%s]\u7684\u903b\u8f91\u63d2\u4ef6[%s].and from cache", this.taskOperation.getValue(), taskOperationPlugin));
        }
        if (USEDEFAULT.equalsIgnoreCase(taskOperationPlugin)) {
            taskOperationPlugin = this.getOperationDefaultLogicPlugin();
        }
        return taskOperationPlugin;
    }

    private String getOperationDefaultLogicPlugin() {
        Class operationPlugin;
        switch (this.taskOperation) {
            case CREATE: {
                operationPlugin = CreateBizTaskCmd.class;
                break;
            }
            case ASSIGN: {
                operationPlugin = AssignBizTaskCmd.class;
                break;
            }
            case COMPLETE: {
                operationPlugin = CompleteBizTaskCmd.class;
                break;
            }
            case DELETE: {
                operationPlugin = DeleteBizTaskCmd.class;
                break;
            }
            case CLOSE: {
                operationPlugin = CloseBizTaskCmd.class;
                break;
            }
            case TRANSFER: {
                operationPlugin = TransferBizTaskCmd.class;
                break;
            }
            case CIRCULATE: {
                operationPlugin = CirculateBizTaskCmd.class;
                break;
            }
            case SUSPEND: 
            case ACTIVATE: {
                operationPlugin = SuspendActiveBizTaskCmd.class;
                break;
            }
            default: {
                operationPlugin = null;
            }
        }
        if (operationPlugin != null) {
            return operationPlugin.getCanonicalName();
        }
        return null;
    }

    private String getTaskModelNumber(DynamicObjectCollection taskInfos) {
        String taskModelNumber = "";
        taskModelNumber = TaskOperation.CREATE == this.taskOperation ? ((TaskEntityInfo)this.taskOperationInfo).getNumber() : (TaskOperation.ASSIGN == this.taskOperation ? this.taskEntity.getTaskDefinitionKey() : ((DynamicObject)taskInfos.get(0)).getString("taskdefinitionkey"));
        return taskModelNumber;
    }

    private String getRequestMarkId() {
        if (TaskOperation.CREATE == this.taskOperation) {
            return null;
        }
        if (this.taskEntity != null) {
            return this.getRequestMarkId(this.taskEntity.getId());
        }
        TaskOperationParam taskOperationParam = (TaskOperationParam)this.taskOperationInfo;
        List taskIds = taskOperationParam.getTaskIds();
        return this.getRequestMarkId(taskIds);
    }

    private String getRequestMarkId(Long taskId) {
        ArrayList<Long> taskIds = new ArrayList<Long>();
        taskIds.add(taskId);
        return this.getRequestMarkId(taskIds);
    }

    private String getRequestMarkId(List<Long> taskIds) {
        String requestKey = WfUtils.listToString(Collections.singletonList(taskIds), (String)",");
        return String.format("wf/taskmodeloperate/%s/%s", this.taskOperation.getValue(), requestKey);
    }
}

