/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.cmd.operatelogic;

import java.util.Collection;
import java.util.Map;
import kd.bos.exception.KDException;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.taskmodel.ResultInfo;
import kd.bos.workflow.engine.impl.cmd.task.taskmodel.TransferTaskCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.task.BatchOperateResult;
import kd.bos.workflow.engine.task.TaskOperateResult;
import kd.bos.workflow.engine.task.operation.TaskOperationInfo;
import kd.bos.workflow.engine.task.operation.TransferOperationParam;
import kd.bos.workflow.engine.task.operation.UpdateParticipantParam;
import kd.bos.workflow.task.cmd.ITaskOperationPlugin;
import kd.bos.workflow.task.enumeration.TaskOperation;
import kd.bos.workflow.task.exception.TaskErrorCode;
import kd.bos.workflow.task.listeners.BizTaskListenerExecuteHelper;
import kd.bos.workflow.task.model.BizTask;
import org.apache.commons.collections.map.HashedMap;

public class TransferBizTaskCmd
extends TransferTaskCmd
implements Command<BatchOperateResult>,
ITaskOperationPlugin {
    Map<Long, BizTask> bizTaskMapping = new HashedMap();

    public TransferBizTaskCmd() {
    }

    public TransferBizTaskCmd(TransferOperationParam transferOperationParam) {
        this.transferOperationParam = transferOperationParam;
        this.transfererId = transferOperationParam.getTransfererId();
        this.transferOpinion = transferOperationParam.getTransferOpinion();
        this.taskIds = transferOperationParam.getTaskIds();
        this.transferSubscribe = transferOperationParam.isTransferSubscribe();
        this.ownerId = transferOperationParam.getOperaterId();
    }

    public TransferBizTaskCmd(UpdateParticipantParam updateParticipantParam) {
        this.updateParticipantParam = updateParticipantParam;
        this.transferOpinion = updateParticipantParam.getTransferOpinion();
        this.taskIds = updateParticipantParam.getTaskIds();
        this.ownerId = updateParticipantParam.getOperaterId();
        this.particpationIds = updateParticipantParam.getParticipantIds();
        this.isAdminTransfer = true;
    }

    public BatchOperateResult execute(CommandContext commandContext) {
        this.transferBizTask(commandContext);
        return this.batchOperateResult;
    }

    @Override
    public TaskOperateResult executeTaskOperation(TaskOperationInfo taskOperationInfo) {
        if (taskOperationInfo instanceof UpdateParticipantParam) {
            this.updateParticipantParam = (UpdateParticipantParam)taskOperationInfo;
            this.transferOpinion = this.updateParticipantParam.getTransferOpinion();
            this.taskIds = this.updateParticipantParam.getTaskIds();
            this.ownerId = this.updateParticipantParam.getOperaterId();
            this.particpationIds = this.updateParticipantParam.getParticipantIds();
            this.isAdminTransfer = true;
        } else if (taskOperationInfo instanceof TransferOperationParam) {
            this.transferOperationParam = (TransferOperationParam)taskOperationInfo;
            this.transfererId = this.transferOperationParam.getTransfererId();
            this.transferOpinion = this.transferOperationParam.getTransferOpinion();
            this.taskIds = this.transferOperationParam.getTaskIds();
            this.transferSubscribe = this.transferOperationParam.isTransferSubscribe();
            this.ownerId = this.transferOperationParam.getOperaterId();
        } else {
            throw new KDException(TaskErrorCode.parseTaskModelError(), new Object[0]);
        }
        this.transferBizTask(Context.getCommandContext());
        return this.batchOperateResult;
    }

    private void transferBizTask(CommandContext commandContext) {
        ResultInfo resultInfo = this.verifyTaskEntity(commandContext);
        if (!resultInfo.isSuccess()) {
            throw new KDException(TaskErrorCode.verifyNotPassError(), new Object[]{TaskOperation.TRANSFER.getValue(), WfUtils.listToString((Collection)this.taskIds, (String)","), this.batchOperateResult.toString()});
        }
        this.transferTaskEntities(commandContext);
        this.triggerTransferEvent(commandContext);
    }

    protected void executeBeforeHandleTaskListeners(TaskEntity taskEntity, Map<String, Object> variables) {
        this.buildListenerParams(variables);
        BizTaskListenerExecuteHelper.create().executeBeforeHandleBizTaskListener(taskEntity, TaskOperation.TRANSFER.getValue(), variables);
    }

    protected void executeHandleTaskListeners(TaskEntity taskEntity, Map<String, Object> variables) {
        this.buildListenerParams(variables);
        BizTaskListenerExecuteHelper.create().executeHandleBizTaskListener(taskEntity, TaskOperation.TRANSFER.getValue(), variables);
    }

    protected void executeAfterHandleTaskListeners(TaskEntity taskEntity, Map<String, Object> variables) {
        this.buildListenerParams(variables);
        BizTaskListenerExecuteHelper.create().executeAfterHandleBizTaskListener(taskEntity, TaskOperation.TRANSFER.getValue(), variables);
    }

    protected void transferCompositeTask(CommandContext commandContext, TaskEntity taskEntity) {
    }

    protected void updateHitaskInstPresentAssignee(CommandContext commandContext, TaskEntity taskEntity) {
    }
}

