/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.channel.cache.MsgServiceCache;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.identity.UserInfo;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.task.processassistant.ProcessAssistantUtil;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.CachedEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.info.ToDoInfo;
import kd.bos.workflow.task.entity.TaskJobEntity;
import kd.bos.workflow.task.entity.TaskJobEntityImpl;
import kd.bos.workflow.task.entity.TaskJobEntityManager;
import kd.bos.workflow.task.entity.cachematcher.TaskJobsByIdsMatcher;

public class TaskJobEntityManagerImpl
extends AbstractEntityManager<TaskJobEntity>
implements TaskJobEntityManager {
    private static Log log = LogFactory.getLog(TaskJobEntityManagerImpl.class);
    protected CachedEntityMatcher<TaskJobEntity> taskJobsByIdsMatcher = new TaskJobsByIdsMatcher();

    public TaskJobEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    public Class<? extends TaskJobEntity> getManagedEntityClass() {
        return TaskJobEntityImpl.class;
    }

    public String getSelectFields() {
        return "id,jobtype,lockexpirationtime,exclusive,lockownerid,executionid,processinstanceid,processdefinitionid,retries,businesskey,operation,exceptionmessage,duedate,repeat,jobhandlertype,jobhandlerconfiguration,createdate,modifydate,elementid,srcjobid,roottraceno,executor,success,endtime,duration,state,source,rootjobid,biztraceno,orgunitid,orgviewid,billno,entityname,activityname,assigneename,channelnumber,channelname,entitynumber,taskid,interfacetype,traceid,retrycount,todostate";
    }

    public void insert(TaskJobEntity entity) {
        this.insert((Entity)entity, true);
    }

    public TaskJobEntity create() {
        return new TaskJobEntityImpl();
    }

    @Override
    public List<TaskJobEntity> getTaskJobsByIds(Collection<Long> ids, String fields) {
        EntityQueryBuilder queryBuilder = this.createQueryBuilder().addFilter("id", "in", ids);
        if (fields != null) {
            queryBuilder.setSelectFields(fields);
        }
        return this.findByQueryBuilder(queryBuilder, this.taskJobsByIdsMatcher, ids, true);
    }

    @Override
    public TaskJobEntity getTaskJobByRootJobId(Long rootJobId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("rootJobId", "=", (Object)rootJobId).setLimit(1);
        List list = this.findByQueryBuilder(eb);
        return WfUtils.isNotEmptyForCollection((Collection)list) ? (TaskJobEntity)list.get(0) : null;
    }

    @Override
    public TaskJobEntity copyFromJobEntity(JobEntity job) {
        TaskJobEntity taskJobEntity = this.create();
        taskJobEntity.setJobType(job.getJobType());
        taskJobEntity.setLockExpirationTime(job.getLockExpirationTime());
        taskJobEntity.setLockOwnerId(job.getLockOwnerId());
        taskJobEntity.setExclusive(job.isExclusive());
        taskJobEntity.setExecutionId(job.getExecutionId());
        taskJobEntity.setProcessInstanceId(job.getProcessInstanceId());
        taskJobEntity.setProcessDefinitionId(job.getProcessDefinitionId());
        taskJobEntity.setRetries(job.getRetries());
        taskJobEntity.setDuedate(job.getDuedate());
        taskJobEntity.setRepeat(job.getRepeat());
        taskJobEntity.setJobHandlerType(job.getJobHandlerType());
        taskJobEntity.setJobHandlerConfiguration(job.getJobHandlerConfiguration());
        taskJobEntity.setBusinessKey(job.getBusinessKey());
        taskJobEntity.setOperation(job.getOperation());
        taskJobEntity.setEntityNumber(job.getEntityNumber());
        taskJobEntity.setElementId(job.getElementId());
        taskJobEntity.setSrcJobId(job.getSrcJobId());
        taskJobEntity.setRootTraceNo(job.getRootTraceNo());
        taskJobEntity.setExecutorServer(job.getExecutorServer());
        taskJobEntity.setSuccess(job.isSuccess());
        taskJobEntity.setEndTime(job.getEndTime());
        taskJobEntity.setDuration(job.getDuration());
        taskJobEntity.setState(job.getState());
        taskJobEntity.setSource(job.getSource());
        taskJobEntity.setBizTraceNo(job.getBizTraceNo());
        taskJobEntity.setOrgUnitId(job.getOrgUnitId());
        taskJobEntity.setOrgViewId(job.getOrgViewId());
        return taskJobEntity;
    }

    @Override
    public TaskJobEntity packageTaskJobEntity(TaskJobEntity taskJobEntity, CommandContext commandContext, MessageContext ctx, ToDoInfo model, String channelNumber, String todoState) {
        if (taskJobEntity == null) {
            taskJobEntity = this.create();
        }
        taskJobEntity.setBillNo(model.getBillNo());
        TaskEntity entity = (TaskEntity)commandContext.getTaskEntityManager().findById(model.getTaskId());
        if (entity == null) {
            HistoricTaskInstanceEntity historicTaskInstance = (HistoricTaskInstanceEntity)commandContext.getHistoricTaskInstanceEntityManager().findById(model.getTaskId());
            if (historicTaskInstance != null) {
                taskJobEntity.setEntityName(historicTaskInstance.getEntityName());
                taskJobEntity.setActivityName(historicTaskInstance.getName());
                taskJobEntity.setProcessType(historicTaskInstance.getProcessType());
            } else {
                taskJobEntity.setEntityName((ILocaleString)new LocaleString(ctx.getEntityName()));
            }
        } else {
            taskJobEntity.setEntityName(entity.getEntityName());
            taskJobEntity.setActivityName(entity.getName());
            taskJobEntity.setProcessType(entity.getProcessType());
        }
        List modelUserIds = model.getUserIds();
        int size = modelUserIds.size() >= 50 ? 50 : modelUserIds.size();
        LinkedHashSet assigneeIds = new LinkedHashSet(size);
        for (int i = 0; i < size; ++i) {
            assigneeIds.add(modelUserIds.get(i));
        }
        Map userInfoMap = ProcessAssistantUtil.queryUserInfos(assigneeIds);
        ArrayList<ILocaleString> assigneeNames = new ArrayList<ILocaleString>(assigneeIds.size());
        if (WfUtils.isNotEmptyForMap((Map)userInfoMap)) {
            for (Long userId : assigneeIds) {
                UserInfo userInfo = (UserInfo)userInfoMap.get(userId.toString());
                assigneeNames.add(userInfo.getName());
            }
        }
        taskJobEntity.setAssigneeName(TaskJobEntityManagerImpl.getAssigneeName(assigneeNames));
        taskJobEntity.setChannelNumber(channelNumber);
        MsgChannelInfo channelCfgInfo = MsgServiceCache.getMsgChannel((String)channelNumber);
        LocaleString channelName = channelCfgInfo != null ? this.getChannelName(channelCfgInfo.getName()) : new LocaleString("");
        taskJobEntity.setChannelName((ILocaleString)channelName);
        taskJobEntity.setTaskId(model.getTaskId());
        taskJobEntity.setInterfaceType(model.getState().name());
        taskJobEntity.setProcessInstanceId(ctx.getProcessInstanceId());
        taskJobEntity.setProcessDefinitionId(ctx.getProcessDefinitionId());
        taskJobEntity.setExecutionId(ctx.getExecutionId());
        taskJobEntity.setBusinessKey(ctx.getBusinessKey());
        taskJobEntity.setEntityNumber(ctx.getEntityNumber());
        taskJobEntity.setTraceId(RequestContext.get().getTraceId());
        if (TaskJobEntity.TodoState.DEALSUCCESS.name().equalsIgnoreCase(todoState)) {
            taskJobEntity.setRetryCount(0);
            taskJobEntity.setExceptionMessage("success");
        }
        taskJobEntity.setTodoState(todoState);
        return taskJobEntity;
    }

    private ILocaleString getChannelName(String channel) {
        LocaleString channelName = new LocaleString();
        if (!StringUtils.isBlank((CharSequence)channel)) {
            Map map = (Map)SerializationUtils.fromJsonString((String)channel, Map.class);
            for (Map.Entry entry : map.entrySet()) {
                channelName.setItem((String)entry.getKey(), entry.getValue());
            }
        }
        return channelName;
    }

    public static ILocaleString getAssigneeName(List<ILocaleString> assigneeNames) {
        LocaleString assigneeName = new LocaleString();
        for (Lang lang : WfUtils.getSupportLangs()) {
            StringBuilder userName = new StringBuilder();
            for (ILocaleString format : assigneeNames) {
                if (WfUtils.isNotEmpty((String)((String)format.get((Object)lang.toString())))) {
                    userName.append((String)format.get((Object)lang.toString())).append(',');
                    continue;
                }
                String defaultString = WfMultiLangUtils.getValueFromLocalString((ILocaleString)format, (String)lang.toString());
                defaultString = WfUtils.isNotEmpty((String)defaultString) ? defaultString + "," : "";
                userName.append(defaultString);
            }
            String userNameStr = userName.toString();
            if (WfUtils.isNotEmpty((String)userNameStr) && (userNameStr = userName.substring(0, userName.length() - 1)).length() >= 255) {
                userNameStr = userNameStr.substring(0, 251) + "...";
            }
            assigneeName.setItem(lang.toString(), (Object)userNameStr);
        }
        return assigneeName;
    }
}

