/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.invocation;

import java.util.List;
import java.util.Map;
import kd.bos.workflow.api.AgentTask;
import kd.bos.workflow.bpmn.model.MapExceptionEntry;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.Expression;
import kd.bos.workflow.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import kd.bos.workflow.engine.impl.bpmn.helper.ClassDelegate;
import kd.bos.workflow.engine.impl.bpmn.parser.FieldDeclaration;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.delegate.invocation.DelegateInvocation;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFIllegalArgumentException;
import kd.bos.workflow.task.enumeration.ListenerInvocationType;
import kd.bos.workflow.task.invocation.BizTaskListenerInvocation;
import kd.bos.workflow.task.listeners.BizTaskListener;

public class BizTaskClassDelegate
extends AbstractBpmnActivityBehavior
implements BizTaskListener {
    private static final long serialVersionUID = 1L;
    private static final String DOESN_T_IMPLEMENT = " doesn't implement ";
    protected String serviceTaskId;
    protected String className;
    protected List<FieldDeclaration> fieldDeclarations;
    protected BizTaskListener bizTaskListenerInstance;
    protected Expression skipExpression;
    protected List<MapExceptionEntry> mapExceptions;

    public BizTaskClassDelegate(String className, List<FieldDeclaration> fieldDeclarations, Expression skipExpression) {
        this.className = className;
        this.fieldDeclarations = fieldDeclarations;
        this.skipExpression = skipExpression;
    }

    public BizTaskClassDelegate(String id, String className, List<FieldDeclaration> fieldDeclarations, Expression skipExpression, List<MapExceptionEntry> mapExceptions) {
        this(className, fieldDeclarations, skipExpression);
        this.serviceTaskId = id;
        this.mapExceptions = mapExceptions;
    }

    public BizTaskClassDelegate(String className, List<FieldDeclaration> fieldDeclarations) {
        this(className, fieldDeclarations, null);
    }

    @Override
    public void beforeHandleTask(AgentTask agentTask, String eventName, Map<String, Object> params) {
        this.invocateBizTaskListener((TaskEntity)agentTask, eventName, ListenerInvocationType.BEFOREHANDLE, params);
    }

    @Override
    public void handleTask(AgentTask agentTask, String eventName, Map<String, Object> params) {
        this.invocateBizTaskListener((TaskEntity)agentTask, eventName, ListenerInvocationType.HANDLE, params);
    }

    @Override
    public void afterHandleTask(AgentTask agentTask, String eventName, Map<String, Object> params) {
        this.invocateBizTaskListener((TaskEntity)agentTask, eventName, ListenerInvocationType.AFTERHANDLE, params);
    }

    private void invocateBizTaskListener(TaskEntity taskEntity, String eventName, ListenerInvocationType invocationType, Map<String, Object> params) {
        if (this.bizTaskListenerInstance == null) {
            this.bizTaskListenerInstance = this.getBizTaskListenerInstance();
        }
        try {
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation((DelegateInvocation)new BizTaskListenerInvocation(this.bizTaskListenerInstance, eventName, taskEntity, invocationType, params));
        }
        catch (WFEngineException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WFEngineException(String.format("BizTaskListener has Exception while bizTask [%s]-[%s] and exceptionMsg [%s]", taskEntity.getId(), eventName, WfUtils.getExceptionStacktrace((Throwable)e)), (Throwable)e);
        }
    }

    private BizTaskListener getBizTaskListenerInstance() {
        Object delegateInstance = this.instantiateDelegate(this.className, this.fieldDeclarations);
        if (delegateInstance instanceof BizTaskListener) {
            return (BizTaskListener)delegateInstance;
        }
        throw new WFIllegalArgumentException(delegateInstance.getClass().getName() + DOESN_T_IMPLEMENT + BizTaskListener.class);
    }

    protected Object instantiateDelegate(String className, List<FieldDeclaration> fieldDeclarations) {
        return ClassDelegate.defaultInstantiateDelegate((String)className, fieldDeclarations);
    }
}

