/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.job.asyncexecutor.consumer;

import java.util.List;
import java.util.Map;
import kd.bos.bec.engine.consumer.BizEventConsumer;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.dlock.DLockInfo;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.thread.ThreadTruck;
import kd.bos.workflow.engine.ProcessEngines;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.asyncexecutor.ExecuteAsyncRunnable;
import kd.bos.workflow.engine.impl.asyncexecutor.RepeatJobModel;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.job.JobHandleStrategy;
import kd.bos.workflow.engine.impl.cmd.job.JobHandleStrategyFactory;
import kd.bos.workflow.engine.impl.persistence.entity.job.AbstractJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobStateEnum;
import kd.bos.workflow.engine.runtime.ExecuteJob;
import kd.bos.workflow.service.WfTraceType;
import kd.bos.workflow.task.cache.TaskModelCacheHelper;
import kd.bos.workflow.task.job.asyncexecutor.entity.TaskJobRecordEntity;
import kd.bos.workflow.util.WfCommonUtil;

public class TaskJobConsumer {
    private static Log log = LogFactory.getLog(BizEventConsumer.class);
    private ProcessEngineConfigurationImpl processEngineConfiguration = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object body, String messageId, boolean resend, MessageAcker acker) {
        if (this.processEngineConfiguration == null) {
            this.processEngineConfiguration = (ProcessEngineConfigurationImpl)ProcessEngines.getDefaultProcessEngine().getProcessEngineConfiguration();
        }
        long start = System.currentTimeMillis();
        JobHandleStrategy strategy = null;
        Long jobId = null;
        try {
            if (body == null || !(body instanceof TaskJobRecordEntity)) {
                log.error(String.format("\u4eceMQ\u83b7\u53d6\u5230\u7684job\u4e3a\u975e\u6cd5Job\uff0c\u672a\u5305\u542b\u6d88\u606f\u914d\u7f6e,\u6d88\u606ftask[%s],\u8c03\u5ea6\u9519\u4e86\uff01", messageId));
                return;
            }
            TaskJobRecordEntity taskJob = (TaskJobRecordEntity)body;
            log.info(String.format("taskJob\u3010id=%1$d,type=%2$s\u3011\u5206\u53d1\u8fc7\u6765\uff0c\u5f00\u59cb\u6267\u884c\uff1a", taskJob.getId(), taskJob.getJobHandlerType()));
            strategy = JobHandleStrategyFactory.getJobHandleStrategy((String)taskJob.getSource(), (String)taskJob.getJobType());
            if (strategy == null) {
                log.error(String.format("\u4eceMQ\u83b7\u53d6\u5230\u7684job\u4e3a\u975e\u6cd5Job\uff0csource\u9519\u8bef\uff0c\u65e0\u6cd5\u627e\u5230\u89e3\u6790\u7c7b,\u6d88\u606ftask[%1$s],source[%2$s]\uff01", jobId, taskJob.getSource()));
                return;
            }
            strategy.setSource(taskJob.getSource());
            strategy.setProcessEngineConfiguration(this.processEngineConfiguration);
            jobId = taskJob.getId();
            taskJob = (TaskJobRecordEntity)strategy.findJob(jobId, true);
            if (taskJob == null) {
                log.info(String.format("\u4eceMQ\u83b7\u53d6\u5230\u7684job\u4e3a\u7a7a\uff0c\u53ef\u80fdjob\u5df2\u7ecf\u88ab\u5904\u7406\u4e86,\u6d88\u606ftask[%s]\uff01", messageId));
                return;
            }
            String configuration = taskJob.getJobHandlerConfiguration();
            if (WfUtils.isNotEmpty((String)configuration)) {
                WfUtils.restoreRequestContext((String)configuration);
            }
            RepeatJobModel repeatJob = taskJob.getRepeatJobModel();
            WfTraceType.getOrCreate().setJobInfo((AbstractJobEntity)taskJob, repeatJob);
            taskJob.setRootTraceNo(RequestContext.get().getTraceId());
            taskJob.setExecutor(WfCommonUtil.getServiceNodeIpInstanceId((String)WfUtils.getServerHost(), (String)Instance.getInstanceId()));
            this.addSeparateStorageKey(taskJob);
            this.execute(taskJob, strategy);
            log.info(String.format("job[%s],taskId[%s] execute normally,cost [%s]ms", jobId, messageId, System.currentTimeMillis() - start));
        }
        catch (Throwable exp) {
            long end = System.currentTimeMillis();
            String error = WfUtils.getExceptionStacktrace((Throwable)exp);
            log.error(String.format("job[%s] is faild to execute with unknow exception,msg is [%s],cost [%s]ms", messageId, error, end - start));
            if (strategy != null && WfUtils.isNotEmpty(jobId)) {
                try {
                    strategy.updateJobErrorMsg(jobId, error);
                }
                catch (Exception e) {
                    log.error(String.format("update job error message error ! %s", WfUtils.getExceptionStacktrace((Throwable)exp)));
                }
            }
        }
        finally {
            WfTraceType.getOrCreate().clear();
            this.removeExtraVariableFromThreadTruck();
            acker.ack(messageId);
        }
    }

    private void addSeparateStorageKey(TaskJobRecordEntity taskJob) {
        Map payload;
        String configuration = taskJob.getJobHandlerConfiguration();
        if (WfUtils.isNotEmpty((String)configuration) && WfUtils.isNotEmptyForMap((Map)(payload = (Map)SerializationUtils.fromJsonString((String)configuration, Map.class))) && WfUtils.isNotEmpty((String)((String)payload.get("separateStorageKey")))) {
            ThreadTruck.put((Object)"separateStorageKey", payload.get("separateStorageKey"));
            log.info(String.format("add separate storage key[%s]", payload.get("separateStorageKey")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(TaskJobRecordEntity jobEntity, JobHandleStrategy strategy) {
        block23: {
            List nodes;
            boolean alive;
            if (TaskModelCacheHelper.isCurrentExecuting(jobEntity.getId(), jobEntity.getBusinessKey())) {
                log.info(String.format("job[%s]\u6b63\u5728\u6267\u884c\uff0c\u56e0\u4e3a\u5206\u5e03\u5f0f\u9501\u4f1a\u5931\u6548\uff0c\u6240\u4ee5\u7528\u7f13\u5b58\u6b63\u5728\u8fd0\u884c\u7684jobId\u6765\u8fc7\u6ee4\uff0c\u540c\u65f6\u51cf\u8f7b\u9501\u7684\u538b\u529b\uff0c\u8fd9\u79cd\u60c5\u51b5\u5f88\u5c11\u89c1\uff01", jobEntity.getId()));
                return;
            }
            if ((JobStateEnum.PREEXECUTING.getNumber().equals(jobEntity.getState()) || JobStateEnum.EXECUTING.getNumber().equals(jobEntity.getState())) && (alive = WfCommonUtil.isServiceNodeAlive((List)(nodes = WfCommonUtil.getServiceNodes()), (String)jobEntity.getExecutor()))) {
                TaskModelCacheHelper.putCurrentExecuteJobState(jobEntity.getId(), jobEntity.getBusinessKey());
                log.info(String.format("job[%s] \u6b63\u5728\u6267\u884c\u4e2d\uff0c\u6267\u884c\u673a\u72b6\u6001\u6b63\u5e38\uff0c\u66f4\u65b0\u7f13\u5b58\u3002", jobEntity.getId()));
                return;
            }
            RepeatJobModel repeatJob = jobEntity.getRepeatJobModel();
            if (repeatJob != null && WfUtils.isNotEmpty((String)repeatJob.getLockKey()) && !WfUtils.isSyncRun()) {
                try (DLock tlock = DLock.create((String)String.format("wf/bizlock/%s", repeatJob.getLockKey()), (String)String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u9501\u5b9a[%1$s-%2$s]", (String)"WfJobHandler_5", (String)"bos-wf-engine", (Object[])new Object[0]), jobEntity.getId(), jobEntity.getJobHandlerType())).fastMode();){
                    if (RepeatJobModel.JobLockedStrategy.DISCARD == repeatJob.getRepeatJobStrategy()) {
                        boolean current;
                        boolean lockSuccess = tlock.tryLock(3000L);
                        if (lockSuccess) {
                            try {
                                jobEntity.setRootTraceNo(RequestContext.get().getTraceId());
                                jobEntity.setExecutor(WfCommonUtil.getServiceNodeIpInstanceId((String)WfUtils.getServerHost(), (String)Instance.getInstanceId()));
                                TaskModelCacheHelper.putCurrentExecuteJobState(jobEntity.getId(), jobEntity.getBusinessKey());
                                log.info(String.format("taskJob[%s][%s] is locked to execute", jobEntity.getId(), jobEntity.getRootJobId()));
                                ExecuteAsyncRunnable asyncRunnable = new ExecuteAsyncRunnable((ExecuteJob)jobEntity, this.processEngineConfiguration);
                                asyncRunnable.run();
                                break block23;
                            }
                            finally {
                                TaskModelCacheHelper.removeCurrentExecuteJobState(jobEntity.getId(), jobEntity.getBusinessKey());
                            }
                        }
                        String msg = String.format("Job[%s] type[%s] lockkey[%s] is locked and executing by another thread.", jobEntity.getId(), jobEntity.getJobHandlerType(), repeatJob.getLockKey());
                        log.info(msg);
                        DLockInfo lockInfo = DLock.getLockInfo((String)String.format("wf/bizlock/%s", repeatJob.getLockKey()));
                        boolean sameTypeJob = lockInfo.getDesc() != null && lockInfo.getDesc().contains(jobEntity.getJobHandlerType());
                        boolean bl = current = lockInfo.getDesc() != null && lockInfo.getDesc().contains(String.valueOf(jobEntity.getId()));
                        if (sameTypeJob && !current) {
                            jobEntity.setState(JobStateEnum.COMPLETED.getNumber());
                            String eMsg = jobEntity.getExceptionMessage();
                            if (WfUtils.isNotEmpty((String)eMsg)) {
                                jobEntity.setExceptionMessage(eMsg + " [discard because of another job thread locked]");
                            } else {
                                jobEntity.setExceptionMessage("[discard because of another job thread locked]");
                            }
                            strategy.updateJobState((ExecuteJob)jobEntity, true);
                        }
                        break block23;
                    }
                    tlock.lock();
                    ExecuteAsyncRunnable asyncRunnable = new ExecuteAsyncRunnable((ExecuteJob)jobEntity, this.processEngineConfiguration);
                    asyncRunnable.run();
                }
            }
        }
    }

    private void removeExtraVariableFromThreadTruck() {
        ThreadTruck.remove((Object)"separateStorageKey");
        ThreadTruck.remove((Object)"businessObjectDataSource");
        ThreadTruck.remove((Object)"noLoginRequired");
    }
}

