/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.job.asyncexecutor.entity;

import java.util.List;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.ServiceInfo;
import kd.bos.workflow.engine.WfDBUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntityManagerImpl;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.task.cache.TaskModelCacheHelper;
import kd.bos.workflow.task.entity.TaskJobEntityManagerImpl;
import kd.bos.workflow.task.job.asyncexecutor.cmd.MoveTaskJobToDeadLetterJobCmd;
import kd.bos.workflow.task.job.asyncexecutor.entity.TaskJobRecordEntity;
import kd.bos.workflow.task.job.asyncexecutor.entity.TaskJobRecordEntityImpl;
import kd.bos.workflow.task.job.asyncexecutor.entity.TaskJobRecordEntityManager;
import kd.bos.workflow.util.WfCommonUtil;

public class TaskJobRecordEntityManagerImpl
extends JobEntityManagerImpl
implements TaskJobRecordEntityManager {
    private static Log log = LogFactory.getLog(TaskJobEntityManagerImpl.class);

    public TaskJobRecordEntityImpl create() {
        return new TaskJobRecordEntityImpl("wf_taskjobrecord");
    }

    public TaskJobRecordEntityImpl create(String dynObjTypeName) {
        return new TaskJobRecordEntityImpl(dynObjTypeName);
    }

    public TaskJobRecordEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    public Class<? extends TaskJobRecordEntity> getManagedEntityClass() {
        return TaskJobRecordEntityImpl.class;
    }

    public String getSelectFields() {
        return "id,jobtype,lockexpirationtime,exclusive,lockownerid,executionid,processinstanceid,processdefinitionid,retries,businesskey,operation,exceptionmessage,duedate,repeat,jobhandlertype,jobhandlerconfiguration,createdate,modifydate,elementid,srcjobid,roottraceno,executor,success,endtime,duration,state,source,rootjobid,biztraceno,orgunitid,orgviewid,billno,entityname,activityname,assigneename,channelnumber,channelname,entitynumber,taskid,interfacetype,traceid,retrycount,todostate,taskid";
    }

    public String getEntityName() {
        return "wf_taskjobrecord";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveDeadLetterJob(JobEntity entity, WFEngineException e) {
        String markId = String.format("wf/moveToTaskDeadJob/%s", entity.getId());
        boolean flag = false;
        try {
            if (TaskModelCacheHelper.putCurrentExecuteBySceneAndKey(markId) > 0) {
                flag = true;
                new MoveTaskJobToDeadLetterJobCmd((TaskJobRecordEntity)entity, (Throwable)e).execute(Context.getCommandContext());
            }
        }
        finally {
            if (flag) {
                TaskModelCacheHelper.removeCurrentExecuteBySceneAndKey(markId);
            }
        }
    }

    protected String getLockKey() {
        return "wf/taskJobExecute/%s";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateJob(List<Object[]> params) {
        String sql = "update t_wf_taskjobrecord set FLOCKEXPTIME = ?,FLOCKOWNERID = ?,FRETRIES=?,FSTATE = ? where fid = ? and fstate in ('created','received','executing')";
        try (TXHandle h = TX.requiresNew();){
            WfDBUtils.executeBatch((DBRoute)DBRoute.of((String)DBRoute.workflow.getRouteKey()), (String)sql, params, (Integer)100);
        }
    }

    protected boolean checkJobExecutorAlive(JobEntity entity, List<ServiceInfo> nodes) {
        boolean jobContinue = false;
        boolean alive = WfCommonUtil.isServiceNodeAlive(nodes, (String)entity.getExecutor());
        if (alive) {
            this.logger.info(String.format("taskjob[%s] \u6b63\u5728\u6267\u884c\u4e2d\uff0c\u6267\u884c\u673a\u72b6\u6001\u6b63\u5e38\uff0c\u66f4\u65b0\u7f13\u5b58\u3002", entity.getId()));
            TaskModelCacheHelper.putCurrentExecuteJobState(entity.getId(), entity.getBusinessKey());
        } else {
            jobContinue = true;
            this.logger.info(String.format("taskjob[%s] \u6b63\u5728\u6267\u884c\u4e2d\uff0c\u539f\u6267\u884c\u673a\u5df2\u5b95\u673a\uff0c\u5220\u9664\u7f13\u5b58\u3002", entity.getId()));
            TaskModelCacheHelper.removeCurrentExecuteJobState(entity.getId(), entity.getBusinessKey());
        }
        return jobContinue;
    }
}

