/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.job.asyncexecutor.notity;

import java.util.ArrayList;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.impl.cfg.TransactionPropagation;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandConfig;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.CommandContextCloseListener;
import kd.bos.workflow.engine.impl.interceptor.CommandExecutor;
import kd.bos.workflow.engine.impl.jobexecutor.IJobScheduleCallback;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntityManager;
import kd.bos.workflow.task.job.asyncexecutor.entity.TaskJobRecordEntity;
import kd.bos.workflow.task.job.asyncexecutor.entity.TaskJobRecordEntityManager;
import kd.bos.workflow.task.job.asyncexecutor.util.TaskJobUtil;

public class ScheduleTaskJobNotification
implements CommandContextCloseListener {
    private List<JobEntity> jobs = new ArrayList<JobEntity>();
    private IJobScheduleCallback closedCallback;
    private Log log = LogFactory.getLog(this.getClass());

    public ScheduleTaskJobNotification(JobEntity job, IJobScheduleCallback closeCallback) {
        this(job);
        this.closedCallback = closeCallback;
    }

    public ScheduleTaskJobNotification(JobEntity job) {
        this.jobs.add((TaskJobRecordEntity)job);
    }

    public ScheduleTaskJobNotification(List<JobEntity> jobs) {
        if (jobs != null && jobs.size() > 0) {
            for (JobEntity jobEntity : jobs) {
                this.jobs.add(jobEntity);
            }
        }
    }

    public void closed(CommandContext commandContext) {
        CommandExecutor commandExecutor = commandContext.getProcessEngineConfiguration().getCommandExecutor();
        CommandConfig commandConfig = new CommandConfig(false, TransactionPropagation.REQUIRES_NEW);
        commandExecutor.execute(commandConfig, (Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                TaskJobUtil.sendJobToMQ(ScheduleTaskJobNotification.this.jobs);
                return null;
            }
        });
    }

    public void closing(CommandContext commandContext) {
        if (this.closedCallback != null && !this.closedCallback.isValidate()) {
            JobEntityManager jobEntityManager = (JobEntityManager)commandContext.getEntityManager(TaskJobRecordEntityManager.class);
            for (JobEntity job : this.jobs) {
                jobEntityManager.delete((Entity)job);
            }
        }
    }

    public void afterSessionsFlush(CommandContext commandContext) {
        this.log.debug("afterSessionsFlush...");
    }

    public void closeFailure(CommandContext commandContext) {
        this.log.debug("closeFailure...");
    }
}

