/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.job.asyncexecutor.schedule;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.workflow.engine.ProcessEngines;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.asyncexecutor.JobManager;
import kd.bos.workflow.engine.impl.asyncexecutor.schedule.AcquireTimerJobsTask;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.job.TaskJobHelper;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.CommandExecutor;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.TimerJobEntity;
import kd.bos.workflow.task.job.asyncexecutor.cmd.AcquireTaskTimerJobsCmd;

public class AcquireTaskTimerJobsTask
extends AbstractTask {
    private static Log log = LogFactory.getLog(AcquireTimerJobsTask.class);

    public void execute(RequestContext context, Map<String, Object> param) throws KDException {
        long start = System.currentTimeMillis();
        log.info("{} starting to acquire async jobs due");
        if (!ProcessEngines.isInitialized()) {
            return;
        }
        try {
            char[] supports = new char[]{};
            String index = "";
            if (param != null) {
                String val = (String)param.get("mods");
                if (null != val) {
                    supports = val.toCharArray();
                }
                index = (String)param.get("index");
            }
            try (DLock lock = DLock.create((String)("wf/moveTaskTimerJobsToExecute" + index), (String)"move tasktimerJobs to executableJob").fastMode();){
                boolean canLock = lock.tryLock();
                if (canLock) {
                    ProcessEngineConfigurationImpl configuration = (ProcessEngineConfigurationImpl)ProcessEngines.getDefaultProcessEngine().getProcessEngineConfiguration();
                    CommandExecutor commandExecutor = configuration.getCommandExecutor();
                    final List acquiredJobs = (List)commandExecutor.execute((Command)new AcquireTaskTimerJobsCmd());
                    log.info(String.format("AcquireTaskTimerJobsTask acquiredJobs size is %s,%s,%s", acquiredJobs.size(), String.valueOf(supports), index));
                    if (acquiredJobs != null && !acquiredJobs.isEmpty()) {
                        commandExecutor.execute((Command)new Command<Void>(){

                            public Void execute(CommandContext commandContext) {
                                ArrayList<JobEntity> executeJobs = new ArrayList<JobEntity>(acquiredJobs.size());
                                JobManager jobManager = TaskJobHelper.getTaskJobManagerProvider();
                                for (TimerJobEntity job : acquiredJobs) {
                                    executeJobs.add(jobManager.moveTimerJobToExecutableJob(job));
                                }
                                jobManager.batchScheduleAsyncJob(executeJobs);
                                return null;
                            }
                        });
                    }
                }
            }
        }
        catch (Exception e) {
            log.info(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        long end = System.currentTimeMillis();
        log.info(String.format("AcquireTimerJobsTask end%s - start%s = %s", end, start, end - start));
    }
}

