/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.job.asyncexecutor.strategy;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.entity.DeleteEntityCmd;
import kd.bos.workflow.engine.impl.cmd.entity.GetSingleEntityCmd;
import kd.bos.workflow.engine.impl.cmd.entity.SaveEntityCmd;
import kd.bos.workflow.engine.impl.cmd.job.ILocalJobHandleStrategy;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.runtime.ExecuteJob;
import kd.bos.workflow.task.job.asyncexecutor.entity.TaskDeadLetterJobEntityManager;
import kd.bos.workflow.task.job.asyncexecutor.entity.TaskJobRecordEntity;
import kd.bos.workflow.task.job.asyncexecutor.entity.TaskJobRecordEntityManager;

public class LocalTaskJobHandleStrategy
implements ILocalJobHandleStrategy {
    protected Log logger = LogFactory.getLog(this.getClass());
    private ProcessEngineConfigurationImpl pf;

    public void insertJobToLocal(ExecuteJob job) {
        this.pf.getExecuteJobManager().saveOrUpdate(job);
    }

    public boolean isLocalJob(String dBRouteKey) {
        return DBRoute.workflow.getRouteKey().equals(dBRouteKey);
    }

    public boolean exsitDeadLetterJob(Long id) {
        return ((TaskDeadLetterJobEntityManager)this.pf.getEntityManager(TaskDeadLetterJobEntityManager.class)).exist(id);
    }

    public ExecuteJob extraMessageToJob(Map jsonObject) {
        return null;
    }

    public ExecuteJob findJob(Long id, boolean cache) {
        if (cache) {
            CommandContext ctx = Context.getCommandContext();
            if (ctx == null) {
                return (ExecuteJob)this.pf.getCommandExecutor().execute((Command)new GetSingleEntityCmd(id, "wf_taskjobrecord"));
            }
            return (ExecuteJob)new GetSingleEntityCmd(id, "wf_taskjobrecord").execute(ctx);
        }
        if (WfUtils.exist((String)"wf_taskjobrecord", (Object)id)) {
            try {
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"wf_taskjobrecord");
                return (ExecuteJob)((TaskJobRecordEntityManager)this.pf.getEntityManager(TaskJobRecordEntityManager.class)).create(obj);
            }
            catch (Exception e) {
                this.logger.info(e.getMessage());
            }
        }
        return null;
    }

    public void notifyJobFinished(ExecuteJob jobEntity) {
        TaskJobRecordEntity taskJobRecordEntity;
        if (jobEntity instanceof TaskJobRecordEntity && WfUtils.isNotEmpty((Long)(taskJobRecordEntity = (TaskJobRecordEntity)jobEntity).getTaskId()) && !QueryServiceHelper.exists((String)"wf_hitaskinst", (Object)taskJobRecordEntity.getTaskId())) {
            DeleteServiceHelper.delete((String)"wf_taskjobrecord", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)jobEntity.getId())});
        }
    }

    public void setProcessEngineConfiguration(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.pf = processEngineConfiguration;
    }

    public void setSource(String source) {
    }

    public List<? extends ExecuteJob> findExpiredJobs(String dbKey) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateJobState(ExecuteJob wfJob, boolean cache) {
        if (cache) {
            this.pf.getCommandExecutor().execute((Command)new SaveEntityCmd((Entity)wfJob));
        } else {
            TXHandle h = TX.beginNew();
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{wfJob.getDynamicObject()});
            }
            catch (Exception e) {
                h.markRollback();
                this.logger.info(WfUtils.getExceptionStacktrace((Throwable)e));
            }
            finally {
                h.end();
            }
        }
    }

    public void updateJobErrorMsg(Long jobId, String error) {
        try {
            TaskJobRecordEntity jobEntity = (TaskJobRecordEntity)this.pf.getCommandExecutor().execute((Command)new GetSingleEntityCmd(jobId, "wf_taskjobrecord"));
            if (jobEntity != null) {
                jobEntity.setExceptionMessage(error);
                this.updateJobState((ExecuteJob)jobEntity, false);
            }
        }
        catch (Exception e) {
            this.logger.info(WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    public void deleteJob(ExecuteJob wfJob) {
        this.pf.getCommandExecutor().execute((Command)new DeleteEntityCmd(wfJob.getId(), "wf_taskjobrecord"));
    }

    public List<ExecuteJob> findJobs(List<Long> ids, boolean cache) {
        return null;
    }

    public DynamicObjectCollection findChannelTasksByJobExecuteJob(JobEntity jobEntity) {
        try {
            TaskJobRecordEntity taskJobRecordEntity = (TaskJobRecordEntity)jobEntity;
            QFilter[] qFilters = new QFilter[]{new QFilter("taskid", "=", (Object)taskJobRecordEntity.getTaskId()), new QFilter("handletype", "=", (Object)taskJobRecordEntity.getJobHandlerType())};
            TaskJobRecordEntityManager taskJobRecordEntityManager = (TaskJobRecordEntityManager)this.pf.getEntityManager(TaskJobRecordEntityManager.class);
            return QueryServiceHelper.query((String)"wf_taskjobrecord", (String)taskJobRecordEntityManager.getSelectFields(), (QFilter[])qFilters);
        }
        catch (Exception e) {
            this.logger.info(e.getMessage());
            return null;
        }
    }
}

