/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.job.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bec.engine.asyncexecutor.DefaultEvtJobManager;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.workflow.bpmn.model.TimerEventDefinition;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEvent;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.impl.WfTracerHelper;
import kd.bos.workflow.engine.impl.asyncexecutor.AsyncExecutor;
import kd.bos.workflow.engine.impl.asyncexecutor.DefaultJobManager;
import kd.bos.workflow.engine.impl.asyncexecutor.RepeatJobModel;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.job.JobHandleStrategyFactory;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.CommandContextCloseListener;
import kd.bos.workflow.engine.impl.jobexecutor.IJobScheduleCallback;
import kd.bos.workflow.engine.impl.jobexecutor.JobHandler;
import kd.bos.workflow.engine.impl.jobexecutor.JobUtil;
import kd.bos.workflow.engine.impl.jobexecutor.ScheduleJobAddedNotification;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.job.AbstractJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.job.TimerJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.TimerJobEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntity;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.msg.info.ToDoInfo;
import kd.bos.workflow.engine.runtime.ExecuteJob;
import kd.bos.workflow.engine.runtime.Job;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFIllegalArgumentException;
import kd.bos.workflow.service.WfTraceType;
import kd.bos.workflow.task.entity.TaskJobEntity;
import kd.bos.workflow.task.job.TaskModelJobManager;
import kd.bos.workflow.task.job.asyncexecutor.entity.AbstractTaskJobEntity;
import kd.bos.workflow.task.job.asyncexecutor.entity.TaskDeadLetterJobEntity;
import kd.bos.workflow.task.job.asyncexecutor.entity.TaskDeadLetterJobEntityManager;
import kd.bos.workflow.task.job.asyncexecutor.entity.TaskJobRecordEntity;
import kd.bos.workflow.task.job.asyncexecutor.entity.TaskJobRecordEntityManager;
import kd.bos.workflow.task.job.asyncexecutor.entity.TaskTimerJobEntity;
import kd.bos.workflow.task.job.asyncexecutor.entity.TaskTimerJobEntityManager;
import kd.bos.workflow.task.job.asyncexecutor.notity.ScheduleTaskJobNotification;
import kd.bos.workflow.task.job.asyncexecutor.schedule.AcquireAsyncTaskJobsDueTask;
import kd.bos.workflow.task.job.asyncexecutor.schedule.AcquireTaskTimerJobsTask;
import kd.bos.workflow.task.job.asyncexecutor.util.TaskJobUtil;

public class DefaultTaskModelJobManager
extends DefaultJobManager
implements TaskModelJobManager {
    protected static Log logger = LogFactory.getLog(DefaultEvtJobManager.class);

    public DefaultTaskModelJobManager() {
    }

    @Deprecated
    public DefaultTaskModelJobManager(ProcessEngineConfigurationImpl processEngineConfiguration) {
    }

    public void executeDueTaskSchedule(RequestContext context, Map<String, Object> param) {
        AcquireAsyncTaskJobsDueTask acquireAsyncTaskJobsDueTask = new AcquireAsyncTaskJobsDueTask();
        acquireAsyncTaskJobsDueTask.execute(context, param);
    }

    public void executeTimerTaskSchedule(RequestContext context, Map<String, Object> param) {
        AcquireTaskTimerJobsTask acquireAsyncTaskJobsDueTask = new AcquireTaskTimerJobsTask();
        acquireAsyncTaskJobsDueTask.execute(context, param);
    }

    @Override
    public List<JobEntity> moveChannelLogToExecutableJob(List<TaskJobEntity> taskJobEntityList) {
        if (CollectionUtil.isEmpty(taskJobEntityList)) {
            throw new WFIllegalArgumentException("Null taskJobEntityList provided");
        }
        CommandContext commandContext = Context.getCommandContext();
        ArrayList<JobEntity> jobEntities = new ArrayList<JobEntity>(taskJobEntityList.size());
        ArrayList<Long> rootJobIds = new ArrayList<Long>(taskJobEntityList.size());
        for (TaskJobEntity taskJobEntity : taskJobEntityList) {
            Long rootJobId = taskJobEntity.getRootJobId();
            rootJobIds.add(rootJobId);
            String source = JobHandleStrategyFactory.getWFSource();
            JobEntity executableJob = (JobEntity)super.getJobEntityManager().create();
            this.copyJobInfo((AbstractJobEntity)executableJob, (AbstractJobEntity)taskJobEntity);
            executableJob.setSource(source);
            JobUtil.setJobLockProperty((ExecuteJob)executableJob, (ProcessEngineConfigurationImpl)this.processEngineConfiguration, (AsyncExecutor)this.getAsyncExecutor());
            executableJob.setJobHandlerConfiguration(this.packageRequestContextUserInfo(executableJob.getJobHandlerConfiguration()));
            executableJob.setRootJobId(rootJobId);
            executableJob.setRetries(3);
            jobEntities.add(executableJob);
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", rootJobIds)};
        commandContext.getJobEntityManager().deleteByFilters(new QFilter[]{new QFilter("rootJobId", "in", rootJobIds)});
        commandContext.getTimerJobEntityManager().deleteByFilters(qFilters);
        commandContext.getDeadLetterJobEntityManager().deleteByFilters(qFilters);
        commandContext.getSuspendedJobEntityManager().deleteByFilters(qFilters);
        commandContext.getFailedJobEntityManager().deleteByFilters(qFilters);
        ArrayList<JobEntity> batchScheduleJobEntities = new ArrayList<JobEntity>(jobEntities.size());
        for (JobEntity jobEntity : jobEntities) {
            if (!commandContext.getJobEntityManager().insertJobEntity(jobEntity)) continue;
            batchScheduleJobEntities.add(jobEntity);
        }
        if (WfUtils.isNotEmptyForCollection(batchScheduleJobEntities)) {
            try (TraceSpan tracer = Tracer.create((String)"WF_JOB", (String)WfTracerHelper.wrapTagValue((String)"prepareSendJobsToMQ", (String[])new String[0]));){
                logger.info("addCloseListener to sendMQ when flush DB...");
                ScheduleJobAddedNotification jobAddedNotification = new ScheduleJobAddedNotification(batchScheduleJobEntities);
                this.getCommandContext().addCloseListener((CommandContextCloseListener)jobAddedNotification);
            }
            logger.info("moveChannelLogToExecutableJob is success");
        }
        return batchScheduleJobEntities;
    }

    private String packageRequestContextUserInfo(String configuration) {
        Map payload = (Map)SerializationUtils.fromJsonString((String)configuration, Map.class);
        if (WfUtils.isNotEmptyForMap((Map)payload)) {
            Object obj = payload.get("_requestContext_");
            if (payload.get("_requestContext_") != null) {
                Map requestContext = (Map)obj;
                requestContext.put("userId", RequestContext.get().getUserId());
                requestContext.put("userName", RequestContext.get().getUserName());
            }
            payload.put("retryType", "byHand");
            configuration = SerializationUtils.toJsonString((Object)payload);
        }
        return configuration;
    }

    public void execute(Job job) {
        if (job instanceof TaskJobRecordEntity) {
            if ("taskMessage".equals(job.getJobType())) {
                this.executeTaskJobHandler((TaskJobRecordEntity)job);
            } else if ("taskTimer".equals(job.getJobType())) {
                this.executeTaskTimerJob((TaskJobRecordEntity)job);
            }
        } else {
            throw new WFEngineException("Only jobs with type JobEntity are supported to be executed");
        }
    }

    protected void executeTaskJobHandler(TaskJobRecordEntity jobEntity) {
        Map jobHandlers = this.getCommandContext().getProcessEngineConfiguration().getJobHandlers();
        JobHandler jobHandler = (JobHandler)jobHandlers.get(jobEntity.getJobHandlerType());
        if (jobHandler == null) {
            logger.debug(String.format("handle type is %s executeJobHandler is null", jobEntity.getJobHandlerType()));
            return;
        }
        logger.debug("executeTaskJobHandler in " + jobHandler.getClass().getName() + ",with configuration[" + jobEntity.getJobHandlerConfiguration() + "]");
        jobHandler.execute((JobEntity)jobEntity, jobEntity.getJobHandlerConfiguration(), null, this.getCommandContext());
    }

    protected void executeTaskTimerJob(TaskJobRecordEntity timerEntity) {
        TaskJobRecordEntityManager taskJobEntityManager = (TaskJobRecordEntityManager)this.getCommandContext().getEntityManagerByEntityNumber("wf_tasktimerjob");
        this.executeTaskJobHandler(timerEntity);
        taskJobEntityManager.delete((Entity)timerEntity);
        logger.debug("TaskTimerJob {" + timerEntity.getId() + "} fired. Deleting timer.");
    }

    public void scheduleAsyncJob(JobEntity job) {
        ((TaskJobRecordEntityManager)this.getCommandContext().getEntityManager(TaskJobRecordEntityManager.class)).insert((Entity)((TaskJobRecordEntity)job));
        try (TraceSpan tracer = Tracer.create((String)"WF_JOB", (String)WfTracerHelper.wrapTagValue((String)"saveToLocalJob", (String[])new String[]{String.valueOf(job.getId())}));){
            if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled() && WfTraceType.get() != null && WfTraceType.get().getJobInfo() != null) {
                Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createAsyncMessageEvent((ActivitiEventType)ActivitiEventType.JOB_CREATE, (String)job.getJobHandlerType(), (Object)job.getJobHandlerConfiguration(), (AbstractJobEntity)job));
            }
            this.hintAsyncExecutor(job);
        }
    }

    protected void hintAsyncExecutor(JobEntity job) {
        try (TraceSpan tracer = Tracer.create((String)"WF_JOB", (String)WfTracerHelper.wrapTagValue((String)"prepareMessageToSend", (String[])new String[]{String.valueOf(job.getId())}));){
            logger.info("addCloseListener to sendMQ when flush DB.");
            CommandContext commandContext = Context.getCommandContext();
            if (commandContext != null && commandContext.getAttribute("isClose") == null) {
                ScheduleTaskJobNotification jobAddedNotification = new ScheduleTaskJobNotification(job);
                this.getCommandContext().addCloseListener((CommandContextCloseListener)jobAddedNotification);
            } else {
                TaskJobUtil.sendJobToMQ(job);
            }
        }
    }

    public void batchScheduleAsyncJob(List<JobEntity> jobs) {
        try (TraceSpan tracer = Tracer.create((String)"WF_JOB", (String)WfTracerHelper.wrapTagValue((String)"prepareSendJobsToMQ", (String[])new String[0]));){
            logger.info("Taskjob addCloseListener to sendMQ when flush DB...");
            ScheduleTaskJobNotification jobAddedNotification = new ScheduleTaskJobNotification(jobs);
            this.getCommandContext().addCloseListener((CommandContextCloseListener)jobAddedNotification);
        }
    }

    public TimerJobEntity createTimerJob(TimerEventDefinition timerEventDefinition, boolean interrupting, ExecutionEntity execution, String timerEventType, String jobHandlerConfiguration) {
        return null;
    }

    public void scheduleTimerJob(TimerJobEntity timerJob) {
        logger.debug("not execute");
    }

    public void scheduleAsyncJob(JobEntity jobEntity, IJobScheduleCallback callBack) {
        ((TaskJobRecordEntityManager)this.getCommandContext().getEntityManager(TaskJobRecordEntityManager.class)).insert((Entity)((TaskJobRecordEntity)jobEntity));
        try (TraceSpan tracer = Tracer.create((String)"WF_JOB", (String)WfTracerHelper.wrapTagValue((String)"saveToLocalJob", (String[])new String[]{String.valueOf(jobEntity.getId())}));){
            if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled() && WfTraceType.get() != null && WfTraceType.get().getJobInfo() != null) {
                Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createAsyncMessageEvent((ActivitiEventType)ActivitiEventType.JOB_CREATE, (String)jobEntity.getJobHandlerType(), (Object)jobEntity.getJobHandlerConfiguration(), (AbstractJobEntity)jobEntity));
            }
            ScheduleTaskJobNotification jobAddedNotification = new ScheduleTaskJobNotification(jobEntity, callBack);
            this.getCommandContext().addCloseListener((CommandContextCloseListener)jobAddedNotification);
        }
    }

    protected JobEntityManager getJobEntityManager() {
        return (JobEntityManager)this.getCommandContext().getEntityManager(TaskJobRecordEntityManager.class);
    }

    protected TimerJobEntityManager getTimerJobEntityManager() {
        return (TimerJobEntityManager)this.getCommandContext().getEntityManager(TaskTimerJobEntityManager.class);
    }

    protected String getLockKey() {
        return "wf/taskJobExecute/%s";
    }

    protected DeadLetterJobEntityManager getDeadLetterJobEntityManager() {
        return (DeadLetterJobEntityManager)this.getCommandContext().getEntityManager(TaskDeadLetterJobEntityManager.class);
    }

    protected String getExecuteJobLockKey() {
        return "wf/movtoTaskjob/%s";
    }

    protected TaskTimerJobEntity createTimerJobFromOtherJob(AbstractJobEntity otherJob) {
        TaskTimerJobEntity timerJob = (TaskTimerJobEntity)super.createTimerJobFromOtherJob(otherJob);
        if (otherJob instanceof AbstractTaskJobEntity) {
            timerJob.setTaskId(((AbstractTaskJobEntity)otherJob).getTaskId());
        }
        return timerJob;
    }

    protected TaskDeadLetterJobEntity createDeadLetterJobFromOtherJob(AbstractJobEntity otherJob, Throwable exception) {
        TaskDeadLetterJobEntity deadLetterJob = (TaskDeadLetterJobEntity)super.createDeadLetterJobFromOtherJob(otherJob, exception);
        if (otherJob instanceof AbstractTaskJobEntity) {
            deadLetterJob.setTaskId(((AbstractTaskJobEntity)otherJob).getTaskId());
        }
        return deadLetterJob;
    }

    protected TaskJobRecordEntity createExecutableJobFromOtherJob(AbstractJobEntity job) {
        TaskJobRecordEntity taskJobRecordEntity = (TaskJobRecordEntity)super.createExecutableJobFromOtherJob(job);
        if (job instanceof AbstractTaskJobEntity) {
            taskJobRecordEntity.setTaskId(((AbstractTaskJobEntity)job).getTaskId());
        }
        return taskJobRecordEntity;
    }

    @Override
    public JobEntity createCompensationBizTaskJob(TaskEntity task, Map<String, Object> variables) {
        TaskJobRecordEntity jobEntity = (TaskJobRecordEntity)super.internalCreateLockedAsyncJob(task, true, "async-compensationBizTaskJob");
        jobEntity.setJobType("taskMessage");
        jobEntity.setTaskId(task.getId());
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        if (variables != null) {
            tmp.put("varaibles", variables);
        }
        RepeatJobModel repeatJobModel = new RepeatJobModel(String.format("compensationBizTask-%s", task.getId()), RepeatJobModel.JobLockedStrategy.DISCARD, "CompensationTask");
        tmp.put("_lockKey_", repeatJobModel);
        tmp.put("taskId", task.getId());
        tmp.put("_billno_", task.getBillNo());
        tmp.put("source", task.getSource());
        super.fillPayload((JobEntity)jobEntity, tmp);
        return jobEntity;
    }

    public JobEntity createTaskRuleAnalysisJobHandler(TaskEntity entity) {
        TaskJobRecordEntity jobEntity = (TaskJobRecordEntity)super.createTaskRuleAnalysisJobHandler(entity);
        jobEntity.setTaskId(entity.getId());
        jobEntity.setJobType("taskMessage");
        return jobEntity;
    }

    public JobEntity createToDoJob(MessageContext ctx, ToDoInfo todo, String serviceKey) {
        TaskJobRecordEntity jobEntity = (TaskJobRecordEntity)super.createToDoJob(ctx, todo, serviceKey);
        jobEntity.setTaskId(todo.getTaskId());
        jobEntity.setJobType("taskMessage");
        return jobEntity;
    }

    public JobEntity createTaskTransferHandler(TaskHandleLogEntity entity) {
        TaskJobRecordEntity jobEntity = (TaskJobRecordEntity)super.createTaskTransferHandler(entity);
        jobEntity.setTaskId(entity.getTaskId());
        jobEntity.setJobType("taskMessage");
        return jobEntity;
    }

    public JobEntity createMessageJob(MessageContext ctx, MessageInfo msg, String serviceKey) {
        TaskJobRecordEntity jobEntity = (TaskJobRecordEntity)super.createMessageJob(ctx, msg, serviceKey);
        jobEntity.setJobType("taskMessage");
        return jobEntity;
    }

    public JobEntity createMessageJob(MessageContext ctx, MessageInfo msg) {
        return this.createMessageJob(ctx, msg, "");
    }

    public TimerJobEntity createTimeJobForCheckToDoJob(MessageContext ctx, ToDoInfo model, String serviceKey) {
        TaskTimerJobEntity timerJobEntity = (TaskTimerJobEntity)super.createTimeJobForCheckToDoJob(ctx, model, serviceKey);
        timerJobEntity.setTaskId(model.getTaskId());
        timerJobEntity.setJobType("taskMessage");
        return timerJobEntity;
    }

    @Override
    public List<JobEntity> moveChannelLogToTaskExecutableJob(List<TaskJobEntity> taskJobRecordEntities) {
        if (CollectionUtil.isEmpty(taskJobRecordEntities)) {
            throw new WFIllegalArgumentException("Null taskJobRecordEntities provided");
        }
        CommandContext commandContext = Context.getCommandContext();
        ArrayList<TaskJobRecordEntity> jobEntities = new ArrayList<TaskJobRecordEntity>(taskJobRecordEntities.size());
        ArrayList<Long> rootJobIds = new ArrayList<Long>(taskJobRecordEntities.size());
        for (TaskJobEntity taskJobEntity : taskJobRecordEntities) {
            Long rootJobId = taskJobEntity.getRootJobId();
            rootJobIds.add(rootJobId);
            TaskJobRecordEntity executableJob = this.createExecutableJobFromOtherJob((AbstractJobEntity)taskJobEntity);
            executableJob.setTaskId(taskJobEntity.getTaskId());
            executableJob.setJobHandlerConfiguration(this.packageRequestContextUserInfo(executableJob.getJobHandlerConfiguration()));
            executableJob.setRootJobId(rootJobId);
            executableJob.setRetries(3);
            jobEntities.add(executableJob);
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", rootJobIds)};
        ((TaskJobRecordEntityManager)commandContext.getEntityManager(TaskJobRecordEntityManager.class)).deleteByFilters(new QFilter[]{new QFilter("rootJobId", "in", rootJobIds)});
        ((TaskTimerJobEntityManager)commandContext.getEntityManager(TaskTimerJobEntityManager.class)).deleteByFilters(qFilters);
        ((TaskDeadLetterJobEntityManager)commandContext.getEntityManager(TaskDeadLetterJobEntityManager.class)).deleteByFilters(qFilters);
        ArrayList<JobEntity> batchScheduleJobEntities = new ArrayList<JobEntity>(jobEntities.size());
        for (TaskJobRecordEntity jobEntity : jobEntities) {
            if (!((TaskJobRecordEntityManager)commandContext.getEntityManager(TaskJobRecordEntityManager.class)).insertJobEntity(jobEntity)) continue;
            batchScheduleJobEntities.add(jobEntity);
        }
        if (WfUtils.isNotEmptyForCollection(batchScheduleJobEntities)) {
            this.batchScheduleAsyncJob(batchScheduleJobEntities);
            logger.info("moveChannelLogToExecutableJob is success");
        }
        return batchScheduleJobEntities;
    }
}

