/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.listeners;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.thread.ThreadTruck;
import kd.bos.workflow.bpmn.converter.util.ModelConfigUtil;
import kd.bos.workflow.bpmn.model.ActivitiListener;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.BaseTaskListener;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.delegate.invocation.DelegateInvocation;
import kd.bos.workflow.engine.impl.interceptor.CommandContextCloseListener;
import kd.bos.workflow.engine.impl.interceptor.DelegateInterceptor;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.exception.ExceptionUtil;
import kd.bos.workflow.exception.WFBizException;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.service.WfTraceType;
import kd.bos.workflow.task.enumeration.ListenerInvocationType;
import kd.bos.workflow.task.enumeration.TaskOperation;
import kd.bos.workflow.task.invocation.BizTaskListenerInvocation;
import kd.bos.workflow.task.listeners.BizTaskListener;
import kd.bos.workflow.task.listeners.ExecuteBizTaskAfterHandleListener;
import kd.bos.workflow.task.listeners.Factory.DefaultBizTaskListenerFactory;
import kd.bos.workflow.task.model.BizTask;
import kd.bos.workflow.task.service.ServiceFactory;
import kd.bos.workflow.task.service.TaskModelService;

public class BizTaskListenerExecuteHelper {
    private static final Log logger = LogFactory.getLog(BizTaskListenerExecuteHelper.class);

    public static BizTaskListenerExecuteHelper create() {
        return ServiceFactory.getService(BizTaskListenerExecuteHelper.class);
    }

    public void executeBeforeHandleBizTaskListener(TaskEntity taskEntity, String eventName, Map<String, Object> params) {
        this.executeBizTaskListeners(taskEntity, eventName, ListenerInvocationType.BEFOREHANDLE, params);
    }

    public void executeHandleBizTaskListener(TaskEntity taskEntity, String eventName, Map<String, Object> params) {
        this.executeBizTaskListeners(taskEntity, eventName, ListenerInvocationType.HANDLE, params);
    }

    public void executeAfterHandleBizTaskListener(TaskEntity taskEntity, String eventName, Map<String, Object> params) {
        String aim = "afterHandle_" + eventName;
        Context.getCommandContext().addCloseListener((CommandContextCloseListener)new ExecuteBizTaskAfterHandleListener(aim, taskEntity, eventName, ListenerInvocationType.AFTERHANDLE, params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeBizTaskListeners(TaskEntity taskEntity, String eventName, ListenerInvocationType invocationType, Map<String, Object> params) {
        List<ActivitiListener> listeners;
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        if ((listeners = this.getTargetBizTaskListeners(taskEntity, eventName, invocationType, params)).isEmpty()) {
            return;
        }
        Object taskModel = ThreadTruck.get((Object)"separateStorageKey");
        if (taskModel != null && "taskModle".equalsIgnoreCase((String)taskModel)) {
            ThreadTruck.remove((Object)"separateStorageKey");
        }
        try {
            for (ActivitiListener activitiListener : listeners) {
                String operation = activitiListener.getOperation();
                BaseTaskListener bizTaskListener = this.createBizTaskListener(activitiListener);
                taskEntity.setEventName(eventName + "@" + operation);
                taskEntity.setCurrentActivitiListener(activitiListener);
                try {
                    DelegateInterceptor delegateInterceptor = Context.getProcessEngineConfiguration().getDelegateInterceptor();
                    delegateInterceptor.handleInvocation((DelegateInvocation)new BizTaskListenerInvocation((BizTaskListener)bizTaskListener, eventName, taskEntity, invocationType, params));
                }
                catch (Exception e) {
                    KDBizException kdBizExeception;
                    if (WfTraceType.getOrCreate() == null || WfTraceType.getOrCreate().getJobInfo() == null) {
                        throw new WFEngineException("Exception while invoking TaskListener: " + e.getMessage(), (Throwable)e);
                    }
                    if (e instanceof WFBizException && ((WFBizException)e).getCause() != null && ((WFBizException)e).getCause() instanceof KDBizException) {
                        kdBizExeception = (KDBizException)((WFBizException)e).getCause();
                        if (!ExceptionUtil.matchBoundryException((KDBizException)kdBizExeception, (ExecutionEntity)taskEntity.getExecution())) {
                            throw e;
                        }
                        taskEntity.setExecutionType("enterBoundary");
                        continue;
                    }
                    if (e instanceof KDBizException) {
                        kdBizExeception = (KDBizException)e;
                        if (!ExceptionUtil.matchBoundryException((KDBizException)kdBizExeception, (ExecutionEntity)taskEntity.getExecution())) {
                            throw e;
                        }
                        taskEntity.setExecutionType("enterBoundary");
                        continue;
                    }
                    if (e instanceof WFBizException) {
                        throw e;
                    }
                    throw new WFEngineException("Exception while invoking BizTaskListener: " + e.getMessage(), (Throwable)e);
                }
                finally {
                    taskEntity.setEventName(null);
                    taskEntity.setCurrentActivitiListener(null);
                }
            }
        }
        finally {
            if (taskModel != null && "taskModle".equalsIgnoreCase((String)taskModel)) {
                ThreadTruck.put((Object)"separateStorageKey", (Object)"taskModle");
            }
        }
    }

    private List<ActivitiListener> getTargetBizTaskListeners(TaskEntity taskEntity, String eventName, ListenerInvocationType invocationType, Map<String, Object> params) {
        logger.info(String.format("task[%s] is null when invoke event [%s]", taskEntity.getId(), eventName));
        String taskModelNumber = taskEntity.getTaskDefinitionKey();
        TaskModelService taskModelService = TaskModelService.create();
        BizTask bizTask = taskModelService.getTaskModelDefinition(taskModelNumber);
        ArrayList listeners = new ArrayList();
        List<ActivitiListener> defaultListeners = this.getTaskDefaultListeners();
        ModelConfigUtil.addUniqueListeners(listeners, defaultListeners);
        logger.info(String.format("listeners1:%s", WfUtils.listToString(listeners, (String)",")));
        List<ActivitiListener> taskListeners = this.getTaskModelListeners(bizTask);
        ModelConfigUtil.addUniqueListeners(listeners, taskListeners);
        logger.info(String.format("listeners2:%s", WfUtils.listToString(listeners, (String)",")));
        ArrayList<ActivitiListener> targetActivitiListeners = new ArrayList<ActivitiListener>(listeners.size());
        for (ActivitiListener activitiListener : listeners) {
            String event = activitiListener.getEvent();
            logger.info(String.format("--executeTaskListeners: event[%s], listenerType[%s], eventOperation[%s], decisionScene[%s], imple[%s], taskId[%s]", event, eventName, activitiListener.getOperation(), params.get("decisionScene"), activitiListener.getImplementation(), taskEntity.getId()));
            if (!event.equalsIgnoreCase(eventName) || !invocationType.name().equalsIgnoreCase(activitiListener.getInvocationType())) continue;
            if (TaskOperation.COMPLETE.getValue().equals(eventName)) {
                String operation = activitiListener.getOperation();
                Object auditNumber = params.get("auditNumber");
                if (!"all".equals(operation) && (auditNumber == null || !auditNumber.equals(operation))) continue;
            }
            targetActivitiListeners.add(activitiListener);
        }
        return targetActivitiListeners;
    }

    private List<ActivitiListener> getTaskDefaultListeners() {
        ArrayList<ActivitiListener> listeners = new ArrayList<ActivitiListener>();
        ActivitiListener taskComplete = new ActivitiListener();
        taskComplete.setEvent(TaskOperation.COMPLETE.getValue());
        taskComplete.setImplementation("kd.bos.workflow.task.listeners.buidin.BizTaskCompleteListener");
        taskComplete.setImplementationType("class");
        taskComplete.setUserDefinied(Boolean.FALSE);
        taskComplete.setOperation("all");
        taskComplete.setInvocationType(ListenerInvocationType.HANDLE.name());
        listeners.add(taskComplete);
        ActivitiListener comingMsg = new ActivitiListener();
        comingMsg.setEvent(TaskOperation.CREATE.getValue());
        comingMsg.setImplementation("kd.bos.workflow.task.listeners.buidin.MessageNotifyListener");
        comingMsg.setImplementationType("class");
        comingMsg.setUserDefinied(Boolean.FALSE);
        comingMsg.setOperation("");
        comingMsg.setInvocationType(ListenerInvocationType.AFTERHANDLE.name());
        listeners.add(comingMsg);
        ActivitiListener leaveMsg = new ActivitiListener();
        leaveMsg.setEvent(TaskOperation.COMPLETE.getValue());
        leaveMsg.setImplementation("kd.bos.workflow.task.listeners.buidin.MessageNotifyListener");
        leaveMsg.setImplementationType("class");
        leaveMsg.setUserDefinied(Boolean.FALSE);
        leaveMsg.setOperation("all");
        leaveMsg.setInvocationType(ListenerInvocationType.AFTERHANDLE.name());
        listeners.add(leaveMsg);
        return listeners;
    }

    private BaseTaskListener createBizTaskListener(ActivitiListener activitiListener) {
        BizTaskListener bizTaskListener = null;
        DefaultBizTaskListenerFactory listenerFactory = new DefaultBizTaskListenerFactory();
        if (ExternalInterfaceUtil.isValidValue((String)activitiListener.getImplementation())) {
            bizTaskListener = listenerFactory.createExtItfBizTaskListener(activitiListener.getImplementationType(), activitiListener);
        } else if ("class".equalsIgnoreCase(activitiListener.getImplementationType())) {
            bizTaskListener = listenerFactory.createBizTaskListener(activitiListener);
        }
        return bizTaskListener;
    }

    private List<ActivitiListener> getTaskModelListeners(BizTask bizTask) {
        ArrayList<ActivitiListener> taskListeners = new ArrayList<ActivitiListener>();
        taskListeners.addAll(bizTask.getTaskListeners());
        return taskListeners;
    }
}

