/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.listeners.buidin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.api.AgentTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.task.listeners.BizTaskListener;

public class BizTaskCompleteListener
implements BizTaskListener {
    private Log logger = LogFactory.getLog(this.getClass());

    @Override
    public void handleTask(AgentTask agentTask, String eventName, Map<String, Object> params) {
        if (agentTask instanceof TaskEntity) {
            TaskEntity taskEntity = (TaskEntity)agentTask;
            this.deleteTaskToDo(taskEntity, params);
        }
    }

    private void deleteTaskToDo(TaskEntity taskEntity, Map<String, Object> params) {
        ArrayList<Long> ups = new ArrayList<Long>();
        List users = taskEntity.getIdentityLinks();
        if (users != null && users.size() > 0) {
            for (IdentityLinkEntity user : users) {
                if ("coordinate".equals(user.getType())) continue;
                Long assigneeId = taskEntity.getAssigneeId();
                if (WfUtils.isEmpty((Long)assigneeId)) {
                    assigneeId = (Long)params.get("auditUserId");
                }
                if (user.getUserId() == null || user.getUserId().equals(assigneeId) || !user.isDisplay().booleanValue()) continue;
                if (WfUtils.isEmpty((Long)user.getDelegateId())) {
                    if (user.getUserId() == null || !WfUtils.isNotEmpty((Long)user.getUserId()) || -1L == user.getUserId()) continue;
                    ups.add(user.getUserId());
                    continue;
                }
                if (taskEntity.getAssigneeId() == null) {
                    ups.add(user.getUserId());
                    continue;
                }
                if (taskEntity.getAssigneeId().equals(user.getOwnerId())) continue;
                ups.add(user.getUserId());
            }
        }
        if (ups.size() > 0) {
            this.logger.info(String.format("TaskCompleteListener_\u4efb\u52a1[%s]\u88ab[%s]\uff0c\u5220\u9664[%s]\u7684\u5f85\u529e", taskEntity.getId(), taskEntity.getAssigneeId(), ups));
            Context.getCommandContext().getProcessEngineConfiguration().getMessageService().deleteToDo(taskEntity.getId(), ups, false);
        }
    }
}

