/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.listeners.buidin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.api.AgentTask;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.MessageSendModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;
import kd.bos.workflow.task.cache.TaskModelCacheEntry;
import kd.bos.workflow.task.cache.TaskModelCacheHelper;
import kd.bos.workflow.task.enumeration.TaskOperation;
import kd.bos.workflow.task.listeners.BizTaskListener;
import kd.bos.workflow.task.model.BizTask;

public class MessageNotifyListener
implements BizTaskListener {
    private static Log logger = LogFactory.getLog(MessageNotifyListener.class);

    @Override
    public void afterHandleTask(AgentTask agentTask, String eventName, Map<String, Object> params) {
        if (agentTask instanceof TaskEntity) {
            TaskEntity taskEntity = (TaskEntity)agentTask;
            this.sendMessage(taskEntity, eventName, params);
        }
    }

    private void sendMessage(TaskEntity taskEntity, String eventName, Map<String, Object> params) {
        String taskModelNumber = taskEntity.getTaskDefinitionKey();
        TaskModelCacheEntry taskModelCacheEntry = TaskModelCacheHelper.getTaskModelDefinitionCacheEntry(taskModelNumber);
        BizTask bizTask = taskModelCacheEntry.getBizTask();
        List<MessageSendModel> messageSendModels = null;
        messageSendModels = TaskOperation.CREATE.getValue().equals(eventName) ? bizTask.getInMsg() : bizTask.getOutMsg();
        if (CollectionUtil.isEmpty(messageSendModels)) {
            return;
        }
        ArrayList<MessageSendModel> targetSendModel = new ArrayList<MessageSendModel>();
        for (MessageSendModel messageSendModel : messageSendModels) {
            List receivers = messageSendModel.getReceiver();
            if (!messageSendModel.isNotify() || !WfUtils.isNotEmptyForCollection((Collection)receivers)) continue;
            targetSendModel.add(messageSendModel);
        }
        if (CollectionUtil.isNotEmpty(targetSendModel)) {
            logger.info(String.format("\u8fdb\u5165\u8282\u70b9\u53d1\u9001\u6d88\u606f,\u8282\u70b9\u540d\u79f0[%s]", taskModelNumber));
            Context.getCommandContext().getMessageService().sendMessageForNode(taskEntity, taskModelNumber, targetSendModel, eventName);
        }
    }

    protected boolean canSend(String eventName, MessageSendModel sendModel) {
        boolean send = eventName == null && this.getType().equals(sendModel.getSendevt()) || eventName != null && eventName.equals(sendModel.getSendevt());
        return send;
    }

    protected boolean canSend(MessageSendModel sendModel) {
        return "notify".equals(sendModel.getMessagetype());
    }

    protected boolean isFulfillRule(DelegateExecution execution, MessageSendModel sendModel, FlowElement flowElement) {
        ConditionalRuleEntity messageSendRule = sendModel.getRule();
        boolean isFulfillRule = false;
        if (messageSendRule != null) {
            String key = ConditionUtil.getConInstKey((String)flowElement.getNumber(), (String)"msg");
            isFulfillRule = ConditionUtil.hasTrueCondition((ConditionalRuleEntity)messageSendRule, (VariableScope)execution, (String)key);
        } else {
            isFulfillRule = true;
        }
        return isFulfillRule;
    }

    protected String getType() {
        return "start";
    }
}

