/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.mobile.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.task.mobile.api.IWFService;
import kd.bos.workflow.task.mobile.enterprise.EntInfoLoader;
import kd.bos.workflow.task.mobile.enterprise.VirtualEntInfo;
import kd.bos.workflow.task.mobile.session.ContextSession;

public class WFServiceFactory {
    private static Log logger = LogFactory.getLog(WFServiceFactory.class);
    private static Map<String, IWFService> cache = new HashMap<String, IWFService>();

    private static void registerApi() {
        ArrayList<VirtualEntInfo> entList = EntInfoLoader.getInstance().getVirtualEntList();
        for (int i = 0; i < entList.size(); ++i) {
            VirtualEntInfo vinfo = (VirtualEntInfo)entList.get(i);
            String serviceImplClass = vinfo.getServiceImplClass();
            try {
                IWFService svc = (IWFService)Class.forName(serviceImplClass).newInstance();
                if (cache.containsKey(vinfo.getVersion())) continue;
                cache.put(vinfo.getVersion(), svc);
                continue;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static IWFService getService(String veid) {
        VirtualEntInfo info = EntInfoLoader.getInstance().getVirtualEntInfo(veid);
        IWFService svc = cache.get(info.getVersion());
        if (svc == null) {
            WFServiceFactory.registerApi();
        }
        return cache.get(info.getVersion());
    }

    public static IWFService getService() {
        String veid = ContextSession.getCurrentVid();
        VirtualEntInfo info = EntInfoLoader.getInstance().getVirtualEntInfo(veid);
        return cache.get(info.getVersion());
    }

    static {
        WFServiceFactory.registerApi();
    }
}

