/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.mobile.api.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfPermUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.params.ProcessDataEntityQueryParams;
import kd.bos.workflow.engine.impl.cmd.task.processassistant.ProcessAssistantUtil;
import kd.bos.workflow.engine.task.BatchOperateResult;
import kd.bos.workflow.engine.task.operation.CompleteOperationParam;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.task.mobile.api.IWFService;
import kd.bos.workflow.task.mobile.api.model.ApproveResult;
import kd.bos.workflow.task.mobile.api.model.FilterObject;
import kd.bos.workflow.task.mobile.api.model.GetCountParam;
import kd.bos.workflow.task.mobile.api.model.GetListParam;
import kd.bos.workflow.task.mobile.api.model.ListItemObject;
import kd.bos.workflow.task.mobile.api.model.MyListItemObject;
import kd.bos.workflow.task.mobile.api.model.WfCountObject;
import kd.bos.workflow.task.mobile.api.model.WfListObject;
import kd.bos.workflow.task.mobile.api.model.WfMyListObject;
import kd.bos.workflow.task.service.TaskRuntimeService;
import kd.bos.workflow.task.utils.TaskModelUtils;

public class WFIErpApiImpl
implements IWFService {
    private Log logger = LogFactory.getLog(WFIErpApiImpl.class);
    public static final String BILL_FILTER_ID = "bill";
    public static final String GETFILTER_MAP_KEY = "pageKey";

    protected TaskService getTaskService() {
        return ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getTaskService();
    }

    @Override
    public WfCountObject getCount(GetCountParam getListParam) {
        WfCountObject countObj = new WfCountObject();
        if (!WfConfigurationUtil.canRunWorkflow()) {
            return countObj;
        }
        Map countMap = this.getTaskService().getTaskCountForProcessAssistant(RequestContext.get().getUserId());
        countObj.setTodoCount((Integer)countMap.get("todoCount"));
        countObj.setDoneCount((Integer)countMap.get("doneCount"));
        countObj.setMyTodoCount((Integer)countMap.get("myTodoCount"));
        countObj.setMyDoneCount((Integer)countMap.get("myDoneCount"));
        return countObj;
    }

    @Override
    public ApproveResult quickApprove(Map map) {
        ApproveResult approveResult = new ApproveResult();
        try {
            String taskIdStr = (String)map.get("assignIds");
            Map immapping = (Map)map.get("immapping");
            String[] taskIdArray = taskIdStr.split(",");
            ArrayList<String> taskIds = new ArrayList<String>(Arrays.asList(taskIdArray));
            ArrayList<Long> bizTaskIds = new ArrayList<Long>(taskIdArray.length);
            Iterator iterator = taskIds.iterator();
            while (iterator.hasNext()) {
                String taskId = (String)iterator.next();
                JSONObject taskInfo = (JSONObject)immapping.get(taskId);
                if (!Boolean.parseBoolean((String)taskInfo.get((Object)"isBizTask"))) continue;
                bizTaskIds.add(Long.valueOf(taskId));
                iterator.remove();
            }
            if (!taskIds.isEmpty()) {
                JSONObject result = this.approveTask(map, taskIds);
                approveResult.setSuccess(result.getBoolean("success"));
                approveResult.setFailCount(result.getIntValue("failedCount"));
                approveResult.setSuccessCount(result.getIntValue("successCount"));
                approveResult.setResult(result.getString("result"));
                approveResult.setMessage(result.getString("message"));
            }
            if (!bizTaskIds.isEmpty()) {
                BatchOperateResult batchResult = this.handleBizTask(bizTaskIds, immapping);
                approveResult.setSuccess(approveResult.isSuccess() && batchResult.isSuccess());
                approveResult.setSuccessCount(approveResult.getSuccessCount() + batchResult.getSucessCount());
                approveResult.setFailCount(approveResult.getFailCount() + batchResult.getFailedCount());
                approveResult.setResult(WfUtils.isNotEmpty((String)approveResult.getResult()) ? approveResult.getResult() + "\r\n" + batchResult.getValidateMsg() : batchResult.getValidateMsg());
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return approveResult;
    }

    private BatchOperateResult handleBizTask(List<Long> taskIds, Map<String, Object> immapping) {
        BatchOperateResult batchOperateResult = new BatchOperateResult();
        ArrayList<Long> outerBizTaskIds = new ArrayList<Long>();
        StringBuilder resultInfo = new StringBuilder();
        Iterator<Long> iterator = taskIds.iterator();
        while (iterator.hasNext()) {
            Long taskId = iterator.next();
            JSONObject taskInfo = (JSONObject)immapping.get(taskId + "");
            if (!TaskModelUtils.isOuterSystemTask((String)taskInfo.get((Object)"category"))) continue;
            resultInfo.append("[").append(taskInfo.get((Object)"name")).append("]");
            outerBizTaskIds.add(taskId);
            iterator.remove();
        }
        LocaleString opinion = ResManager.getLocaleString((String)"\u540c\u610f", (String)"WFIErpApiImpl_4", (String)"bos-wf-task");
        String decOptionNumber = "Agree";
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("terminal", "mobile");
        variables.put("batchOpType", decOptionNumber);
        variables.put("auditType", decOptionNumber);
        variables.put("auditMessage", (String)opinion);
        try {
            CompleteOperationParam completeOperationParam = new CompleteOperationParam();
            completeOperationParam.setTaskIds(taskIds);
            completeOperationParam.setOperaterId(Long.valueOf(RequestContext.get().getCurrUserId()));
            completeOperationParam.setAuditMessage(opinion.getLocaleValue());
            completeOperationParam.setDecOptionNumber(decOptionNumber);
            completeOperationParam.setVariables(variables);
            batchOperateResult = TaskRuntimeService.create().completeBizTask(completeOperationParam);
        }
        catch (Exception e) {
            batchOperateResult.setFailedCount(taskIds.size());
            batchOperateResult.setSucessCount(0);
            batchOperateResult.setValidateMsg(e.getMessage());
            this.logger.error("handleBizTask occur error:" + WfUtils.getExceptionStacktrace((Throwable)e));
        }
        if (!outerBizTaskIds.isEmpty()) {
            batchOperateResult.setFailedCount(batchOperateResult.getFailedCount() + outerBizTaskIds.size());
            resultInfo.append(ResManager.loadKDString((String)"\u5c5e\u4e8e\u5916\u90e8\u4efb\u52a1\uff0c\u4e0d\u80fd\u6279\u91cf\u5904\u7406\u3002", (String)"WFIErpApiImpl_3", (String)"bos-wf-task", (Object[])new Object[0])).append("\r\n");
        }
        List operateResults = batchOperateResult.getOperateResults();
        operateResults.stream().forEach(operateResult -> {
            if ("failed".equals(operateResult.getOperateStatus())) {
                String taskSign = WfUtils.isNotEmpty((String)operateResult.getBillno()) ? operateResult.getBillno() : operateResult.getTaskId() + " ";
                resultInfo.append(taskSign).append(ResManager.loadKDString((String)"\u539f\u56e0\uff1a", (String)"WFIErpApiImpl_5", (String)"bos-wf-task", (Object[])new Object[0])).append(operateResult.getOperateMsg()).append("\r\n");
            }
        });
        batchOperateResult.setValidateMsg(resultInfo.toString());
        return batchOperateResult;
    }

    private JSONObject approveTask(Map map, List<String> taskIds) {
        JSONObject result = new JSONObject();
        String assignType = (String)map.get("assigntype");
        List taskIdList = taskIds.stream().map(taskId -> Long.valueOf(taskId)).collect(Collectors.toList());
        if (!WfPermUtils.isTaskParticipant(taskIdList, (Long)RequestContext.get().getCurrUserId())) {
            result.put("success", (Object)false);
            result.put("failedCount", (Object)assignType.split(",").length);
            result.put("result", (Object)ResManager.loadKDString((String)"\u60a8\u4e0d\u662f\u6240\u9009\u4efb\u52a1\u5904\u7406\u4eba\u3002", (String)"WFIErpApiImpl_2", (String)"bos-wf-task", (Object[])new Object[0]));
            return result;
        }
        if (StringUtils.isNotBlank((CharSequence)assignType) && assignType.indexOf("coordinate") != -1) {
            result.put("success", (Object)false);
            result.put("failedCount", (Object)assignType.split(",").length);
            result.put("result", (Object)ResManager.loadKDString((String)"\u5f53\u524d\u5305\u542b\u534f\u529e\u4efb\u52a1\uff0c\u4e0d\u80fd\u6279\u91cf\u5ba1\u6279\u3002", (String)"WFIErpApiImpl_1", (String)"bos-wf-task", (Object[])new Object[0]));
            return result;
        }
        String taskIdsJoin = String.join((CharSequence)",", taskIds);
        String resultJson = this.getTaskService().updateBillAndCompleteForBatch(taskIdsJoin, null);
        return (JSONObject)JSON.parse((String)resultJson);
    }

    @Override
    public List<FilterObject> getFilter(Map map) {
        if (!WfConfigurationUtil.canRunWorkflow()) {
            return Collections.emptyList();
        }
        ArrayList<FilterObject> list = new ArrayList<FilterObject>();
        FilterObject filterObject = new FilterObject();
        filterObject.setFilterName(WFMultiLangConstants.getBillFilterNname());
        filterObject.setFilterId(BILL_FILTER_ID);
        String pageKey = (String)map.get(GETFILTER_MAP_KEY);
        if (WfUtils.isNotEmpty((String)pageKey)) {
            List entityMaps = this.getTaskService().processAssisantGetEntityNumbers(Long.valueOf(RequestContext.get().getUserId()), pageKey);
            ArrayList<Map<String, String>> filterValue = new ArrayList<Map<String, String>>(entityMaps.size());
            for (Map i : entityMaps) {
                HashMap<String, String> m = new HashMap<String, String>();
                m.put("value", this.getStringVal(i.get("entityName")));
                m.put("key", this.getStringVal(i.get("entityNumber")));
                filterValue.add(m);
            }
            filterObject.setFilterValue(filterValue);
            list.add(filterObject);
        }
        if ("todo".equals(pageKey)) {
            FilterObject priorityObj = new FilterObject();
            priorityObj.setFilterName(ResManager.loadKDString((String)"\u4f18\u5148\u7ea7", (String)"WorkflowListFilterPlugin_2", (String)"bos-wf-task", (Object[])new Object[0]));
            priorityObj.setFilterId("priority");
            ArrayList<Map<String, String>> priorityFilterValue = new ArrayList<Map<String, String>>(2);
            Map markValueMap = ProcessAssistantUtil.getMarkValueMap();
            if (markValueMap != null && !markValueMap.isEmpty()) {
                for (Map.Entry entry : markValueMap.entrySet()) {
                    DynamicObject dynObj = (DynamicObject)entry.getValue();
                    if (null == dynObj) continue;
                    HashMap<String, String> m = new HashMap<String, String>();
                    m.put("key", dynObj.getString("value"));
                    ILocaleString name = dynObj.getLocaleString("name");
                    m.put("value", WfUtils.isNotEmpty((ILocaleString)name) ? name.toString() : "");
                    priorityFilterValue.add(m);
                }
                priorityObj.setFilterValue(priorityFilterValue);
                list.add(priorityObj);
            }
        }
        return list;
    }

    public List<Map<String, Object>> getDatas(GetListParam getListParam, String type) {
        int pageSize = getListParam.getPageSize();
        int start = (getListParam.getPageNo() - 1) * pageSize + 1;
        String SearchTime = getListParam.getSearchTime();
        String searchValue = getListParam.getSearchValue();
        String searchBill = getListParam.getSearchBill();
        String beginDate = getListParam.getBeginDate();
        String endDate = getListParam.getEndDate();
        String priority = getListParam.getPriority();
        List<Map<String, Object>> taskList = new ArrayList<Map<String, Object>>();
        HashMap<String, String> sqlFilterMap = new HashMap<String, String>();
        if (!WfConfigurationUtil.isNotQueryByNewSql()) {
            sqlFilterMap.put("starterOrSubjectFilter", searchValue);
            sqlFilterMap.put("timeFilter", SearchTime);
            sqlFilterMap.put("entityFilter", searchBill);
            sqlFilterMap.put("beginDate", beginDate);
            sqlFilterMap.put("endDate", endDate);
        }
        switch (type) {
            case "list": {
                if (sqlFilterMap.size() > 0 && WfConfigurationUtil.isUpdateTaskToParticipantComplete().booleanValue()) {
                    sqlFilterMap.put("priorityFilter", priority);
                    ProcessDataEntityQueryParams processDataEntityQueryParams = new ProcessDataEntityQueryParams(Long.valueOf(Long.parseLong(getListParam.getUserId())), start - 1, pageSize, "toHandle", "").setEndType("mobile").setSqlFilterMap(sqlFilterMap);
                    taskList = this.getTaskService().getProcessAssistantData(processDataEntityQueryParams);
                    break;
                }
                taskList = this.getTaskService().getTaskForProcessAssistant(Long.valueOf(Long.parseLong(getListParam.getUserId())), Integer.valueOf(start), Integer.valueOf(pageSize), searchValue, SearchTime, searchBill, false, beginDate, endDate, priority);
                break;
            }
            case "overlist": {
                if (sqlFilterMap.size() > 0 && WfConfigurationUtil.isHiTaskSingleTableQuery().booleanValue() && WfConfigurationUtil.isUpdateHiTaskToHiCommentComplete().booleanValue()) {
                    ProcessDataEntityQueryParams processDataEntityQueryParams = new ProcessDataEntityQueryParams(Long.valueOf(Long.parseLong(getListParam.getUserId())), start - 1, pageSize, "handled", "").setEndType("mobile").setSqlFilterMap(sqlFilterMap);
                    taskList = this.getTaskService().getProcessAssistantData(processDataEntityQueryParams);
                    break;
                }
                taskList = this.getTaskService().getHandledTaskForProcessAssistant(Long.valueOf(Long.parseLong(getListParam.getUserId())), Integer.valueOf(start), Integer.valueOf(pageSize), searchValue, SearchTime, searchBill, beginDate, endDate);
                break;
            }
            case "mylist": {
                if (sqlFilterMap.size() > 0) {
                    ProcessDataEntityQueryParams processDataEntityQueryParams = new ProcessDataEntityQueryParams(Long.valueOf(Long.parseLong(getListParam.getUserId())), start - 1, pageSize, "toApply", "").setSqlFilterMap(sqlFilterMap);
                    taskList = this.getTaskService().getProcessAssistantData(processDataEntityQueryParams);
                    break;
                }
                taskList = this.getTaskService().getApplyTaskForProcessAssistant(Long.valueOf(Long.parseLong(getListParam.getUserId())), Integer.valueOf(start), Integer.valueOf(pageSize), searchValue, SearchTime, searchBill, beginDate, endDate);
                break;
            }
            case "myoverlist": {
                if (sqlFilterMap.size() > 0) {
                    ProcessDataEntityQueryParams processDataEntityQueryParams = new ProcessDataEntityQueryParams(Long.valueOf(Long.parseLong(getListParam.getUserId())), start - 1, pageSize, "applyed", "").setSqlFilterMap(sqlFilterMap);
                    taskList = this.getTaskService().getProcessAssistantData(processDataEntityQueryParams);
                    break;
                }
                taskList = this.getTaskService().getApplyedTaskForProcessAssistant(Long.valueOf(Long.parseLong(getListParam.getUserId())), Integer.valueOf(start), Integer.valueOf(pageSize), searchValue, SearchTime, searchBill, beginDate, endDate, null);
                break;
            }
        }
        return taskList;
    }

    @Override
    public WfListObject getList(GetListParam getListParam) {
        WfListObject wfListObject = new WfListObject();
        if (!WfConfigurationUtil.canRunWorkflow()) {
            return wfListObject;
        }
        List<Map<String, Object>> taskList = this.getDatas(getListParam, "list");
        this.logger.info(String.format("wf_engine mobileList getList() taskList=%s", taskList));
        taskList.forEach(m -> {
            ListItemObject item = new ListItemObject();
            item.setBillName(this.getStringVal(m.get("billName")));
            item.setDate(this.wrapDate(m.get("createDate")));
            item.setId(this.getStringVal(m.get("taskId")));
            item.setBillId(this.getStringVal(m.get("billId")));
            item.setSender(this.getStringVal(m.get("initiator")));
            item.setSenderId(this.getStringVal(m.get("initiatorId")));
            item.setPhoteUrl(this.getStringVal(m.get("userImgUrl")));
            item.setSubject(this.getStringVal(m.get("subject")));
            item.setText(this.getStringVal(m.get("text")));
            item.setSourceType(getListParam.getFlag());
            item.setFormId(this.getStringVal(m.get("formId")));
            item.setAssigntype(this.getStringVal(m.get("type")));
            Object o = m.get("openId");
            if (o != null) {
                item.setFxtid(o.toString());
            }
            item.setBillUrl("");
            item.setVeid(getListParam.getVeid());
            item.setProDefName(this.getStringVal(m.get("name")));
            item.setPriority(this.getStringVal(m.get("priority")));
            if (m.containsKey("isBizTask")) {
                item.setBizTask((Boolean)m.get("isBizTask"));
            }
            if (m.containsKey("category")) {
                item.setCategory(this.getStringVal(m.get("category")));
            }
            wfListObject.addIlist(item);
        });
        this.logger.info(String.format("wf_engine mobileList wfListObject=%s", wfListObject.getIlist()));
        return wfListObject;
    }

    @Override
    public WfListObject getOverList(GetListParam getListParam) {
        WfListObject wfListObject = new WfListObject();
        if (!WfConfigurationUtil.canRunWorkflow()) {
            return wfListObject;
        }
        List<Map<String, Object>> taskList = this.getDatas(getListParam, "overlist");
        taskList.forEach(m -> {
            ListItemObject item = new ListItemObject();
            item.setBillName(this.getStringVal(m.get("billName")));
            item.setDate(this.wrapDate(m.get("endTime")));
            item.setId(this.getStringVal(m.get("taskId")));
            item.setBillId(this.getStringVal(m.get("billId")));
            item.setSender(this.getStringVal(m.get("initiator")));
            item.setSenderId(this.getStringVal(m.get("initiatorId")));
            item.setPhoteUrl(this.getStringVal(m.get("userImgUrl")));
            item.setSubject(this.getStringVal(m.get("subject")));
            item.setText(this.getStringVal(m.get("text")));
            Object o = m.get("openId");
            if (o != null) {
                item.setFxtid(o.toString());
            }
            item.setFormId(this.getStringVal(m.get("formId")));
            item.setSourceType(getListParam.getFlag());
            item.setVeid(getListParam.getVeid());
            item.setProDefName(this.getStringVal(m.get("activityname")));
            if (m.containsKey("isBizTask")) {
                item.setBizTask((Boolean)m.get("isBizTask"));
            }
            if (m.containsKey("category")) {
                item.setCategory(this.getStringVal(m.get("category")));
            }
            wfListObject.addIlist(item);
        });
        return wfListObject;
    }

    @Override
    public WfMyListObject getMyList(GetListParam getListParam) {
        WfMyListObject wfMyListObject = new WfMyListObject();
        if (!WfConfigurationUtil.canRunWorkflow()) {
            return wfMyListObject;
        }
        List<Map<String, Object>> taskList = this.getDatas(getListParam, "mylist");
        taskList.forEach(m -> {
            MyListItemObject item = new MyListItemObject();
            item.setBillName(this.getStringVal(m.get("billName")));
            item.setDate(this.wrapDate(m.get("createDate")));
            item.setId(this.getStringVal(m.get("procinstid")));
            item.setBillId(this.getStringVal(m.get("businesskey")));
            item.setSender(this.getStringVal(m.get("initiator")));
            item.setSenderId(this.getStringVal(m.get("initiatorId")));
            item.setPhoteUrl(this.getStringVal(m.get("userImgUrl")));
            item.setSubject(this.getStringVal(m.get("subject")));
            item.setText(this.getStringVal(m.get("text")));
            item.setFormId(this.getStringVal(m.get("formId")));
            item.setSourceType(getListParam.getFlag());
            item.setVeid(getListParam.getVeid());
            wfMyListObject.addIlist(item);
        });
        return wfMyListObject;
    }

    @Override
    public WfMyListObject getMyOverList(GetListParam getListParam) {
        WfMyListObject wfMyListObject = new WfMyListObject();
        if (!WfConfigurationUtil.canRunWorkflow()) {
            return wfMyListObject;
        }
        List<Map<String, Object>> taskList = this.getDatas(getListParam, "myoverlist");
        taskList.forEach(m -> {
            MyListItemObject item = new MyListItemObject();
            item.setBillName(this.getStringVal(m.get("billName")));
            item.setDate(this.wrapDate(m.get("endTime")));
            item.setId(this.getStringVal(m.get("procinstid")));
            item.setBillId(this.getStringVal(m.get("businesskey")));
            item.setSender(this.getStringVal(m.get("initiator")));
            item.setSenderId(this.getStringVal(m.get("initiatorId")));
            item.setPhoteUrl(this.getStringVal(m.get("userImgUrl")));
            item.setSubject(this.getStringVal(m.get("subject")));
            item.setText(this.getStringVal(m.get("text")));
            item.setFormId(this.getStringVal(m.get("formId")));
            item.setSourceType(getListParam.getFlag());
            item.setVeid(getListParam.getVeid());
            wfMyListObject.addIlist(item);
        });
        return wfMyListObject;
    }

    @Override
    public String getApproveUrl() {
        return null;
    }

    @Override
    public String getApproveFormId() {
        return "wf_approvalpagemobile_bac";
    }

    public String getStringVal(Object o) {
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    public String getSysZoneDateStr(String dateStr, boolean isEndDate) {
        if (WfUtils.isEmpty((String)dateStr)) {
            return dateStr;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            sdf.parseObject(dateStr);
            dateStr = isEndDate ? dateStr + " 23:59:59" : dateStr + " 00:00:00";
            DateFormat userZoneDateFormat = KDDateFormatUtils.getUserZoneDateFormat();
            Date dateParse = userZoneDateFormat.parse(dateStr);
            return DateFormat.getDateTimeInstance().format(dateParse);
        }
        catch (Exception e) {
            this.logger.info("Date Parser Error!Reason:" + e.getMessage());
            return dateStr;
        }
    }

    public String wrapDate(Object date) {
        if (date != null) {
            try {
                Date createDate = WfUtils.getUserZoneDate((Date)((Date)date));
                String dateString = DateFormat.getDateTimeInstance().format(createDate);
                return dateString;
            }
            catch (Exception e) {
                this.logger.info("CreateDate Parser Error!Reason:" + e.getMessage());
                return "";
            }
        }
        return "";
    }
}

