/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.mobile.api.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.task.mobile.api.impl.WFIErpApiImpl;
import kd.bos.workflow.task.mobile.api.model.ApproveResult;
import kd.bos.workflow.task.mobile.api.model.FilterObject;
import kd.bos.workflow.task.mobile.api.model.GetCountParam;
import kd.bos.workflow.task.mobile.api.model.GetListParam;
import kd.bos.workflow.task.mobile.api.model.ListItemObject;
import kd.bos.workflow.task.mobile.api.model.WfCountObject;
import kd.bos.workflow.task.mobile.api.model.WfListObject;
import kd.bos.workflow.task.mobile.api.model.WfMyListObject;

public class WFIErpHttpApiImpl
extends WFIErpApiImpl {
    private Log logger = LogFactory.getLog(WFIErpHttpApiImpl.class);

    @Override
    public WfCountObject getCount(GetCountParam getListParam) {
        return super.getCount(getListParam);
    }

    @Override
    public WfListObject getList(GetListParam getListParam) {
        WfListObject wfListObject = new WfListObject();
        if (!WfConfigurationUtil.canRunWorkflow()) {
            return wfListObject;
        }
        int pageSize = getListParam.getPageSize();
        int start = (getListParam.getPageNo() - 1) * pageSize + 1;
        String SearchTime = getListParam.getSearchTime();
        String searchValue = getListParam.getSearchValue();
        String searchBill = getListParam.getSearchBill();
        String beginDate = getListParam.getBeginDate();
        String endDate = getListParam.getEndDate();
        if ("timecustom".equals(SearchTime)) {
            beginDate = this.getSysZoneDateStr(getListParam.getBeginDate(), false);
            endDate = this.getSysZoneDateStr(getListParam.getEndDate(), true);
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("pagesize", String.valueOf(pageSize));
        body.put("start", String.valueOf(start));
        body.put("limit", String.valueOf(pageSize));
        body.put("searchvalue", searchValue);
        body.put("searchtime", SearchTime);
        body.put("searchbill", searchBill);
        body.put("begindate", beginDate);
        body.put("enddate", endDate);
        String url = "/kapi/app/wf/getToHandleTasksByUserId";
        Object result = this.excuteMethod(url, body, getListParam.getVeid());
        if (result == null) {
            return wfListObject;
        }
        List taskList = (List)result;
        if (!taskList.isEmpty()) {
            taskList.forEach(m -> {
                ListItemObject item = new ListItemObject();
                item.setBillName(this.getStringVal(m.get("billName")));
                if (m.get("createDate") != null) {
                    String dateString = m.get("createDate").toString();
                    dateString = dateString.endsWith(".0") ? dateString.replace(".0", "") : dateString;
                    item.setDate(dateString);
                } else {
                    item.setDate("");
                }
                item.setId(this.getStringVal(m.get("id")));
                item.setBillId(this.getStringVal(m.get("businesskey")));
                item.setSender(this.getStringVal(m.get("startname")));
                item.setSenderId(this.getStringVal(m.get("initiatorId")));
                item.setPhoteUrl(this.getStringVal(m.get("userImgUrl")));
                item.setSubject(this.getStringVal(m.get("subject")));
                item.setText(this.getStringVal(m.get("text")));
                item.setSourceType(getListParam.getFlag());
                item.setFormId(this.getStringVal(m.get("processingmobilepage")));
                Object o = m.get("openId");
                if (o != null) {
                    item.setFxtid(o.toString());
                }
                item.setBillUrl("");
                item.setVeid(getListParam.getVeid());
                wfListObject.addIlist(item);
            });
        }
        return wfListObject;
    }

    private Object excuteMethod(String url, Map<String, Object> body, String vid) {
        Object obj = null;
        return obj;
    }

    @Override
    public List<FilterObject> getFilter(Map map) {
        return super.getFilter(map);
    }

    @Override
    public ApproveResult quickApprove(Map map) {
        return super.quickApprove(map);
    }

    @Override
    public WfListObject getOverList(GetListParam getListParam) {
        this.logger.info("WFIErpHttpApiImpl-getOverList");
        return super.getOverList(getListParam);
    }

    @Override
    public WfMyListObject getMyList(GetListParam getListParam) {
        this.logger.info("WFIErpHttpApiImpl-getMyList");
        return super.getMyList(getListParam);
    }

    @Override
    public WfMyListObject getMyOverList(GetListParam getListParam) {
        this.logger.info("WFIErpHttpApiImpl-getMyOverList");
        return super.getMyOverList(getListParam);
    }

    @Override
    public String getApproveUrl() {
        return null;
    }

    @Override
    public String getApproveFormId() {
        return super.getApproveFormId();
    }
}

