/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.mobile.eas.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.format.IFormat;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.inte.api.IInteService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ButtonAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.task.mobile.api.model.ListItemObject;
import kd.bos.workflow.task.mobile.api.model.MyListItemObject;
import kd.bos.workflow.task.mobile.api.model.WfListObject;
import kd.bos.workflow.task.mobile.api.model.WfMyListObject;
import kd.bos.workflow.task.mobile.eas.utils.MyListSortUtil;
import kd.bos.workflow.task.mobile.eas.utils.SortUtil;

public class ListUtils {
    private static Log logger = LogFactory.getLog(ListUtils.class);

    public static Map sort(List list, String clom, int pageSize) {
        ArrayList<ListItemObject> sortlist = new ArrayList<ListItemObject>();
        HashMap<String, Serializable> map = new HashMap<String, Serializable>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Map listMap = (Map)list.get(i);
            WfListObject listObject = (WfListObject)listMap.get("object");
            logger.info(String.format("wf_engine mobileList ListUtils\uff0clistObject.getIlist()=%s", listObject.getIlist()));
            sortlist.addAll(listObject.getIlist());
        }
        logger.info(String.format("wf_engine mobileList ListUtils\uff0csortlist=%s", sortlist));
        SortUtil sortClass = new SortUtil();
        Collections.sort(sortlist, sortClass);
        int length = pageSize;
        if (sortlist.size() < pageSize) {
            length = sortlist.size();
        }
        ArrayList<ListItemObject> resultList = new ArrayList<ListItemObject>(length);
        for (int j = 0; j < length; ++j) {
            ListItemObject itemObject = (ListItemObject)sortlist.get(j);
            resultList.add(itemObject);
        }
        for (int i = 0; i < list.size(); ++i) {
            Map listMap = (Map)list.get(i);
            WfListObject listObject = (WfListObject)listMap.get("object");
            List<ListItemObject> llist = listObject.getIlist();
            String flag = (String)listMap.get("fflag");
            int useSize = 0;
            for (int j = 0; j < length; ++j) {
                ListItemObject itemObject = (ListItemObject)sortlist.get(j);
                if (!llist.contains(itemObject)) continue;
                ++useSize;
            }
            map.put(flag + "size", Integer.valueOf(useSize));
        }
        map.put("list", resultList);
        return map;
    }

    public static Map sortMyList(List list, String clom) {
        ArrayList<MyListItemObject> sortlist = new ArrayList<MyListItemObject>();
        HashMap<String, Serializable> map = new HashMap<String, Serializable>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Map listMap = (Map)list.get(i);
            WfMyListObject listObject = (WfMyListObject)listMap.get("object");
            sortlist.addAll(listObject.getIlist());
        }
        MyListSortUtil sortClass = new MyListSortUtil();
        Collections.sort(sortlist, sortClass);
        int length = 10;
        if (sortlist.size() < 10) {
            length = sortlist.size();
        }
        ArrayList<MyListItemObject> resultList = new ArrayList<MyListItemObject>(length);
        for (int j = 0; j < length; ++j) {
            MyListItemObject itemObject = (MyListItemObject)sortlist.get(j);
            resultList.add(itemObject);
        }
        for (int i = 0; i < list.size(); ++i) {
            Map listMap = (Map)list.get(i);
            WfMyListObject listObject = (WfMyListObject)listMap.get("object");
            List<MyListItemObject> llist = listObject.getIlist();
            String flag = (String)listMap.get("fflag");
            int useSize = 0;
            for (int j = 0; j < length; ++j) {
                MyListItemObject itemObject = (MyListItemObject)sortlist.get(j);
                if (!llist.contains(itemObject)) continue;
                ++useSize;
            }
            map.put(flag + "size", Integer.valueOf(useSize));
        }
        map.put("list", resultList);
        return map;
    }

    public static void callYZJApi(String fxtid, IFormView formview) {
        if (!kd.bos.util.StringUtils.isEmpty((String)fxtid)) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("openId", fxtid);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("method", "personInfo");
            map.put("args", param);
            formview.executeClientCommand("callYZJApi", new Object[]{map});
        }
    }

    public static void showConditionLabel(Map map, IFormView formview) {
        String priority;
        String bills;
        String searchtime = (String)map.get("searchtime");
        String searchValue = (String)map.get("searchValue");
        String labeltext = "";
        FlexPanelAp flexPanelAp = ListUtils.createPanel();
        if (!kd.bos.util.StringUtils.isEmpty((String)searchtime)) {
            if ("timeto".equals(searchtime)) {
                labeltext = ResManager.loadKDString((String)"\u4eca\u5929", (String)"ListUtils_0", (String)"bos-wf-task", (Object[])new Object[0]);
            } else if ("timeyesto".equals(searchtime)) {
                labeltext = ResManager.loadKDString((String)"\u6628\u5929", (String)"ListUtils_1", (String)"bos-wf-task", (Object[])new Object[0]);
            } else if ("timewe".equals(searchtime)) {
                labeltext = ResManager.loadKDString((String)"\u8fd1\u4e00\u5468", (String)"ListUtils_2", (String)"bos-wf-task", (Object[])new Object[0]);
            } else if ("timemo".equals(searchtime)) {
                labeltext = ResManager.loadKDString((String)"\u672c\u6708", (String)"ListUtils_3", (String)"bos-wf-task", (Object[])new Object[0]);
            } else if ("timet".equals(searchtime)) {
                labeltext = ResManager.loadKDString((String)"\u672c\u5b63\u5ea6", (String)"ListUtils_4", (String)"bos-wf-task", (Object[])new Object[0]);
            } else if ("timecustom".equals(searchtime)) {
                labeltext = ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u65f6\u95f4", (String)"ListUtils_7", (String)"bos-wf-task", (Object[])new Object[0]);
            } else if ("timeall".equals(searchtime)) {
                labeltext = ResManager.loadKDString((String)"\u5168\u90e8", (String)"ListUtils_5", (String)"bos-wf-task", (Object[])new Object[0]);
            }
            LabelAp buttonAp = ListUtils.createLabel(searchtime, labeltext, labeltext);
            VectorAp vectorAp = ListUtils.createVector(searchtime, "search__" + searchtime);
            flexPanelAp.getItems().add(buttonAp);
            flexPanelAp.getItems().add(vectorAp);
        }
        if (!StringUtils.isEmpty((CharSequence)(bills = (String)map.get("bill")))) {
            String[] ids;
            for (String bill : ids = bills.split(",")) {
                String[] value = bill.split("__");
                String billName = "";
                if (value.length > 2) {
                    billName = value[2];
                }
                LabelAp buttonAp = ListUtils.createLabel(bill, value[0], billName);
                VectorAp vectorAp = ListUtils.createVector(bill, "search__" + bill);
                flexPanelAp.getItems().add(buttonAp);
                flexPanelAp.getItems().add(vectorAp);
            }
        }
        if (!kd.bos.util.StringUtils.isEmpty((String)(priority = (String)map.get("priority")))) {
            String[] ids;
            for (String str : ids = priority.split(",")) {
                String[] value = str.split("_");
                String priorityName = "";
                if (value.length > 1) {
                    priorityName = value[1];
                }
                LabelAp buttonAp = ListUtils.createLabel(str, value[0], priorityName);
                VectorAp vectorAp = ListUtils.createVector(str, "search__" + str);
                flexPanelAp.getItems().add(buttonAp);
                flexPanelAp.getItems().add(vectorAp);
            }
        }
        if (flexPanelAp.getItems().size() > 0) {
            formview.setVisible(Boolean.TRUE, new String[]{"flexpanel"});
            formview.updateControlMetadata("flexpanel", flexPanelAp.createControl());
        } else {
            formview.setVisible(Boolean.FALSE, new String[]{"flexpanel"});
        }
    }

    private static LabelAp createLabel(String id, String key, String value) {
        LabelAp labelAp = new LabelAp();
        labelAp.setId(id);
        labelAp.setKey(key + value);
        labelAp.setHeight(new LocaleString("28px"));
        labelAp.setBackColor("rgba(253,163,43,0.1)");
        labelAp.setWidth(new LocaleString("115px"));
        labelAp.setTextAlign("center");
        labelAp.setForeColor("#FF9200");
        labelAp.setRadius("12px");
        labelAp.setFontSize(13);
        Style style = new Style();
        Margin margin = new Margin();
        Padding padding = new Padding();
        padding.setLeft("10px");
        padding.setRight("20px");
        padding.setTop("3px");
        margin.setLeft("8px");
        margin.setTop("10px");
        style.setPadding(padding);
        style.setMargin(margin);
        Border border = new Border();
        border.setBottom("1px solid #FDA32B");
        border.setLeft("1px solid #FDA32B");
        border.setRight("1px solid #FDA32B");
        border.setTop("1px solid #FDA32B");
        style.setBorder(border);
        labelAp.setStyle(style);
        labelAp.setName(new LocaleString(value));
        return labelAp;
    }

    private static VectorAp createVector(String id, String key) {
        VectorAp vectorAp = new VectorAp();
        vectorAp.setId(id);
        vectorAp.setKey(key);
        vectorAp.setHeight(new LocaleString("30px"));
        vectorAp.setWidth(new LocaleString("25px"));
        vectorAp.setForeColor("#FF9200");
        Style style = new Style();
        Padding padding = new Padding();
        padding.setTop("5px");
        style.setPadding(padding);
        Margin margin = new Margin();
        margin.setLeft("-25px");
        margin.setTop("5px");
        style.setMargin(margin);
        vectorAp.setStyle(style);
        vectorAp.setClickable(Boolean.TRUE.booleanValue());
        vectorAp.setfontClass("kdfont kdfont-shanchu-s");
        vectorAp.setZIndex(2);
        return vectorAp;
    }

    private static ButtonAp createButton(String id, String key) {
        ButtonAp buttonAp = new ButtonAp();
        buttonAp.setId(id);
        buttonAp.setKey(key);
        buttonAp.setHeight(new LocaleString("25px"));
        buttonAp.setWidth(new LocaleString("25px"));
        buttonAp.setRadius("12px");
        buttonAp.setFontSize(13);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setLeft("10px");
        style.setMargin(margin);
        buttonAp.setStyle(style);
        buttonAp.setName(new LocaleString(key));
        return buttonAp;
    }

    private static FlexPanelAp createPanel() {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey("flexpanel");
        flexPanelAp.setId("flexpanel");
        flexPanelAp.setHeight(new LocaleString("auto"));
        flexPanelAp.setBackColor("#FFFFFF");
        flexPanelAp.setShrink(0);
        flexPanelAp.setGrow(0);
        flexPanelAp.setAlignItems("center");
        Style style = new Style();
        Padding padding = new Padding();
        padding.setBottom("10px");
        padding.setLeft("4px");
        Border border = new Border();
        border.setBottom("1px solid #eaeff3");
        style.setPadding(padding);
        style.setBorder(border);
        flexPanelAp.setStyle(style);
        flexPanelAp.setOverflow("scroll");
        flexPanelAp.setName(new LocaleString(ResManager.loadKDString((String)"\u81ea\u52a8\u6dfb\u52a0panel", (String)"ListUtils_6", (String)"bos-wf-task", (Object[])new Object[0])));
        return flexPanelAp;
    }

    public static String getFromCache(IPageCache pgcache, String key) {
        JSONObject searchMap;
        String searchmapstr = pgcache.get("searchmap");
        String value = "";
        if (!kd.bos.util.StringUtils.isEmpty((String)searchmapstr) && (searchMap = JSON.parseObject((String)searchmapstr)) != null) {
            value = (String)searchMap.get(key);
        }
        return value;
    }

    public static String getBillforEid(Map map, String eid) {
        String bills = (String)map.get("bill");
        StringBuilder buf = new StringBuilder();
        if (!kd.bos.util.StringUtils.isEmpty((String)bills)) {
            String[] bill = bills.split(",");
            for (int i = 0; i < bill.length; ++i) {
                if (kd.bos.util.StringUtils.isEmpty((String)bill[i])) continue;
                String key = bill[i].split("__")[0];
                String value = bill[i].split("__")[1];
                if (!eid.equals(key)) continue;
                if (buf != null && buf.length() > 0) {
                    buf.append(",");
                }
                buf.append(value);
            }
        }
        return buf.toString();
    }

    public static String getPriority(String priorityStr) {
        StringBuilder buf = new StringBuilder();
        if (!kd.bos.util.StringUtils.isEmpty((String)priorityStr)) {
            String[] priority = priorityStr.split(",");
            for (int i = 0; i < priority.length; ++i) {
                if (kd.bos.util.StringUtils.isEmpty((String)priority[i])) continue;
                String key = priority[i].split("_")[0];
                if (buf != null && buf.length() > 0) {
                    buf.append(",");
                }
                buf.append(key);
            }
        }
        return buf.toString();
    }

    public static Map removeSearchKey(IPageCache pageCache, String value) {
        int i;
        int size;
        StringBuilder sb;
        value = value.replace("search__", "");
        String searchBill = ListUtils.getFromCache(pageCache, "bill");
        String searchtime = ListUtils.getFromCache(pageCache, "searchtime");
        String searchValue = ListUtils.getFromCache(pageCache, "searchValue");
        String priority = ListUtils.getFromCache(pageCache, "priority");
        HashMap<String, String> map = new HashMap<String, String>();
        if (!kd.bos.util.StringUtils.isEmpty((String)searchBill)) {
            String[] ids = searchBill.split(",");
            sb = new StringBuilder();
            size = ids.length;
            for (i = 0; i < size; ++i) {
                if (value.equalsIgnoreCase(ids[i])) continue;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(ids[i]);
            }
            searchBill = sb.toString();
        }
        if (!kd.bos.util.StringUtils.isEmpty((String)searchtime)) {
            searchtime = searchtime.replace(value, "");
        }
        if (WfUtils.isNotEmpty((String)priority)) {
            String[] prioritys = priority.split(",");
            sb = new StringBuilder();
            size = prioritys.length;
            for (i = 0; i < size; ++i) {
                if (value.equalsIgnoreCase(prioritys[i])) continue;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(prioritys[i]);
            }
            priority = sb.toString();
        }
        if (!kd.bos.util.StringUtils.isEmpty((String)searchValue)) {
            map.put("searchValue", searchValue);
        }
        if (!kd.bos.util.StringUtils.isEmpty((String)searchBill)) {
            map.put("bill", searchBill);
        }
        if (!kd.bos.util.StringUtils.isEmpty((String)searchtime)) {
            map.put("searchtime", searchtime);
            String beginDate = ListUtils.getFromCache(pageCache, "beginDate");
            map.put("beginDate", beginDate);
            String endDate = ListUtils.getFromCache(pageCache, "endDate");
            map.put("endDate", endDate);
        }
        if (!kd.bos.util.StringUtils.isEmpty((String)priority)) {
            map.put("priority", priority);
        }
        pageCache.put("searchmap", JSON.toJSONString(map));
        return map;
    }

    public static String parseDate(String str) {
        if (kd.bos.util.StringUtils.isEmpty((String)str)) {
            return str;
        }
        try {
            String userID = RequestContext.get().getUserId();
            Long userid = Long.valueOf(userID);
            FormatObject fo = InteServiceHelper.getUserFormat((Long)userid);
            IFormat format = FormatFactory.get((FormatTypes)FormatTypes.Date);
            SimpleDateFormat sd1 = new SimpleDateFormat("yyyy-MM-dd");
            Date date = null;
            try {
                IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
                String dateFormat = service.getDateFormat(userid);
                SimpleDateFormat sd = new SimpleDateFormat(dateFormat);
                date = sd1.parse(str);
                if (date != null) {
                    return sd.format(date);
                }
            }
            catch (ParseException e) {
                logger.warn("parseDate:" + date, (Throwable)e);
                return sd1.format(date);
            }
        }
        catch (Exception e) {
            logger.warn("parseDate error:", (Throwable)e);
            return str;
        }
        return str;
    }

    public static String getDefaultFormat(String str) {
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = sd.parse(str);
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return sd.format(date);
    }

    public static String getUrlParam(String searchmapstr) {
        StringBuilder buf = new StringBuilder();
        if (!kd.bos.util.StringUtils.isEmpty((String)searchmapstr)) {
            JSONObject searchMap = JSON.parseObject((String)searchmapstr);
            for (Map.Entry entry : searchMap.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                buf.append("&");
                buf.append(key);
                buf.append("=");
                buf.append(value);
            }
        }
        return buf.toString();
    }
}

