/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.mobile.enterprise;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.task.mobile.enterprise.VirtualEntInfo;

public class EntInfoLoader {
    private ArrayList<VirtualEntInfo> cache;
    private static EntInfoLoader loader = new EntInfoLoader();

    public static EntInfoLoader getInstance() {
        return loader;
    }

    private EntInfoLoader() {
        this.init();
    }

    public void reload() {
        this.init();
    }

    private synchronized void init() {
        Log logger = LogFactory.getLog(this.getClass());
        this.cache = new ArrayList();
        Object filters = null;
        String name = RequestContext.get().getUserName();
        Object filter = null;
        QFilter filter1 = QFilter.of((String)"enable=?", (Object[])new Object[]{"1"});
        DynamicObjectCollection col = QueryServiceHelper.query((String)"wf_mobile_map", (String)"systype.serviceimpl,systype.erpversion,url,veid", (QFilter[])new QFilter[]{filter1, filter});
        for (int i = 0; i < col.size(); ++i) {
            VirtualEntInfo info = new VirtualEntInfo();
            DynamicObject obj = (DynamicObject)col.get(i);
            info.setUrl((String)obj.get("url"));
            info.setId(obj.get("veid").toString());
            info.setServiceImplClass((String)obj.get("systype.serviceimpl"));
            info.setVersion((String)obj.get("systype.erpversion"));
            if (this.contains(this.cache, info)) continue;
            this.cache.add(info);
        }
    }

    private boolean contains(List<VirtualEntInfo> cache2, VirtualEntInfo info) {
        boolean has = false;
        for (int i = 0; i < cache2.size(); ++i) {
            VirtualEntInfo info1 = cache2.get(i);
            if (!info1.getId().equals(info.getId())) continue;
            has = true;
            break;
        }
        return has;
    }

    public ArrayList<VirtualEntInfo> getVirtualEntList() {
        if (this.cache == null || this.cache.size() == 0) {
            this.init();
        }
        return (ArrayList)this.cache.clone();
    }

    public VirtualEntInfo getVirtualEntInfo(String vid) {
        for (VirtualEntInfo info : this.cache) {
            if (!info.getId().equals(vid)) continue;
            return info;
        }
        this.init();
        for (VirtualEntInfo info : this.cache) {
            if (!info.getId().equals(vid)) continue;
            return info;
        }
        return null;
    }
}

