/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.mobile.invoke;

import com.cronutils.utils.StringUtils;
import java.net.ConnectException;
import java.util.Map;
import kd.bos.api.client.ApiClient;
import kd.bos.api.client.ApiClientFactory;
import kd.bos.api.client.ApiRequest;
import kd.bos.api.client.ApiResult;
import kd.bos.api.client.HttpMethod;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.task.mobile.session.ContextSession;
import org.apache.http.NoHttpResponseException;

public class RemoteInvoker {
    private String url;
    private String veid;
    private ApiClient client;
    private static String bsfActionUrl = "/workflow/cm/bsfAction.action";

    public RemoteInvoker(String url) {
        this.url = url;
        this.client = this.getClient();
    }

    public String invoke(Map<String, String> param) {
        Log logger = LogFactory.getLog(this.getClass());
        try {
            String cookie;
            ApiRequest request = this.getApiRequest();
            this.initParam(request, param);
            ApiResult requestResult = this.client.execute(request);
            int code = requestResult.getStatusCode();
            if (code == -1) {
                if (requestResult.getException() instanceof ConnectException) {
                    String string = "ConnectException";
                    return string;
                }
                if (requestResult.getException() instanceof NoHttpResponseException) {
                    String string = "NoHttpResponseException";
                    return string;
                }
            }
            if (StringUtils.isEmpty((CharSequence)(cookie = (String)requestResult.getHeaders().get("Set-Cookie")))) {
                cookie = (String)requestResult.getHeaders().get("cookie");
            }
            ContextSession.setCookie(this.veid, cookie);
            String string = requestResult.getData();
            return string;
        }
        catch (Exception e) {
            logger.error("invoke error", (Throwable)e);
            throw new KDException(e.getMessage());
        }
        finally {
            if (this.client != null) {
                this.client.close();
            }
        }
    }

    protected final ApiClient getClient() {
        ApiClient.Option option = new ApiClient.Option();
        return ApiClientFactory.getInternal((ApiClient.Option)option);
    }

    protected ApiRequest getApiRequest() {
        ApiRequest apirequest = new ApiRequest(HttpMethod.GET, this.url + bsfActionUrl);
        apirequest.addHeader("Connection", "close");
        apirequest.setContentType("text/xml");
        apirequest.setCharacterEncoding("UTF-8");
        return apirequest;
    }

    protected void initParam(ApiRequest request, Map<String, String> params) {
        for (Map.Entry<String, String> elem : params.entrySet()) {
            request.addParameter(elem.getKey(), elem.getValue());
        }
        this.loadContext(request);
    }

    private void loadContext(ApiRequest request) {
        request.addHeader("Cookie", ContextSession.getCookie(this.veid));
        request.addParameter("JSESSIONID", ContextSession.getJSessionID(this.veid));
    }

    public void setVeid(String veid) {
        this.veid = veid;
    }
}

