/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.mobile.meta;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.workflow.task.mobile.meta.ClientPropertiesGroup;
import kd.bos.workflow.task.mobile.meta.MetasUtils;

public class UIMetas {
    private Map<String, Object> props;
    private ArrayList<UIMetas> children;
    private Map<String, Object> style = new HashMap<String, Object>();

    public Map<String, Object> toMap() {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.putAll(this.props);
        if (this.children != null && this.children.size() > 0) {
            ArrayList<Map<String, Object>> dlist = new ArrayList<Map<String, Object>>(this.children.size());
            for (int i = 0; i < this.children.size(); ++i) {
                dlist.add(this.children.get(i).toMap());
            }
            res.put("items", dlist);
        }
        return res;
    }

    public Map<String, Object> getStyle() {
        return this.style;
    }

    public UIMetas(Map<String, Object> obj) {
        this.props = obj;
        this.children = new ArrayList();
        Object item = obj.get("items");
        if (item != null) {
            List cl = (List)item;
            for (Object c : cl) {
                this.children.add(new UIMetas((Map)c));
            }
        }
    }

    public UIMetas Height(String json) {
        this.props.putAll(ClientPropertiesGroup.toMap(json));
        return this;
    }

    public ArrayList<UIMetas> getChildren() {
        return (ArrayList)this.children.clone();
    }

    public UIMetas getChild(int index) {
        if (index > this.children.size() - 1) {
            return null;
        }
        return this.children.get(index);
    }

    public UIMetas setAttr(Map<String, Object> attr) {
        this.props.putAll(attr);
        return this;
    }

    public UIMetas setAttr(String key, Object value) {
        this.props.put(key, value);
        return this;
    }

    public UIMetas appendChild() {
        return this.appendChild(null);
    }

    public UIMetas appendChild(UIMetas child) {
        if (child == null) {
            child = MetasUtils.createDefaultPanel(this.props.get("id") + "_child");
        }
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(child);
        return this;
    }

    public UIMetas deleteChild(int index) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.remove(index);
        return this;
    }

    public UIMetas setText(String text) {
        this.props.put("text", new LocaleString(text));
        return this;
    }

    public UIMetas setWidth(String width) {
        this.props.put("w", new LocaleString(width));
        return this;
    }

    public UIMetas setLabelWidth(String width) {
        this.props.put("lw", new LocaleString(width));
        return this;
    }

    public UIMetas setHeight(String height) {
        this.props.put("h", new LocaleString(height));
        return this;
    }

    public UIMetas setCaption(String caption) {
        this.props.put("caption", new LocaleString(caption));
        return this;
    }

    public UIMetas setClickable(boolean clickable) {
        this.props.put("clickable", clickable);
        return this;
    }

    public UIMetas setForeColor(String foreColor) {
        this.props.put("fc", foreColor);
        return this;
    }

    public UIMetas setBackColor(String backColor) {
        this.props.put("bc", backColor);
        return this;
    }

    public UIMetas setShowStyle(String showStyle) {
        this.props.put("showStyle", showStyle);
        return this;
    }

    public UIMetas setId(String id) {
        this.props.put("id", id);
        return this;
    }

    public UIMetas setType(String type) {
        this.props.put("type", type);
        return this;
    }

    public UIMetas setFontSize(String fontSize) {
        this.props.put("fs", fontSize);
        return this;
    }

    public UIMetas setTextAlign(String textAlign) {
        this.props.put("text-align", textAlign);
        return this;
    }

    public UIMetas setOverflow(String overflow) {
        this.props.put("of", overflow);
        return this;
    }

    public UIMetas setWrap(String wrap) {
        this.props.put("wr", Boolean.valueOf(wrap));
        return this;
    }

    public UIMetas setRadioGroup(String radioGroup) {
        this.props.put("group", Integer.valueOf(radioGroup));
        return this;
    }

    public UIMetas setMargin(Integer[] pxs) {
        HashMap<String, String> padding = new HashMap<String, String>();
        padding.put("t", pxs[0] + "px");
        padding.put("r", pxs[1] + "px");
        padding.put("b", pxs[2] + "px");
        padding.put("l", pxs[3] + "px");
        this.style.put("m", padding);
        this.props.put("s", this.style);
        return this;
    }

    public UIMetas setBorder(String[] border) {
        HashMap<String, String> borders = new HashMap<String, String>();
        borders.put("t", border[0]);
        borders.put("r", border[1]);
        borders.put("b", border[2]);
        borders.put("l", border[3]);
        this.style.put("b", borders);
        this.props.put("s", this.style);
        return this;
    }

    public UIMetas setPadding(Integer[] pxs) {
        HashMap<String, String> padding = new HashMap<String, String>();
        padding.put("t", pxs[0] + "px");
        padding.put("r", pxs[1] + "px");
        padding.put("b", pxs[2] + "px");
        padding.put("l", pxs[3] + "px");
        this.style.put("p", padding);
        this.props.put("s", this.style);
        return this;
    }

    public UIMetas setStyle(Map<String, Object> style) {
        this.props.put("s", style);
        return this;
    }

    public UIMetas setRadius(String radius) {
        this.props.put("rd", radius);
        return this;
    }
}

