/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.mobile.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.task.mobile.api.IWFService;
import kd.bos.workflow.task.mobile.api.WFServiceFactory;
import kd.bos.workflow.task.mobile.api.model.GetCountParam;
import kd.bos.workflow.task.mobile.api.model.WfCountObject;
import kd.bos.workflow.task.mobile.enterprise.EntInfoLoader;
import kd.bos.workflow.task.mobile.enterprise.VirtualEntInfo;

public class WfMenuPlugin
extends AbstractMobBillPlugIn {
    private Log logger = LogFactory.getLog(WfMenuPlugin.class);

    public void initialize() {
        this.addClickListeners(new String[]{"todo", "done", "mydoing", "mydone"});
    }

    public void click(EventObject evt) {
        Map customMap = this.getView().getFormShowParameter().getCustomParams();
        String btnkeys = (String)customMap.get("btnkeys");
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        String selected = this.getPageCache().get("selected");
        HashMap<String, String> map = new HashMap<String, String>();
        this.select(selected, key);
        if ("todo".equals(key)) {
            this.showForm("wf_mobilelist_mob", map);
        } else if ("done".equals(key)) {
            this.showForm("wf_moverlist_mob", map);
        } else if ("mydoing".equals(key)) {
            this.showForm("wf_mobilemylist_mob", map);
        } else if ("mydone".equals(key)) {
            this.showForm("wf_mobilemyoverlist_mob", map);
        }
        this.getPageCache().put("selected", key);
    }

    private void select(String key, String selected) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("c", "#3F3F3F");
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("c", "#55A0F5");
        this.getView().updateControlMetadata(selected + "l", map);
        this.getView().updateControlMetadata(key + "l", map1);
    }

    private void showForm(String fid, Map<String, String> map) {
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("formId", fid);
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            showParameter.setCustomParam(entry.getKey(), (Object)entry.getValue());
        }
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        this.getView().showForm(showParameter);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getCount();
    }

    private void getCount() {
        ArrayList<VirtualEntInfo> list = EntInfoLoader.getInstance().getVirtualEntList();
        int todoCount = 0;
        int myDoingCount = 0;
        try {
            for (int i = 0; i < list.size(); ++i) {
                VirtualEntInfo info = (VirtualEntInfo)list.get(i);
                IWFService svc = WFServiceFactory.getService(info.getId());
                GetCountParam getcountParam = new GetCountParam();
                getcountParam.setVeid(info.getId());
                WfCountObject wfCountObject = svc.getCount(getcountParam);
                todoCount += wfCountObject.getTodoCount();
                myDoingCount += wfCountObject.getMyTodoCount();
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        ((Label)this.getView().getControl("todol")).setText(String.format(ResManager.loadKDString((String)"\u5f85\u529e\u4efb\u52a1(%s)", (String)"WfMenuPlugin_0", (String)"bos-wf-task", (Object[])new Object[0]), todoCount));
        ((Label)this.getView().getControl("mydoingl")).setText(String.format(ResManager.loadKDString((String)"\u5728\u529e\u7533\u8bf7(%s)", (String)"WfMenuPlugin_1", (String)"bos-wf-task", (Object[])new Object[0]), myDoingCount));
    }
}

