/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.mobile.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.control.events.PullRefreshListener;
import kd.bos.list.MobileSearch;
import kd.bos.workflow.task.mobile.api.IWFService;
import kd.bos.workflow.task.mobile.api.WFServiceFactory;
import kd.bos.workflow.task.mobile.api.model.GetListParam;
import kd.bos.workflow.task.mobile.api.model.ListItemObject;
import kd.bos.workflow.task.mobile.api.model.WfListObject;
import kd.bos.workflow.task.mobile.eas.utils.ListUtils;
import kd.bos.workflow.task.mobile.enterprise.EntInfoLoader;
import kd.bos.workflow.task.mobile.enterprise.VirtualEntInfo;
import kd.bos.workflow.task.mobile.plugin.WfMyListPlugin;
import org.apache.commons.lang.StringUtils;

public class WfOverListPlugin
extends WfMyListPlugin
implements CellClickListener,
ICloseCallBack,
MobileSearchTextChangeListener,
PullRefreshListener,
EntryGridBindDataListener {
    public static final int PAGESIZE = 10;

    @Override
    public void initialize() {
        CardEntry mcGrid = (CardEntry)this.getControl("entryentity");
        mcGrid.addCellClickListener((CellClickListener)this);
        mcGrid.addPullRefreshlisteners((PullRefreshListener)this);
        mcGrid.addDataBindListener((EntryGridBindDataListener)this);
        this.addClickListeners(new String[]{"searchitembar", "searchcancel", "showfilter", "photofp", "photo", "cancelimage"});
        MobileSearch ms = (MobileSearch)this.getControl("mobilesearchap1");
        ms.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
    }

    @Override
    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        evt.getSource();
        IDataModel model = this.getModel();
        int index = model.getEntryCurrentRowIndex("entryentity");
        if ("searchitembar".equals(key)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"mtoolbarap"});
        } else if ("searchcancel".equals(key) || "cancelimage".equals(key)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"mtoolbarap"});
            this.getPageCache().put("PageNo", "1");
            this.getPageCache().put("searchmap", "");
            this.getList(new HashMap(), true, 0, null);
        } else if ("showfilter".equals(key) || "choosepanel".equals(key)) {
            String showfilter = this.getPageCache().get("showfilter");
            if ("true".equals(showfilter)) {
                this.getPageCache().put("showfilter", "");
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"billpanel"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"choosepanel"});
            } else {
                this.showFilter("wf_mobiletaskfilternew", "choosepanel", "getfilter", "done");
                this.getPageCache().put("showfilter", "true");
            }
        } else if ("photofp".equals(key)) {
            String fxtid = this.getValueFromCache("fxtid", index);
            ListUtils.callYZJApi(fxtid, this.getView());
        } else if (key.indexOf("search__") > -1) {
            this.getPageCache().put("PageNo", "1");
            Map map = ListUtils.removeSearchKey(this.getPageCache(), key);
            this.getList(map, true, 0, null);
        }
    }

    @Override
    public void getList(Map map, boolean init, int index, List resultlist) {
        ArrayList<VirtualEntInfo> list = EntInfoLoader.getInstance().getVirtualEntList();
        Object reMap = new HashMap();
        if (this.getPageCache().get("reMap") != null) {
            reMap = JSON.parseObject((String)this.getPageCache().get("reMap"));
        }
        this.getPageCache().put("list", "");
        int newPageSize = 10;
        if (index > 0) {
            this.getPageCache().put("PageNo", String.valueOf(index / 10 + 1));
            newPageSize = (index / 10 + 1) * 10;
        }
        ArrayList sourceList = new ArrayList();
        WfListObject cacheObject = new WfListObject();
        List<Object> cachelist = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            String bills;
            WfListObject listObject = new WfListObject();
            VirtualEntInfo info = (VirtualEntInfo)list.get(i);
            String version = info.getVersion();
            int pageNo = 0;
            int size = 0;
            if (map.containsKey("bill") && StringUtils.isEmpty((String)(bills = ListUtils.getBillforEid(map, info.getId())))) continue;
            cacheObject = null;
            if (!init) {
                if (this.getPageCache().get(version + "PageNo") != null) {
                    pageNo = Integer.parseInt(this.getPageCache().get(version + "PageNo"));
                }
                if (reMap.get(version + "size") != null) {
                    size = (Integer)reMap.get(version + "size");
                }
                cacheObject = (WfListObject)JSON.parseObject((String)this.getPageCache().get(version + "List"), WfListObject.class);
            }
            if ((cachelist = cacheObject != null ? cacheObject.getIlist() : new ArrayList()).size() > 0) {
                int cacheSize = cachelist.size();
                listObject.getIlist().clear();
                for (int j = size; j < cacheSize; ++j) {
                    listObject.getIlist().add((ListItemObject)JSON.parseObject((String)JSON.toJSONString((Object)cachelist.get(j)), ListItemObject.class));
                }
            }
            IWFService svc = WFServiceFactory.getService(info.getId());
            if ((listObject == null || listObject.getIlist().size() < newPageSize) && (init || !init && cachelist.size() >= newPageSize)) {
                this.loadList(map, listObject, info, version, ++pageNo, svc, newPageSize);
                if (index > 0) {
                    pageNo = index / 10 + 1;
                }
                this.getPageCache().put(version + "PageNo", String.valueOf(pageNo));
            }
            ListUtils.showConditionLabel(map, this.getView());
            HashMap<String, Object> listMap = new HashMap<String, Object>();
            listMap.put("object", listObject);
            listMap.put("veid", info.getId());
            listMap.put("fflag", info.getVersion());
            listMap.put("fname", info.getVersion());
            sourceList.add(listMap);
            this.getPageCache().put(version + "List", JSON.toJSONString((Object)listObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
        }
        IDataModel dataModel = this.getModel();
        reMap = ListUtils.sort(sourceList, "", newPageSize);
        this.getPageCache().put("reMap", JSON.toJSONString((Object)reMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
        List reList = (List)reMap.get("list");
        int newsize = reList.size();
        this.getPageCache().put("thispagesize", String.valueOf(newsize));
        if (init) {
            dataModel.deleteEntryData("entryentity");
            if (newsize > 0) {
                dataModel.batchCreateNewEntryRow("entryentity", newsize);
            }
        }
        if (init && newsize == 0) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"nolist"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"nolist"});
        }
        for (int i = 0; i < reList.size(); ++i) {
            this.setModel(dataModel, reList, i, newPageSize, resultlist, init);
        }
        this.createModelCache(reList, newPageSize, init);
        if (index > 0) {
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).invokeControlMethod("cardentryviewap", "setRowVisible", new Object[]{index});
        }
    }

    private void loadList(Map map, WfListObject listObject, VirtualEntInfo info, String version, int pageNo, IWFService svc, int size) {
        String billId;
        GetListParam getListParam = new GetListParam();
        if (map.containsKey("bill") && !StringUtils.isEmpty((String)(billId = ListUtils.getBillforEid(map, info.getId())))) {
            getListParam.setSearchBill(billId);
        }
        getListParam.setPageNo(pageNo);
        getListParam.setPageSize(size);
        getListParam.setFlag(version);
        getListParam.setVeid(info.getId());
        getListParam.setUserId(RequestContext.get().getUserId());
        getListParam.setSearchTime((String)map.get("searchtime"));
        getListParam.setBeginDate((String)map.get("beginDate"));
        getListParam.setEndDate((String)map.get("endDate"));
        getListParam.setSearchValue((String)map.get("searchValue"));
        WfListObject objectEasNew = svc.getOverList(getListParam);
        for (int j = 0; j < objectEasNew.getIlist().size(); ++j) {
            listObject.getIlist().add(objectEasNew.getIlist().get(j));
        }
    }

    private void setModel(IDataModel dataModel, List reList, int i, int pageSize, List resultlist, boolean init) {
        ListItemObject oj = (ListItemObject)reList.get(i);
        String date = ListUtils.parseDate(oj.getDate());
        int index = i;
        if (!init) {
            index = i + (this.getPage() - 1) * pageSize;
        }
        if (resultlist != null) {
            dataModel.getEntryRowCount("entryentity");
            JSONArray objlist = new JSONArray();
            objlist.add((Object)index);
            objlist.add((Object)(index + 1));
            objlist.add(null);
            objlist.add(null);
            objlist.add((Object)oj.getBillName());
            objlist.add((Object)date);
            objlist.add((Object)oj.getProDefName());
            objlist.add((Object)oj.getText());
            objlist.add((Object)oj.getId());
            objlist.add(new HashMap());
            objlist.add(new HashMap());
            objlist.add(new HashMap());
            objlist.add(new HashMap());
            resultlist.add(objlist);
        } else {
            dataModel.setValue("fprodefname", (Object)oj.getProDefName(), index);
            dataModel.setValue("name", (Object)oj.getBillName(), index);
            dataModel.setValue("time", (Object)date, index);
            dataModel.setValue("sender", (Object)oj.getSender(), index);
            dataModel.setValue("text", (Object)oj.getText(), index);
            dataModel.setValue("subject", (Object)oj.getSubject(), index);
            dataModel.setValue("cometype", (Object)oj.getSourceType(), index);
            dataModel.setValue("senderid", (Object)oj.getSenderId(), index);
            dataModel.setValue("billid", (Object)oj.getBillId(), index);
            dataModel.setValue("veid", (Object)oj.getVeid(), index);
            dataModel.setValue("billformid", (Object)oj.getFormId(), index);
            dataModel.setValue("billUrl", (Object)oj.getBillUrl(), index);
            dataModel.setValue("assignid", (Object)oj.getId(), index);
            dataModel.setValue("fxtid", (Object)oj.getFxtid(), index);
        }
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        propertiesMap.put("text", oj.getSubject());
        HashMap<String, String> photoSrcMap = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> photoMap = new HashMap<String, HashMap<String, String>>();
        photoSrcMap.put("src", oj.getPhoteUrl());
        photoMap.put("photo", photoSrcMap);
        photoMap.put("subjectlabel", propertiesMap);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).invokeControlMethod("entryentity", "setCustomProperties", new Object[]{index, photoMap});
    }

    private void createModelCache(List reList, int pageSize, boolean init) {
        if (this.getPage() == 1) {
            this.clearModelCache();
        }
        Map modelCache = this.getModelCache();
        int pageNo = this.getPage();
        if (init) {
            pageNo = 1;
        }
        for (int i = 0; i < reList.size(); ++i) {
            int index = i + (pageNo - 1) * pageSize;
            HashMap<String, Object> object = new HashMap<String, Object>(17);
            ListItemObject oj = (ListItemObject)reList.get(i);
            object.put("fprodefname", oj.getProDefName());
            object.put("name", oj.getBillName());
            object.put("time", oj.getDate());
            object.put("sender", oj.getSender());
            object.put("text", oj.getText());
            object.put("senderid", oj.getSenderId());
            object.put("assignid", oj.getId());
            object.put("billid", oj.getBillId());
            object.put("subject", oj.getSubject());
            object.put("cometype", oj.getSourceType());
            object.put("billformid", oj.getFormId());
            object.put("veid", oj.getVeid());
            object.put("assigntype", oj.getAssigntype());
            object.put("billurl", oj.getBillUrl());
            object.put("fxtid", oj.getFxtid());
            object.put("type", "handled");
            object.put("taskId", oj.getId());
            object.put("category", oj.getCategory());
            object.put("isBizTask", oj.isBizTask());
            modelCache.put(String.valueOf(index), object);
        }
        this.getPageCache().put("modelcache", JSON.toJSONString((Object)modelCache));
    }

    private String getValueFromCache(String id, int i) {
        Map modellist = this.getModelCache();
        Map object = (Map)modellist.get(String.valueOf(i));
        return (String)object.get(id);
    }
}

