/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.mobile.session;

import kd.bos.session.SessionDAOFactory;

public class ContextSession {
    private static final String CURRENT_VID = "wf_current_vid";
    private static final String COOKIE_PREFIX = "wf_cookie_";
    private static final String JSESSIONID_PREFIX = "wf_jsessionid_";

    public static void setCurrentVid(String vid) {
        SessionDAOFactory.get().setAttribute(CURRENT_VID, vid);
    }

    public static String getCurrentVid() {
        return SessionDAOFactory.get().getAttribute(CURRENT_VID);
    }

    public static void setCookie(String eid, String cookie) {
        String newId;
        String currentJid = ContextSession.getJSessionID(eid);
        if (cookie.indexOf("JSESSIONID=") >= 0 && (newId = cookie.substring("JSESSIONID=".length(), cookie.indexOf(";"))) != null && !newId.equals(currentJid)) {
            SessionDAOFactory.get().setAttribute(JSESSIONID_PREFIX + eid, newId);
            SessionDAOFactory.get().setAttribute(COOKIE_PREFIX + eid, cookie);
        }
    }

    public static void setJSessionID(String eid, String sessionid) {
        SessionDAOFactory.get().setAttribute(JSESSIONID_PREFIX + eid, sessionid);
    }

    public static String getCookie(String eid) {
        if (eid == null) {
            eid = SessionDAOFactory.get().getAttribute(CURRENT_VID);
        }
        return SessionDAOFactory.get().getAttribute(COOKIE_PREFIX + eid);
    }

    public static String getJSessionID(String eid) {
        if (eid == null) {
            eid = SessionDAOFactory.get().getAttribute(CURRENT_VID);
        }
        return SessionDAOFactory.get().getAttribute(JSESSIONID_PREFIX + eid);
    }
}

