/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.plugin;

import java.util.ArrayList;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.workflow.task.service.TaskRuntimeService;

public class TaskDeadletterJobListPlugin
extends AbstractListPlugin {
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String BAR_ACTIVATE = "baractivate";
    private static final String BAR_REFRESH = "barrefresh";

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "baractivate": {
                this.activateDeadJob();
                break;
            }
            case "barrefresh": {
                this.refresh();
                break;
            }
        }
    }

    private void activateDeadJob() {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        StringBuilder deadLetterJobIds = new StringBuilder();
        ArrayList<Long> successJobIds = new ArrayList<Long>(10);
        ArrayList<String> failJobsTips = new ArrayList<String>(10);
        if (rows != null && !rows.isEmpty()) {
            try {
                for (ListSelectedRow row : rows) {
                    Long deadLetterJobId = (Long)row.getPrimaryKeyValue();
                    deadLetterJobIds.append(deadLetterJobId).append(',');
                    try {
                        TaskRuntimeService.create().activeSuspendTaskById(deadLetterJobId);
                        successJobIds.add(deadLetterJobId);
                    }
                    catch (Exception e) {
                        failJobsTips.add(deadLetterJobId + ":" + e.getMessage());
                    }
                }
            }
            catch (Exception e) {
                String message = String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u6a21\u578b\u5f02\u5e38\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"TaskDeadletterJobListPlugin_1", (String)"bos-wf-task", (Object[])new Object[0]), e.getMessage());
                this.getView().showErrorNotification(message);
                this.refresh();
            }
            if (failJobsTips.size() > 0) {
                String handleName = ResManager.loadKDString((String)"\u6fc0\u6d3b\u4efb\u52a1\u3002", (String)"TaskDeadletterJobListPlugin_2", (String)"bos-wf-task", (Object[])new Object[0]);
                StandardTips.view((IFormView)this.getView()).batchOptionMsg(handleName, successJobIds, failJobsTips);
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6fc0\u6d3b\u6210\u529f\u3002", (String)"TaskDeadletterJobListPlugin_3", (String)"bos-wf-task", (Object[])new Object[0]), Integer.valueOf(3000));
            }
            this.refresh();
        } else {
            StandardTips.view((IFormView)this.getView()).notSelectRow();
        }
    }

    private void refresh() {
        ListView listView = (ListView)this.getView();
        listView.clearSelection();
        listView.refresh();
    }
}

