/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.utils.MessageConfigurationUtil;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.task.TaskModelExternalService;
import kd.bos.workflow.task.mobile.eas.utils.ListUtils;
import kd.bos.workflow.task.mobile.session.ContextSession;
import kd.bos.workflow.task.utils.TaskModelUtils;

public class TaskPluginUtils {
    private static Log logger = LogFactory.getLog(TaskPluginUtils.class);

    public static void setComboForControl(Map<String, Object> items, ComboEdit operation) {
        ComboItem comboItem = null;
        LocaleString localeString = null;
        Set<Map.Entry<String, Object>> entrySet = items.entrySet();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(entrySet.size());
        for (Map.Entry<String, Object> entry : entrySet) {
            comboItem = new ComboItem();
            localeString = new LocaleString();
            localeString.setLocaleValue(entry.getKey());
            comboItem.setCaption(localeString);
            comboItem.setValue(entry.getValue().toString());
            comboItems.add(comboItem);
        }
        operation.setComboItems(comboItems);
    }

    public static ILocaleString getLocaleString(JSONObject properties) {
        LocaleString localeString = new LocaleString();
        Set entries = properties.entrySet();
        for (Map.Entry entry : entries) {
            localeString.setItem((String)entry.getKey(), (Object)((String)entry.getValue()));
        }
        return localeString;
    }

    public static String getCurrentLocaleString(JSONObject properties) {
        RequestContext context = RequestContext.get();
        Lang currentLang = context.getLang();
        if (properties.containsKey((Object)currentLang)) {
            return properties.getString(currentLang.toString());
        }
        if (properties.containsKey((Object)"GLang")) {
            return properties.getString("GLang");
        }
        if (properties.containsKey((Object)"zh_CN")) {
            return properties.getString("zh_CN");
        }
        return "";
    }

    public static void openTaskHandlePage(IFormView view, Map map, int index, String taskType, String searchMap, CloseCallBack closeCallBack) {
        boolean isBizTask;
        String formId = (String)map.get("billformid");
        String veid = (String)map.get("veid");
        ContextSession.setCurrentVid(veid);
        String category = null;
        if (map.containsKey("category")) {
            category = (String)map.get("category");
        }
        if ((isBizTask = map.get("isBizTask") instanceof Boolean ? (Boolean)map.get("isBizTask") : Boolean.parseBoolean((String)map.get("isBizTask"))) && TaskModelUtils.isOuterSystemTask(category)) {
            if (MessageConfigurationUtil.showOuterSystemTaskByBrowserTab()) {
                Long taskId = Long.parseLong((String)map.get("taskId"));
                TaskService taskService = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getTaskService();
                TaskInfo taskInfo = taskService.findTaskByIdAndType(taskId, taskType);
                TaskModelExternalService taskModelService = TaskModelExternalService.create();
                String trdSsoUrl = taskModelService.getFormServiceLink(taskInfo, false);
                view.openUrl(trdSsoUrl);
            } else {
                TaskPluginUtils.showForm(view, formId, map, searchMap, closeCallBack);
            }
        } else if (WfUtils.isNotEmpty((String)formId)) {
            TaskPluginUtils.showForm(view, formId, map, searchMap, closeCallBack);
        } else {
            String billUrl = (String)map.get("billurl");
            String param = ListUtils.getUrlParam(searchMap);
            view.openUrl(billUrl + "&index=" + index + param + "&isnew=yes");
        }
    }

    public static void showForm(IFormView view, String formId, Map<String, String> map, String searchMap, CloseCallBack closeCallBack) {
        HashMap<String, String> para = new HashMap<String, String>();
        FormShowParameter parameter = view.getFormShowParameter();
        if (parameter != null) {
            para.putAll(parameter.getCustomParams());
        }
        para.put("formId", formId);
        FormShowParameter formShowParameter = FormShowParameter.createFormShowParameter(para);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            formShowParameter.setCustomParam(entry.getKey(), (Object)entry.getValue());
        }
        Object type = formShowParameter.getCustomParam("type");
        if ("handled".equals(type)) {
            formShowParameter.setClientParam("requestAfterClose", (Object)true);
        } else if ("tohandled".equals(type)) {
            formShowParameter.setCustomParam("searchmap", (Object)JSON.parseObject((String)searchMap));
            formShowParameter.setCustomParam("mobileMobFlag", (Object)"wf_mobilelist_mob");
        }
        formShowParameter.setCloseCallBack(closeCallBack);
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        view.showForm(formShowParameter);
    }
}

