/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.plugin.job;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.PageMode;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.service.IWorkflowCoreService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.task.entity.TaskJobEntity;
import kd.bos.workflow.task.service.MessageLogService;

public class TaskJobListPlugin
extends AbstractListPlugin {
    MessageLogService messageLogService = null;
    private static final String BTNRETRY = "retry";
    private static final String BTNRETRYLOG = "retrylog";
    private static final String BOS_LISTF7 = "bos_listf7";
    private static final String CHANNELLOGID = "channellogid";

    public void listRowClick(ListRowClickEvent evt) {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        this.controlButtonState(rows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillListHyperLinkClickEvent event = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        Long pkValue = (Long)event.getCurrentRow().getPrimaryKeyValue();
        try {
            ListShowParameter parameter = new ListShowParameter();
            parameter.setFormId(BOS_LISTF7);
            parameter.setBillFormId("wf_taskjobretrylog");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setPageMode(PageMode.Default.getPageMode());
            parameter.setShowTitle(false);
            parameter.setMultiSelect(false);
            StyleCss styleCss = new StyleCss();
            styleCss.setWidth("960px");
            styleCss.setHeight("580px");
            parameter.getOpenStyle().setInlineStyleCss(styleCss);
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            QFilter qFilter = new QFilter(CHANNELLOGID, "=", (Object)pkValue);
            listFilterParameter.setFilter(qFilter);
            parameter.setListFilterParameter(listFilterParameter);
            parameter.setCustomParam(CHANNELLOGID, (Object)pkValue);
            this.getView().showForm((FormShowParameter)parameter);
        }
        catch (Exception e) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"TaskJobListPlugin_1", (String)"bos-wf-task", (Object[])new Object[0]));
        }
        finally {
            args.setCancel(true);
        }
    }

    private void controlButtonState(ListSelectedRowCollection rows) {
        ArrayList<Long> rowIds = new ArrayList<Long>();
        if (rows == null || rows.isEmpty()) {
            this.getView().setEnable(Boolean.TRUE, new String[]{BTNRETRY});
            return;
        }
        for (ListSelectedRow row : rows) {
            rowIds.add((Long)row.getPrimaryKeyValue());
        }
        List taskJobs = this.getMessageLogService().getTaskJobsByIds(rowIds, "id,todostate");
        boolean resendEnable = Boolean.TRUE;
        for (TaskJobEntity entity : taskJobs) {
            if (!TaskJobEntity.TodoState.DEALSUCCESS.name().equals(entity.getTodoState()) && !TaskJobEntity.TodoState.UNTREATED.name().equals(entity.getTodoState())) continue;
            resendEnable = Boolean.FALSE;
            break;
        }
        this.getView().setEnable(Boolean.valueOf(resendEnable), new String[]{BTNRETRY});
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if (BTNRETRY.equalsIgnoreCase(operateKey)) {
            this.retryJob();
        } else if (BTNRETRYLOG.equalsIgnoreCase(operateKey)) {
            this.viewRetryLog();
        }
    }

    public void viewRetryLog() {
        ListSelectedRowCollection rows = this.getSelectedRow();
        if (rows != null) {
            Long pkValue = (Long)rows.get(0).getPrimaryKeyValue();
            if (TaskJobListPlugin.hasCurrentPageTab(this.getView(), pkValue)) {
                return;
            }
            ListShowParameter parameter = new ListShowParameter();
            parameter.setFormId("bos_list");
            parameter.setBillFormId("wf_taskjobretrylog");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setPageId(TaskJobListPlugin.getPageId(this.getView(), pkValue));
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            QFilter qFilter = new QFilter(CHANNELLOGID, "=", (Object)pkValue);
            listFilterParameter.setFilter(qFilter);
            parameter.setListFilterParameter(listFilterParameter);
            parameter.setCustomParam(CHANNELLOGID, (Object)pkValue);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public static String getPageId(IFormView view, long channelLogId) {
        String pageId = UUID.randomUUID().toString();
        IPageCache parentPageCache = (IPageCache)view.getService(IPageCache.class);
        parentPageCache.put(TaskJobListPlugin.getPageKey(view, channelLogId), pageId);
        return pageId;
    }

    public static boolean hasCurrentPageTab(IFormView view, long channelLogId) {
        IFormView formView;
        String pageId = "";
        IPageCache parentPageCache = (IPageCache)view.getParentView().getService(IPageCache.class);
        pageId = parentPageCache.get(TaskJobListPlugin.getPageKey(view.getParentView(), channelLogId));
        if (WfUtils.isEmpty((String)pageId)) {
            parentPageCache = (IPageCache)view.getService(IPageCache.class);
            pageId = parentPageCache.get(TaskJobListPlugin.getPageKey(view, channelLogId));
        }
        if (WfUtils.isNotEmpty((String)pageId) && (formView = view.getViewNoPlugin(pageId)) != null) {
            formView.activate();
            view.sendFormAction(formView);
            return true;
        }
        return false;
    }

    private static String getPageKey(IFormView view, long channelLogId) {
        String pageKey = channelLogId + RequestContext.get().getUserId() + view.getFormShowParameter().getRootPageId();
        return pageKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retryJob() {
        ListSelectedRowCollection rows = this.getSelectedRows();
        if (rows == null || rows.size() <= 0) {
            return;
        }
        ArrayList<Long> taskJobIds = new ArrayList<Long>(rows.size());
        try {
            for (ListSelectedRow row : rows) {
                taskJobIds.add((Long)row.getPrimaryKeyValue());
            }
            this.getMessageLogService().retryTaskJobByIds(taskJobIds);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u8bd5\u6267\u884c\u6210\u529f\u3002", (String)"TaskJobListPlugin_3", (String)"bos-wf-task", (Object[])new Object[0]), Integer.valueOf(3000));
        }
        catch (Exception e) {
            this.getView().showErrMessage(WfUtils.getExceptionStacktrace((Throwable)e), ResManager.loadKDString((String)"\u91cd\u8bd5\u6267\u884c\u5931\u8d25\u3002", (String)"TaskJobListPlugin_2", (String)"bos-wf-task", (Object[])new Object[0]));
        }
        finally {
            this.refresh();
        }
    }

    private MessageLogService getMessageLogService() {
        if (this.messageLogService == null) {
            this.messageLogService = (MessageLogService)((IWorkflowCoreService)ServiceFactory.getService(IWorkflowCoreService.class)).getService(MessageLogService.class);
        }
        return this.messageLogService;
    }

    private void refresh() {
        IListView view = (IListView)this.getView();
        view.clearSelection();
        view.refresh();
    }

    public ListSelectedRowCollection getSelectedRow() {
        ListSelectedRowCollection rows = this.getSelectedRows();
        if (rows == null || rows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"TaskJobListPlugin_4", (String)"bos-wf-task", (Object[])new Object[0]), Integer.valueOf(2000));
            rows = null;
        } else if (1 < rows.size()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\uff0c\u60a8\u5f53\u524d\u9009\u62e9\u4e86[%s]\u884c\u3002", (String)"TaskJobListPlugin_5", (String)"bos-wf-task", (Object[])new Object[0]), rows.size()), Integer.valueOf(2000));
            rows = null;
        }
        return rows;
    }
}

