/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.plugin.model;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.Delete;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.message.channel.cache.MsgServiceCacheHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.task.cache.TaskModelCacheHelper;

public class TaskModelConfigListPlugin
extends AbstractListPlugin
implements IConfirmCallBack {
    private static final String TASKMODELNUMBERS = "taskModelNumbers";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object[] primaryKeyValues;
        QFilter[] filters;
        DynamicObject[] taskModels;
        List numbers;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Delete && (numbers = Stream.of(taskModels = BusinessDataServiceHelper.load((String)"wf_task_modeldef", (String)"number", (QFilter[])(filters = new QFilter[]{new QFilter("id", "in", (Object)(primaryKeyValues = args.getListSelectedData().getPrimaryKeyValues()))}))).map(item -> item.getString("number")).collect(Collectors.toList())) != null && !numbers.isEmpty()) {
            IPageCache pageCache = this.getView().getPageCache();
            pageCache.put(TASKMODELNUMBERS, SerializationUtils.toJsonString(numbers));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getSource() instanceof Delete) {
            MsgServiceCacheHelper.removeOuterTaskModelDefintionSign();
            IPageCache pageCache = this.getView().getPageCache();
            String tmns = pageCache.get(TASKMODELNUMBERS);
            if (WfUtils.isNotEmpty((String)tmns)) {
                List taskModelNumbers = (List)SerializationUtils.fromJsonString((String)tmns, List.class);
                taskModelNumbers.stream().forEach(taskModelNumber -> TaskModelCacheHelper.removeTaskModelDefinitionCacheEntry(taskModelNumber));
                pageCache.remove(TASKMODELNUMBERS);
            }
        }
    }
}

