/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.plugin.model;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.Save;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.message.channel.cache.MsgServiceCacheHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.task.cache.TaskModelCacheHelper;

public class TaskModelConfigPlugin
extends AbstractFormPlugin
implements ClickListener,
ItemClickListener,
IConfirmCallBack {
    private static final String ENABLE = "enable";
    private static final String RESOURCE = "resource";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Save) {
            this.getModel().setValue(ENABLE, (Object)"1");
            JSONObject taskModelDefinitionConfig = this.getTaskModelDefinitionConfig();
            String resourceLocaleValue = taskModelDefinitionConfig.toJSONString();
            OrmLocaleValue source = (OrmLocaleValue)this.getModel().getValue(RESOURCE);
            source.setLocaleValue(resourceLocaleValue);
            source.setItem("GLang", resourceLocaleValue);
            this.getModel().setValue(RESOURCE, (Object)source);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("save".equals(afterDoOperationEventArgs.getOperateKey())) {
            MsgServiceCacheHelper.removeOuterTaskModelDefintionSign();
            String taskModelNumber = (String)this.getModel().getValue("number");
            TaskModelCacheHelper.removeTaskModelDefinitionCacheEntry(taskModelNumber);
        }
    }

    private JSONObject getTaskModelDefinitionConfig() {
        ILocaleString description;
        JSONObject baseConfig = this.getTaskModelBaseConfig();
        baseConfig.put("stencilType", this.getModel().getValue("stenciltype"));
        baseConfig.put("number", this.getModel().getValue("number"));
        ILocaleString name = (ILocaleString)this.getModel().getValue("name");
        if (name != null) {
            baseConfig.put("name", (Object)name.getLocaleValue());
        }
        if ((description = (ILocaleString)this.getModel().getValue("description")) != null) {
            baseConfig.put("description", (Object)description.getLocaleValue());
        }
        return baseConfig;
    }

    private JSONObject getTaskModelBaseConfig() {
        OrmLocaleValue resource = (OrmLocaleValue)this.getModel().getValue(RESOURCE);
        String resourceLocaleValue = resource.toString();
        if (WfUtils.isNotEmpty((String)resourceLocaleValue)) {
            return JSONObject.parseObject((String)resourceLocaleValue);
        }
        return this.getModelConfig();
    }

    private JSONObject getModelConfig() {
        JSONObject baseConfig = new JSONObject();
        baseConfig.put("allowSendTodo", (Object)false);
        baseConfig.put("processingPage", (Object)"wf_task_blankhandlepage");
        baseConfig.put("processingMobilePage", (Object)"wf_task_blankhandlepage_mob");
        baseConfig.put("endType", (Object)"pc");
        baseConfig.put("hideTaskInCenter", (Object)false);
        JSONArray decisionOptions = new JSONArray();
        JSONObject option1 = new JSONObject();
        option1.put("number", (Object)"Agree");
        option1.put("name", (Object)ResManager.loadKDString((String)"\u540c\u610f", (String)"TaskModelConfigPlugin_0", (String)"bos-wf-task", (Object[])new Object[0]));
        option1.put("defaultDecision", (Object)true);
        JSONObject option2 = new JSONObject();
        option2.put("number", (Object)"NotAgree");
        option2.put("name", (Object)ResManager.loadKDString((String)"\u4e0d\u540c\u610f", (String)"TaskModelConfigPlugin_1", (String)"bos-wf-task", (Object[])new Object[0]));
        option2.put("defaultDecision", (Object)true);
        decisionOptions.add((Object)option1);
        decisionOptions.add((Object)option2);
        baseConfig.put("decisionOptions", (Object)decisionOptions);
        JSONObject billSetting = new JSONObject();
        billSetting.put("formKey", (Object)"");
        billSetting.put("mobilFormKey", (Object)"");
        baseConfig.put("billSetting", (Object)billSetting);
        baseConfig.put("subject", (Object)new JSONArray());
        baseConfig.put("participant", (Object)new JSONObject());
        baseConfig.put("msg", (Object)new JSONArray());
        baseConfig.put("taskListeners", (Object)new JSONArray());
        return baseConfig;
    }
}

