/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.plugin.monitor;

import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.workflow.engine.task.BatchOperateResult;
import kd.bos.workflow.engine.task.operation.CompleteOperationParam;
import kd.bos.workflow.engine.task.operation.DeleteOperationParam;
import kd.bos.workflow.task.service.TaskRuntimeService;

public class AdminMonitorTaskData
extends AbstractFormPlugin
implements ClickListener {
    private static final String TASKS = "tasks";
    private static final String COMPLETEUSER = "completeuser";
    private static final String DECOPTIONNUMBER = "decoptionnumber";
    private static final String AUDITMESSAGE = "auditmessage";
    private static final String BTN_COMPLETE = "btn_complete";
    private static final String DELETEUSER = "deleteuser";
    private static final String BTN_DELETE = "btn_delete";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_COMPLETE, BTN_DELETE});
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        IDataModel model = this.getModel();
        DynamicObjectCollection taskInfos = (DynamicObjectCollection)model.getValue(TASKS);
        if (taskInfos == null || taskInfos.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4efb\u52a1\u6570\u636e\u3002", (String)"AdminMonitorTaskData_0", (String)"bos-wf-task", (Object[])new Object[0]);
            this.getView().showTipNotification(msg, Integer.valueOf(3000));
            return;
        }
        List<Long> taskIds = taskInfos.stream().map(taskInfo -> taskInfo.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
        BatchOperateResult batchOperateResult = this.handleBizTask(btn.getKey(), model, taskIds);
        if (batchOperateResult == null) {
            return;
        }
        List operateResults = batchOperateResult.getOperateResults();
        if (batchOperateResult.isSuccess()) {
            List tIds = operateResults.stream().map(result -> String.valueOf(result.getTaskId())).collect(Collectors.toList());
            String tIdInfos = String.join((CharSequence)",", tIds);
            String msg = String.format(ResManager.loadKDString((String)"\u5904\u7406\u4efb\u52a1[%s]\u6210\u529f\u3002", (String)"AdminMonitorTaskData_1", (String)"bos-wf-task", (Object[])new Object[0]), tIdInfos);
            this.getView().showSuccessNotification(msg, Integer.valueOf(3000));
        } else {
            List results = operateResults.stream().map(result -> result.toString()).collect(Collectors.toList());
            String OperateResultInfo = String.join((CharSequence)"", results);
            String msg = String.format(ResManager.loadKDString((String)"\u5904\u7406\u4efb\u52a1\u5931\u8d25\uff0c\u8be6\u7ec6\u4fe1\u606f\u5982\u4e0b\uff1a%s\u3002", (String)"AdminMonitorTaskData_2", (String)"bos-wf-task", (Object[])new Object[0]), OperateResultInfo);
            this.getView().showErrorNotification(msg);
        }
    }

    private BatchOperateResult handleBizTask(String clickKey, IDataModel model, List<Long> taskIds) {
        BatchOperateResult batchOperateResult = null;
        if (BTN_COMPLETE.equals(clickKey)) {
            DynamicObject user = (DynamicObject)model.getValue(COMPLETEUSER);
            String decption = (String)model.getValue(DECOPTIONNUMBER);
            String audit = (String)model.getValue(AUDITMESSAGE);
            if (user == null || decption == null || audit == null) {
                String msg = ResManager.loadKDString((String)"\u5b8c\u6210\u4efb\u52a1\u524d\uff0c\u8bf7\u68c0\u67e5\uff1a\u5904\u7406\u4eba\u3001\u51b3\u7b56\u9879\u3001\u5ba1\u6279\u610f\u89c1\u662f\u5426\u5f55\u5165\u3002", (String)"AdminMonitorTaskData_3", (String)"bos-wf-task", (Object[])new Object[0]);
                this.getView().showTipNotification(msg, Integer.valueOf(3000));
                return null;
            }
            CompleteOperationParam completeOperationParam = new CompleteOperationParam();
            completeOperationParam.setTaskIds(taskIds);
            completeOperationParam.setOperaterId(Long.valueOf(user.getLong("id")));
            completeOperationParam.setDecOptionNumber(decption);
            completeOperationParam.setAuditMessage(audit);
            completeOperationParam.setVariables(null);
            batchOperateResult = TaskRuntimeService.create().completeBizTask(completeOperationParam);
        } else if (BTN_DELETE.equals(clickKey)) {
            DynamicObject user = (DynamicObject)model.getValue(DELETEUSER);
            if (user == null) {
                String msg = ResManager.loadKDString((String)"\u5220\u9664\u4efb\u52a1\u524d\uff0c\u8bf7\u68c0\u67e5\uff1a\u5904\u7406\u4eba\u662f\u5426\u5f55\u5165\u3002", (String)"AdminMonitorTaskData_4", (String)"bos-wf-task", (Object[])new Object[0]);
                this.getView().showTipNotification(msg, Integer.valueOf(3000));
                return null;
            }
            DeleteOperationParam deleteOperationParam = new DeleteOperationParam();
            deleteOperationParam.setTaskIds(taskIds);
            deleteOperationParam.setOperaterId(Long.valueOf(user.getLong("id")));
            batchOperateResult = TaskRuntimeService.create().deleteBizTask(deleteOperationParam);
        }
        return batchOperateResult;
    }
}

