/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.message.channel.cache.MsgServiceCacheHelper;
import kd.bos.message.utils.MessageUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.ServiceImpl;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityImpl;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.task.cache.TaskModelCacheEntry;
import kd.bos.workflow.task.cache.TaskModelCacheHelper;
import kd.bos.workflow.task.converter.BpmnTaskJsonConverter;
import kd.bos.workflow.task.enumeration.TaskOperation;
import kd.bos.workflow.task.model.BizTask;
import kd.bos.workflow.task.model.BizTaskOperate;
import kd.bos.workflow.task.service.TaskModelService;
import kd.bos.workflow.task.sso.TrdSSOUtils;

public class TaskModelServiceImpl
extends ServiceImpl
implements TaskModelService {
    public TaskModelServiceImpl() {
    }

    public TaskModelServiceImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public BizTask getTaskModelDefinition(String taskModelNumber) {
        TaskModelCacheEntry taskModelDefinitionCache = this.getTaskModelDefinitionCache(taskModelNumber);
        if (taskModelDefinitionCache == null) {
            return null;
        }
        return taskModelDefinitionCache.getBizTask();
    }

    private List<BizTaskOperate> getTaskModelOperateDefinition(String taskModelNumber) {
        TaskModelCacheEntry taskModelDefinitionCache = this.getTaskModelDefinitionCache(taskModelNumber);
        if (taskModelDefinitionCache == null) {
            return null;
        }
        return taskModelDefinitionCache.getBizTaskOperates();
    }

    @Override
    public BizTaskOperate getTaskModelOperateDefinition(String taskModelNumber, TaskOperation taskOperation) {
        List<BizTaskOperate> bizTaskOperates = this.getTaskModelOperateDefinition(taskModelNumber);
        if (bizTaskOperates == null) {
            return null;
        }
        for (BizTaskOperate bizTaskOperate : bizTaskOperates) {
            if (!taskOperation.getValue().equals(bizTaskOperate.getOpNumber())) continue;
            return bizTaskOperate;
        }
        return null;
    }

    private TaskModelCacheEntry getTaskModelDefinitionCache(String taskModelNumber) {
        TaskModelCacheEntry taskModelDefinitionCacheEntry = TaskModelCacheHelper.getTaskModelDefinitionCacheEntry(taskModelNumber);
        if (taskModelDefinitionCacheEntry == null) {
            taskModelDefinitionCacheEntry = this.getTaskModelDefinitionFromDB(taskModelNumber);
            if (taskModelDefinitionCacheEntry == null) {
                return null;
            }
            TaskModelCacheHelper.addTaskModelDefinitonCacheEntry(taskModelNumber, taskModelDefinitionCacheEntry);
        }
        return taskModelDefinitionCacheEntry;
    }

    private TaskModelCacheEntry getTaskModelDefinitionFromDB(String taskModelNumber) {
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)taskModelNumber)};
        DynamicObject[] taskModels = BusinessDataServiceHelper.load((String)"wf_task_modeldef", (String)"id,number,resource,stenciltype,modifydate", (QFilter[])filters);
        if (taskModels == null || taskModels.length == 0) {
            return null;
        }
        DynamicObject taskModel = taskModels[0];
        String resource = taskModel.getLocaleString("resource").toString();
        JSONObject taskModelResource = JSONObject.parseObject((String)resource);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode taskModelJsonNode = (JsonNode)mapper.convertValue((Object)taskModelResource, JsonNode.class);
        BpmnTaskJsonConverter converter = new BpmnTaskJsonConverter();
        BizTask bizTask = converter.parseJsonNode("bizTask", taskModelJsonNode);
        TaskModelCacheEntry entry = new TaskModelCacheEntry();
        Date modifydate = taskModel.getDate("modifydate");
        entry.setUpdateTime(modifydate.getTime());
        entry.setBizTask(bizTask);
        entry.setBizTaskOperates(null);
        return entry;
    }

    private String getOperationLink(TaskInfo taskInfo, boolean isPc) {
        String resourceId;
        String operateUrl;
        if (taskInfo instanceof TaskEntityImpl) {
            TaskEntity taskEntity = (TaskEntity)taskInfo;
            operateUrl = isPc ? taskEntity.getUrl() : taskEntity.getMobileUrl();
            resourceId = taskEntity.getResourceId();
        } else {
            HistoricTaskInstanceEntity historicTaskEntity = (HistoricTaskInstanceEntity)taskInfo;
            operateUrl = isPc ? historicTaskEntity.getUrl() : historicTaskEntity.getMobileUrl();
            resourceId = historicTaskEntity.getResourceId();
        }
        if (operateUrl == null) {
            return "";
        }
        StringBuilder url = new StringBuilder(operateUrl);
        url.append(operateUrl.contains("?") ? "&" : "?").append("taskId=").append(taskInfo.getId()).append("&resourceId=").append(resourceId).append("&accountId=").append(RequestContext.get().getAccountId());
        return url.toString();
    }

    public String getFormServiceLink(TaskInfo taskInfo, boolean isPc) {
        String operationLink = this.getOperationLink(taskInfo, isPc);
        if (WfUtils.isEmpty((String)operationLink)) {
            return "";
        }
        String thridAppId = taskInfo.getTaskDefinitionKey();
        return TrdSSOUtils.getTrdUrl(thridAppId, operationLink);
    }

    @Override
    public boolean isExistOuterTaskModelDefinition() {
        String isExist = MsgServiceCacheHelper.getOuterTaskModelDefinitionSign();
        if (MessageUtils.isNotEmpty((String)isExist)) {
            return Boolean.parseBoolean(isExist);
        }
        String[] types = new String[]{"outernoentitytask", "outerentitytask"};
        QFilter[] filters = new QFilter[]{new QFilter("stenciltype", "in", (Object)types)};
        boolean exists = QueryServiceHelper.exists((String)"wf_task_modeldef", (QFilter[])filters);
        MsgServiceCacheHelper.putOuterTaskModelDefintionSign((String)String.valueOf(exists));
        return exists;
    }
}

