/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.task.utils;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.task.entity.TaskJobEntity;
import kd.bos.workflow.task.entity.TaskJobEntityManager;
import kd.bos.workflow.task.entity.TaskJobRetryLogEntityImpl;
import kd.bos.workflow.task.entity.TaskJobRetryLogEntityManager;

public class TaskJobUtils {
    private static Log logger = LogFactory.getLog(TaskJobUtils.class);
    public static final String SUCCESS = "success";

    public static void updateTaskJob(CommandContext commandContext, TaskJobEntityManager taskJobEntityManager, TaskJobEntity taskJobEntity, JobEntity jobEntity) {
        String exceptionMessage;
        if (jobEntity.isSuccess()) {
            exceptionMessage = SUCCESS;
            taskJobEntity.setTodoState(TaskJobEntity.TodoState.DEALSUCCESS.name());
        } else {
            exceptionMessage = jobEntity.getExceptionMessage();
            taskJobEntity.setTodoState(TaskJobEntity.TodoState.DEALFAIL.name());
        }
        taskJobEntity.setRetryCount(taskJobEntity.getRetryCount() + 1);
        taskJobEntity.setTraceId(RequestContext.get().getTraceId());
        taskJobEntity.setExceptionMessage(exceptionMessage);
        taskJobEntityManager.update((Entity)taskJobEntity);
        if (taskJobEntity.getRetryCount() > 1 || !jobEntity.isSuccess()) {
            TaskJobRetryLogEntityManager taskJobRetryLogEntityManager = (TaskJobRetryLogEntityManager)commandContext.getEntityManager(TaskJobRetryLogEntityManager.class);
            TaskJobRetryLogEntityImpl taskJobRetryLogEntity = new TaskJobRetryLogEntityImpl();
            taskJobRetryLogEntity.setChannelLogId(taskJobEntity.getId());
            if ("byHand".equalsIgnoreCase(TaskJobUtils.getRetryType(jobEntity.getJobHandlerConfiguration()))) {
                taskJobRetryLogEntity.setOperator((ILocaleString)new LocaleString(RequestContext.get().getUserName()));
            }
            taskJobRetryLogEntity.setRetryDate(WfUtils.now());
            taskJobRetryLogEntity.setResult(exceptionMessage);
            taskJobRetryLogEntity.setTraceId(RequestContext.get().getTraceId());
            taskJobRetryLogEntityManager.insert(taskJobRetryLogEntity);
        }
    }

    private static String getRetryType(String jobHandlerConfiguration) {
        if (WfUtils.isEmpty((String)jobHandlerConfiguration)) {
            return null;
        }
        Map configMap = (Map)SerializationUtils.fromJsonString((String)jobHandlerConfiguration, Map.class);
        if (WfUtils.isEmptyForMap((Map)configMap)) {
            return null;
        }
        Object type = configMap.get("retryType");
        if (WfUtils.isNullObject(type)) {
            return null;
        }
        return type.toString();
    }
}

