/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.system.opplugin;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.system.util.AdminsUtil;

public class AdminsDeleteOPPlugin
extends AbstractOperationServicePlugIn {
    private Log logger = LogFactory.getLog(AdminsDeleteOPPlugin.class);
    private static final String USERID = "userid";

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] dynamicObjects = e.getDataEntities();
        if (dynamicObjects == null || dynamicObjects.length <= 0) {
            return;
        }
        Object id = dynamicObjects[0].getPkValue();
        if (WfUtils.isNullObject((Object)id)) {
            return;
        }
        long userId = this.queryUserId(id);
        if (Long.valueOf(0L).equals(userId)) {
            return;
        }
        try (TXHandle tx = TX.requiresNew();){
            if (this.isNeedDeleteUserRole(id, userId)) {
                AdminsUtil.assignOrRemoveUserRole(userId, false);
            }
        }
    }

    private long queryUserId(Object id) {
        QFilter[] filters = null;
        QFilter idFilter = new QFilter("id", "=", id);
        filters = new QFilter[]{idFilter};
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"wf_administrator", (String)USERID, (QFilter[])filters);
        if (dynamicObject == null) {
            this.logger.warn("\u83b7\u53d6\u4e0d\u5230\u73b0\u6709\u4eba\u5458\u8bb0\u5f55\u4fe1\u606f");
            return 0L;
        }
        return dynamicObject.getLong(USERID);
    }

    private boolean isNeedDeleteUserRole(Object id, Object userId) {
        QFilter[] filters = null;
        QFilter userFilter = new QFilter(USERID, "=", userId);
        QFilter idFilter = new QFilter("id", "<>", id);
        filters = new QFilter[]{userFilter, idFilter};
        return !QueryServiceHelper.exists((String)"wf_administrator", (QFilter[])filters);
    }
}

