/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.channel.MessageChannelUtils;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.message.utils.MessageUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.engine.msg.MessageTypeEnum;
import kd.bos.workflow.engine.msg.info.MessageInfo;

public class SendMessageContext {
    private static Log logger = LogFactory.getLog(SendMessageContext.class);
    private Map<Long, ILocaleString> senderMapping = new HashMap<Long, ILocaleString>();
    private Map<String, MainEntityType> entityMapping = new HashMap<String, MainEntityType>();
    private Map<String, Map> typeMapping = new HashMap<String, Map>();
    private Map<String, MsgChannelInfo> channelMapping = new HashMap<String, MsgChannelInfo>();

    public Map<Long, ILocaleString> getSenderMapping() {
        return this.senderMapping;
    }

    public void setSenderMapping(Map<Long, ILocaleString> senderMapping) {
        this.senderMapping = senderMapping;
    }

    public Map<String, MainEntityType> getEntityMapping() {
        return this.entityMapping;
    }

    public void setEntityMapping(Map<String, MainEntityType> entityMapping) {
        this.entityMapping = entityMapping;
    }

    public Map<String, Map> getTypeMapping() {
        return this.typeMapping;
    }

    public void setTypeMapping(Map<String, Map> typeMapping) {
        this.typeMapping = typeMapping;
    }

    public Map<String, MsgChannelInfo> getChannelMapping() {
        return this.channelMapping;
    }

    public void setChannelMapping(Map<String, MsgChannelInfo> channelMapping) {
        this.channelMapping = channelMapping;
    }

    public SendMessageContext(List<MessageInfo> messageInfos) {
        HashSet<Long> senderIds = new HashSet<Long>(messageInfos.size());
        HashSet<String> entitys = new HashSet<String>(messageInfos.size());
        HashSet<String> types = new HashSet<String>(messageInfos.size());
        HashSet<String> channels = new HashSet<String>(messageInfos.size());
        for (MessageInfo messageInfo : messageInfos) {
            String scene;
            DynamicObject[] notifyType;
            if (!MessageUtils.isEmpty(messageInfo.getSenderId())) {
                senderIds.add(messageInfo.getSenderId());
            }
            if (MessageUtils.isEmpty((String)(notifyType = messageInfo.getNotifyType()))) {
                types.add(messageInfo.getType());
            } else {
                channels.addAll(MessageUtils.split((String)notifyType, ","));
            }
            if (MessageUtils.isNotEmpty(messageInfo.getEntityNumber())) {
                entitys.add(messageInfo.getEntityNumber());
            }
            if (MessageTypeEnum.isTaskMessageType((String)(scene = messageInfo.getTplScene()))) {
                entitys.add("wf_task");
            }
            if (MessageTypeEnum.isExecutionMessageType((String)scene)) {
                entitys.add("wf_hiprocinst");
            }
            if (!MessageTypeEnum.isHisTaskMessageType((String)scene)) continue;
            entitys.add("wf_hitaskinst");
        }
        if (!senderIds.isEmpty()) {
            try {
                QFilter[] filters = new QFilter[]{new QFilter("id", "in", senderIds), new QFilter("enable", "=", (Object)Character.valueOf('1'))};
                DynamicObject[] users = BusinessDataServiceHelper.load((String)"bos_user", (String)"id, name", (QFilter[])filters);
                if (users != null && users.length > 0) {
                    for (DynamicObject user : users) {
                        this.senderMapping.put(user.getLong("id"), user.getLocaleString("name"));
                    }
                }
            }
            catch (Exception e) {
                logger.warn(String.format("SendMessagesApi-MessageContext-sender: %s", MessageUtils.getExceptionStacktrace(e)));
            }
        }
        if (!entitys.isEmpty()) {
            for (String entity : entitys) {
                try {
                    MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entity);
                    this.entityMapping.put(entity, mainEntityType);
                }
                catch (Exception e) {
                    logger.warn(String.format("SendMessagesApi-MessageContext-entity: %s", MessageUtils.getExceptionStacktrace(e)));
                }
            }
        }
        if (!types.isEmpty()) {
            for (String type : types) {
                try {
                    Map<String, Object> typsInfos = MessageUtils.getMessageTypeInfo(type);
                    this.typeMapping.put(type, typsInfos);
                    Object channelInfo = typsInfos.get("channels");
                    if (channelInfo == null) continue;
                    channels.addAll(MessageUtils.split((String)channelInfo, ","));
                }
                catch (Exception e) {
                    logger.warn(String.format("SendMessagesApi-MessageContext-type: %s", MessageUtils.getExceptionStacktrace(e)));
                }
            }
        }
        if (!channels.isEmpty()) {
            for (String channel : channels) {
                if (this.channelMapping.containsKey(channel)) continue;
                try {
                    MsgChannelInfo config = MessageChannelUtils.getChannelConfig(channel);
                    this.channelMapping.put(channel, config);
                }
                catch (Exception e) {
                    logger.warn(String.format("SendMessagesApi-MessageContext-channel: %s", MessageUtils.getExceptionStacktrace(e)));
                }
            }
        }
    }
}

