/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.channel.cache;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.ServiceCfgInfo;
import kd.bos.message.channel.cache.MsgServiceCacheMrg;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class MsgServiceCache {
    public static final String ENTITYID_SRVCFG = "msg_srvcfg";
    public static final String ENTITYID_MSGCHANNEL = "msg_channel";
    private static Log logger = LogFactory.getLog(MsgServiceCache.class);
    private static final String[] FIELDARR = new String[]{"id", "modifydate", "createdate", "pubacclist", "hashtag"};

    public static ServiceCfgInfo getServiceCfg() {
        String sign;
        ServiceCfgInfo serviceCfgInfo = null;
        String type = MsgServiceCacheMrg.getType4ServiceCfg();
        String serviceCfgInfoStr = MsgServiceCacheMrg.getCache(type, sign = "srvcfg");
        if (MsgServiceCacheMrg.isLoaded(serviceCfgInfoStr)) {
            if (!MsgServiceCacheMrg.isData(serviceCfgInfoStr)) {
                return serviceCfgInfo;
            }
            serviceCfgInfo = (ServiceCfgInfo)SerializationUtils.fromJsonString((String)serviceCfgInfoStr, ServiceCfgInfo.class);
        } else {
            serviceCfgInfo = MsgServiceCache.reloadServiceCfg();
            MsgServiceCache.cacheAllCodeRuleByEntity(sign, serviceCfgInfo);
        }
        return serviceCfgInfo;
    }

    private static ServiceCfgInfo reloadServiceCfg() {
        ServiceCfgInfo serviceCfgInfo = null;
        String selectFields = "smtphost,smtpport,username,password,fromaccount,fromusername,smsapiurl,clientid,clientsecret,smscode,pubaccapiurl";
        QFilter[] filters = new QFilter[0];
        DynamicObject[] serviceCfgCollection = BusinessDataServiceHelper.load((String)ENTITYID_SRVCFG, (String)selectFields, (QFilter[])filters);
        if (serviceCfgCollection == null || serviceCfgCollection.length == 0) {
            return serviceCfgInfo;
        }
        serviceCfgInfo = new ServiceCfgInfo();
        serviceCfgInfo.setSmtphost(serviceCfgCollection[0].getString("smtphost"));
        serviceCfgInfo.setSmtpport(serviceCfgCollection[0].getString("smtpport"));
        serviceCfgInfo.setUsername(serviceCfgCollection[0].getString("username"));
        serviceCfgInfo.setPassword(serviceCfgCollection[0].getString("password"));
        serviceCfgInfo.setFromaccount(serviceCfgCollection[0].getString("fromaccount"));
        serviceCfgInfo.setFromusername(serviceCfgCollection[0].getString("fromusername"));
        serviceCfgInfo.setSmsapiurl(serviceCfgCollection[0].getString("smsapiurl"));
        serviceCfgInfo.setClientid(serviceCfgCollection[0].getString("clientid"));
        serviceCfgInfo.setClientsecret(serviceCfgCollection[0].getString("clientsecret"));
        serviceCfgInfo.setSmscode(serviceCfgCollection[0].getString("smscode"));
        serviceCfgInfo.setPubaccapiurl(serviceCfgCollection[0].getString("pubaccapiurl"));
        return serviceCfgInfo;
    }

    private static void cacheAllCodeRuleByEntity(String key, ServiceCfgInfo serviceCfgInfo) {
        String type = MsgServiceCacheMrg.getType4ServiceCfg();
        String value = "DATA_LOADED";
        if (serviceCfgInfo == null) {
            MsgServiceCacheMrg.putCache(type, key, value);
            return;
        }
        String serviceCfgStr = null;
        serviceCfgStr = SerializationUtils.toJsonString((Object)serviceCfgInfo);
        MsgServiceCacheMrg.putCache(type, key, serviceCfgStr);
    }

    @SdkInternal
    public static MsgChannelInfo getMsgChannel(String number) {
        MsgChannelInfo msgChannelInfo = null;
        String type = MsgServiceCacheMrg.getType4ServiceCfg();
        String msgChannelInfoStr = MsgServiceCacheMrg.getCache(type, number);
        boolean needRefreshCache = true;
        if (MsgServiceCacheMrg.isLoaded(msgChannelInfoStr)) {
            if (!MsgServiceCacheMrg.isData(msgChannelInfoStr)) {
                return msgChannelInfo;
            }
            msgChannelInfo = (MsgChannelInfo)SerializationUtils.fromJsonString((String)msgChannelInfoStr, MsgChannelInfo.class);
            if (msgChannelInfo.getName().contains("zh_CN")) {
                needRefreshCache = false;
            }
        }
        if (needRefreshCache) {
            msgChannelInfo = MsgServiceCache.reloadMsgChannel(number);
            MsgServiceCache.cacheAllCodeRuleByChannelEntity(number, msgChannelInfo);
        }
        return msgChannelInfo;
    }

    public static void refreshMsgChannelCacheInfo(String number, boolean isDelete) {
        if (isDelete) {
            MsgServiceCache.cacheAllCodeRuleByChannelEntity(number, null);
        } else {
            MsgChannelInfo msgChannelInfo = MsgServiceCache.reloadMsgChannel(number);
            MsgServiceCache.cacheAllCodeRuleByChannelEntity(number, msgChannelInfo);
            MsgServiceCache.updateSysnoticeCache();
        }
    }

    private static void updateSysnoticeCache() {
        MsgChannelInfo msgChannelInfo = MsgServiceCache.reloadMsgChannel("sysnotice");
        MsgServiceCache.cacheAllCodeRuleByChannelEntity("sysnotice", msgChannelInfo);
    }

    private static MsgChannelInfo reloadMsgChannel(String number) {
        QFilter q2;
        QFilter q1;
        QFilter[] filters;
        MsgChannelInfo msgChannelInfo = null;
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)ENTITYID_MSGCHANNEL);
        if (met == null) {
            return msgChannelInfo;
        }
        DataEntityPropertyCollection collection = EntityMetadataCache.getDataEntityType((String)ENTITYID_MSGCHANNEL).getProperties();
        if (collection == null) {
            return msgChannelInfo;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < collection.size(); ++i) {
            if (((IDataEntityProperty)collection.get(i)).getPropertyType() == LocaleDynamicObjectCollection.class) continue;
            if (i == collection.size() - 1) {
                sb.append(((IDataEntityProperty)collection.get(i)).getName());
                continue;
            }
            sb.append(((IDataEntityProperty)collection.get(i)).getName()).append(',');
        }
        String selectFields = sb.toString();
        DynamicObject[] msgChannelCol = BusinessDataServiceHelper.load((String)ENTITYID_MSGCHANNEL, (String)selectFields, (QFilter[])(filters = new QFilter[]{q1 = new QFilter("enable", "=", (Object)Boolean.TRUE), q2 = new QFilter("number", "=", (Object)number)}));
        if (msgChannelCol == null || msgChannelCol.length == 0) {
            return msgChannelInfo;
        }
        msgChannelInfo = new MsgChannelInfo();
        DynamicObject channelDo = msgChannelCol[0];
        try {
            MsgServiceCache.putPropertyInChannelInfo(msgChannelInfo, MsgChannelInfo.class, channelDo, selectFields.split(","));
        }
        catch (Exception e) {
            logger.warn("putPropertyInChannelInfo-reflect put property is fail: " + e.getMessage());
        }
        return msgChannelInfo;
    }

    private static void putPropertyInChannelInfo(MsgChannelInfo channelInfo, Class<?> clazz, DynamicObject channelDo, String[] properties) throws Exception {
        Field[] fields;
        block0: for (Field field : fields = clazz.getDeclaredFields()) {
            String paramName = field.getName();
            boolean belongToArr = false;
            for (int i = 0; i < FIELDARR.length; ++i) {
                if (!FIELDARR[i].equalsIgnoreCase(paramName)) continue;
                belongToArr = true;
                break;
            }
            if (Modifier.isFinal(field.getModifiers()) || belongToArr) continue;
            ReflectionUtils.makeAccessible((Field)field);
            String type = field.getGenericType().getTypeName();
            for (String p : properties) {
                if (!paramName.equalsIgnoreCase(p)) continue;
                String paramValue = "";
                if (channelDo.get(p) instanceof ILocaleString) {
                    ILocaleString v = channelDo.getLocaleString(p);
                    paramValue = p.equalsIgnoreCase("name") ? SerializationUtils.toJsonString((Object)v) : v.getLocaleValue();
                } else {
                    paramValue = channelDo.get(p) instanceof DynamicObject ? channelDo.getDynamicObject(p).getString("id") : channelDo.getString(p);
                }
                if (type.endsWith("Object")) {
                    field.set(channelInfo, paramValue);
                    continue block0;
                }
                if (type.endsWith("String")) {
                    field.set(channelInfo, paramValue);
                    continue block0;
                }
                if (type.endsWith("int") || type.endsWith("Integer")) {
                    field.set(channelInfo, Integer.valueOf(paramValue));
                    continue block0;
                }
                if (type.endsWith("boolean") || type.endsWith("Boolean")) {
                    field.set(channelInfo, Boolean.valueOf(paramValue));
                    continue block0;
                }
                if (!type.endsWith("long") && !type.endsWith("Long")) continue block0;
                field.set(channelInfo, Long.valueOf(paramValue));
                continue block0;
            }
        }
    }

    private static void cacheAllCodeRuleByChannelEntity(String key, MsgChannelInfo msgChannelInfo) {
        String type = MsgServiceCacheMrg.getType4ServiceCfg();
        String value = "DATA_LOADED";
        if (msgChannelInfo == null) {
            MsgServiceCacheMrg.putCache(type, key, value);
            return;
        }
        String serviceCfgStr = null;
        serviceCfgStr = SerializationUtils.toJsonString((Object)msgChannelInfo);
        MsgServiceCacheMrg.putCache(type, key, serviceCfgStr);
    }
}

