/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.channel.cache;

import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.CacheKeyUtil;

public class MsgServiceCacheMrg {
    private static final String BS_MESSAGE_SERVICE_REGION = "MESSAGE_SERVICE";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("MESSAGE_SERVICE", new DistributeCacheHAPolicy());
    private static final String BS_MESSAGE_SERVICE = "BS_MESSAGE_SERVICE_";
    public static final String DATA_MESSAGE_SERVICE_CFG = "BS_MESSAGE_SERVICE__CFG";
    public static final String LOADED = "DATA_LOADED";

    private static String getAcctId() {
        String acctId = CacheKeyUtil.getAcctId();
        if (acctId == null || acctId.length() == 0) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u5f53\u524d\u79df\u6237\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MsgServiceCacheMrg_0", (String)"bos-message-common", (Object[])new Object[0]));
        }
        return acctId;
    }

    public static String getType4ServiceCfg() {
        return "BS_MESSAGE_SERVICE__CFG_" + MsgServiceCacheMrg.getAcctId();
    }

    public static void clearAllCache() {
        cache.removeType(MsgServiceCacheMrg.getType4ServiceCfg());
    }

    public static void clearCache(String type) {
        cache.removeType(type);
    }

    public static void clearCache(String type, String key) {
        cache.remove(type, key);
    }

    public static void clearCacheWithPrefix(String type, String keyPrefix) {
        Map kvs = cache.getAll(type);
        if (kvs != null && kvs.size() > 0) {
            String[] keys = new String[kvs.size()];
            int i = 0;
            for (Map.Entry entry : kvs.entrySet()) {
                if (!((String)entry.getKey()).startsWith(keyPrefix)) continue;
                keys[i++] = (String)entry.getValue();
            }
            cache.remove(type, keys);
        }
    }

    public static String getCache(String type, String key) {
        return (String)cache.get(type, key);
    }

    public static void putCache(String type, String key, String value) {
        cache.put(type, key, (Object)value);
    }

    public static void putCache(String type, Map<String, String> values) {
        cache.put(type, values);
    }

    public static Map<String, String> getCache(String type) {
        return cache.getAll(type);
    }

    public static void dataLoaded(String type, String key) {
        cache.put(type, key, (Object)LOADED);
    }

    public static boolean isData(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        return !value.equals(LOADED);
    }

    public static boolean isLoaded(String value) {
        return value != null && value.length() != 0;
    }
}

